/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.alert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.enums.AlertType;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.dao.AlertDao;
import org.apache.dolphinscheduler.dao.entity.Alert;
import org.apache.dolphinscheduler.dao.entity.DqExecuteResult;
import org.apache.dolphinscheduler.dao.entity.DqExecuteResultAlertContent;
import org.apache.dolphinscheduler.dao.entity.ProcessAlertContent;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.ProjectUser;
import org.apache.dolphinscheduler.dao.entity.TaskAlertContent;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.apache.dolphinscheduler.plugin.task.api.enums.dp.DqTaskState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProcessAlertManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessAlertManager.class);
    @Autowired
    private AlertDao alertDao;
    @Autowired
    private ProcessDefinitionLogMapper processDefinitionLogMapper;
    @Autowired
    private UserMapper userMapper;

    private String getCommandCnName(CommandType commandType) {
        switch (commandType) {
            case RECOVER_TOLERANCE_FAULT_PROCESS: {
                return "recover tolerance fault process";
            }
            case RECOVER_SUSPENDED_PROCESS: {
                return "recover suspended process";
            }
            case START_CURRENT_TASK_PROCESS: {
                return "start current task process";
            }
            case START_FAILURE_TASK_PROCESS: {
                return "start failure task process";
            }
            case START_PROCESS: {
                return "start process";
            }
            case REPEAT_RUNNING: {
                return "repeat running";
            }
            case SCHEDULER: {
                return "scheduler";
            }
            case COMPLEMENT_DATA: {
                return "complement data";
            }
            case PAUSE: {
                return "pause";
            }
            case STOP: {
                return "stop";
            }
        }
        return "unknown type";
    }

    public String getContentProcessInstance(ProcessInstance processInstance, List<TaskInstance> taskInstances, ProjectUser projectUser) {
        String res = "";
        ProcessDefinitionLog processDefinitionLog = this.processDefinitionLogMapper.queryByDefinitionCodeAndVersion(processInstance.getProcessDefinitionCode().longValue(), processInstance.getProcessDefinitionVersion());
        String modifyBy = "";
        if (processDefinitionLog != null) {
            User operator = this.userMapper.selectById(processDefinitionLog.getOperator());
            String string = modifyBy = operator == null ? "" : operator.getUserName();
        }
        if (processInstance.getState().isSuccess()) {
            ArrayList<ProcessAlertContent> successTaskList = new ArrayList<ProcessAlertContent>(1);
            ProcessAlertContent processAlertContent = ProcessAlertContent.builder().projectCode(Long.valueOf(projectUser.getProjectCode())).projectName(projectUser.getProjectName()).owner(projectUser.getUserName()).processId(processInstance.getId()).processDefinitionCode(processInstance.getProcessDefinitionCode()).processName(processInstance.getName()).processType(processInstance.getCommandType()).processState(processInstance.getState()).modifyBy(modifyBy).recovery(processInstance.getRecovery()).runTimes(Integer.valueOf(processInstance.getRunTimes())).processStartTime(processInstance.getStartTime()).processEndTime(processInstance.getEndTime()).processHost(processInstance.getHost()).build();
            successTaskList.add(processAlertContent);
            res = JSONUtils.toJsonString(successTaskList);
        } else if (processInstance.getState().isFailure()) {
            ArrayList<ProcessAlertContent> failedTaskList = new ArrayList<ProcessAlertContent>();
            for (TaskInstance task : taskInstances) {
                if (task.getState().isSuccess()) continue;
                ProcessAlertContent processAlertContent = ProcessAlertContent.builder().projectCode(Long.valueOf(projectUser.getProjectCode())).projectName(projectUser.getProjectName()).owner(projectUser.getUserName()).processId(processInstance.getId()).processDefinitionCode(processInstance.getProcessDefinitionCode()).processName(processInstance.getName()).modifyBy(modifyBy).taskCode(Long.valueOf(task.getTaskCode())).taskName(task.getName()).taskType(task.getTaskType()).taskState(task.getState()).taskStartTime(task.getStartTime()).taskEndTime(task.getEndTime()).taskHost(task.getHost()).taskPriority(task.getTaskInstancePriority().getDescp()).logPath(task.getLogPath()).build();
                failedTaskList.add(processAlertContent);
            }
            res = JSONUtils.toJsonString(failedTaskList);
        }
        return res;
    }

    private String getWorkerToleranceContent(ProcessInstance processInstance, List<TaskInstance> toleranceTaskList) {
        ArrayList<ProcessAlertContent> toleranceTaskInstanceList = new ArrayList<ProcessAlertContent>();
        ProcessDefinitionLog processDefinitionLog = this.processDefinitionLogMapper.queryByDefinitionCodeAndVersion(processInstance.getProcessDefinitionCode().longValue(), processInstance.getProcessDefinitionVersion());
        String modifyBy = "";
        if (processDefinitionLog != null) {
            User operator = this.userMapper.selectById(processDefinitionLog.getOperator());
            modifyBy = operator == null ? "" : operator.getUserName();
        }
        for (TaskInstance taskInstance : toleranceTaskList) {
            ProcessAlertContent processAlertContent = ProcessAlertContent.builder().processId(processInstance.getId()).processDefinitionCode(processInstance.getProcessDefinitionCode()).processName(processInstance.getName()).modifyBy(modifyBy).taskCode(Long.valueOf(taskInstance.getTaskCode())).taskName(taskInstance.getName()).taskHost(taskInstance.getHost()).taskPriority(taskInstance.getTaskInstancePriority().getDescp()).retryTimes(Integer.valueOf(taskInstance.getRetryTimes())).build();
            toleranceTaskInstanceList.add(processAlertContent);
        }
        return JSONUtils.toJsonString(toleranceTaskInstanceList);
    }

    public void sendAlertWorkerToleranceFault(ProcessInstance processInstance, List<TaskInstance> toleranceTaskList) {
        try {
            Alert alert = new Alert();
            alert.setTitle("worker fault tolerance");
            String content = this.getWorkerToleranceContent(processInstance, toleranceTaskList);
            alert.setContent(content);
            alert.setWarningType(WarningType.FAILURE);
            alert.setCreateTime(new Date());
            alert.setAlertGroupId(Integer.valueOf(processInstance.getWarningGroupId() == null ? 1 : processInstance.getWarningGroupId()));
            alert.setAlertType(AlertType.FAULT_TOLERANCE_WARNING);
            this.alertDao.addAlert(alert);
        }
        catch (Exception e) {
            log.error("send alert failed:{} ", (Object)e.getMessage());
        }
    }

    public void sendAlertProcessInstance(ProcessInstance processInstance, List<TaskInstance> taskInstances, ProjectUser projectUser) {
        if (!this.isNeedToSendWarning(processInstance)) {
            return;
        }
        Alert alert = new Alert();
        String cmdName = this.getCommandCnName(processInstance.getCommandType());
        String success = processInstance.getState().isSuccess() ? "success" : "failed";
        alert.setTitle(cmdName + " " + success);
        alert.setWarningType(processInstance.getState().isSuccess() ? WarningType.SUCCESS : WarningType.FAILURE);
        String content = this.getContentProcessInstance(processInstance, taskInstances, projectUser);
        alert.setContent(content);
        alert.setAlertGroupId(processInstance.getWarningGroupId());
        alert.setCreateTime(new Date());
        alert.setProjectCode(Long.valueOf(projectUser.getProjectCode()));
        alert.setProcessDefinitionCode(processInstance.getProcessDefinitionCode());
        alert.setProcessInstanceId(processInstance.getId());
        alert.setAlertType(processInstance.getState().isSuccess() ? AlertType.PROCESS_INSTANCE_SUCCESS : AlertType.PROCESS_INSTANCE_FAILURE);
        this.alertDao.addAlert(alert);
    }

    public boolean isNeedToSendWarning(ProcessInstance processInstance) {
        if (Flag.YES == processInstance.getIsSubProcess()) {
            return false;
        }
        boolean sendWarning = false;
        WarningType warningType = processInstance.getWarningType();
        switch (warningType) {
            case ALL: {
                if (!processInstance.getState().isFinished()) break;
                sendWarning = true;
                break;
            }
            case SUCCESS: {
                if (!processInstance.getState().isSuccess()) break;
                sendWarning = true;
                break;
            }
            case FAILURE: {
                if (!processInstance.getState().isFailure()) break;
                sendWarning = true;
                break;
            }
        }
        return sendWarning;
    }

    public void closeAlert(ProcessInstance processInstance) {
        if (!PropertyUtils.getBoolean((String)"alert.auto-close", (Boolean)false).booleanValue()) {
            return;
        }
        List alerts = this.alertDao.listAlerts(processInstance.getId().intValue());
        if (CollectionUtils.isEmpty((Collection)alerts)) {
            return;
        }
        Alert alert = new Alert();
        alert.setAlertGroupId(processInstance.getWarningGroupId());
        alert.setUpdateTime(new Date());
        alert.setCreateTime(new Date());
        alert.setProjectCode(Long.valueOf(processInstance.getProcessDefinition().getProjectCode()));
        alert.setProcessDefinitionCode(processInstance.getProcessDefinitionCode());
        alert.setProcessInstanceId(processInstance.getId());
        alert.setAlertType(AlertType.CLOSE_ALERT);
        this.alertDao.addAlert(alert);
    }

    public void sendProcessTimeoutAlert(ProcessInstance processInstance, ProjectUser projectUser) {
        this.alertDao.sendProcessTimeoutAlert(processInstance, projectUser);
    }

    public void sendDataQualityTaskExecuteResultAlert(DqExecuteResult result, ProcessInstance processInstance) {
        Alert alert = new Alert();
        String state = DqTaskState.of((Integer)result.getState()).getDescription();
        alert.setTitle("DataQualityResult [" + result.getTaskName() + "] " + state);
        String content = this.getDataQualityAlterContent(result);
        alert.setContent(content);
        alert.setAlertGroupId(processInstance.getWarningGroupId());
        alert.setCreateTime(new Date());
        alert.setProjectCode(Long.valueOf(result.getProjectCode()));
        alert.setProcessDefinitionCode(processInstance.getProcessDefinitionCode());
        alert.setProcessInstanceId(processInstance.getId());
        alert.setAlertType(processInstance.getState().isSuccess() ? AlertType.PROCESS_INSTANCE_SUCCESS : AlertType.PROCESS_INSTANCE_FAILURE);
        this.alertDao.addAlert(alert);
    }

    public void sendTaskErrorAlert(TaskInstance taskInstance, ProcessInstance processInstance) {
        Alert alert = new Alert();
        alert.setTitle("Task [" + taskInstance.getName() + "] Failure Warning");
        String content = this.getTaskAlterContent(taskInstance);
        alert.setContent(content);
        alert.setAlertGroupId(processInstance.getWarningGroupId());
        alert.setCreateTime(new Date());
        alert.setProcessDefinitionCode(processInstance.getProcessDefinitionCode());
        alert.setProcessInstanceId(processInstance.getId());
        alert.setAlertType(AlertType.TASK_FAILURE);
        this.alertDao.addAlert(alert);
    }

    public String getDataQualityAlterContent(DqExecuteResult result) {
        DqExecuteResultAlertContent content = DqExecuteResultAlertContent.newBuilder().processDefinitionId(result.getProcessDefinitionId()).processDefinitionName(result.getProcessDefinitionName()).processInstanceId(result.getProcessInstanceId()).processInstanceName(result.getProcessInstanceName()).taskInstanceId(result.getTaskInstanceId()).taskName(result.getTaskName()).ruleType(result.getRuleType()).ruleName(result.getRuleName()).statisticsValue(result.getStatisticsValue()).comparisonValue(result.getComparisonValue()).checkType(result.getCheckType()).threshold(result.getThreshold()).operator(result.getOperator()).failureStrategy(result.getFailureStrategy()).userId(result.getUserId()).userName(result.getUserName()).state(result.getState()).errorDataPath(result.getErrorOutputPath()).build();
        return JSONUtils.toJsonString((Object)content);
    }

    public String getTaskAlterContent(TaskInstance taskInstance) {
        TaskAlertContent content = TaskAlertContent.builder().processInstanceName(taskInstance.getProcessInstanceName()).processInstanceId(taskInstance.getProcessInstanceId()).taskInstanceId(taskInstance.getId().intValue()).taskName(taskInstance.getName()).taskType(taskInstance.getTaskType()).state(taskInstance.getState()).startTime(taskInstance.getStartTime()).endTime(taskInstance.getEndTime()).host(taskInstance.getHost()).taskPriority(taskInstance.getTaskInstancePriority().getDescp()).logPath(taskInstance.getLogPath()).build();
        return JSONUtils.toJsonString((Object)content);
    }

    public void sendTaskTimeoutAlert(ProcessInstance processInstance, TaskInstance taskInstance, ProjectUser projectUser) {
        this.alertDao.sendTaskTimeoutAlert(processInstance, taskInstance, projectUser);
    }

    public void sendProcessBlockingAlert(ProcessInstance processInstance, ProjectUser projectUser) {
        Alert alert = new Alert();
        String cmdName = this.getCommandCnName(processInstance.getCommandType());
        ArrayList<ProcessAlertContent> blockingNodeList = new ArrayList<ProcessAlertContent>(1);
        ProcessDefinitionLog processDefinitionLog = this.processDefinitionLogMapper.queryByDefinitionCodeAndVersion(processInstance.getProcessDefinitionCode().longValue(), processInstance.getProcessDefinitionVersion());
        String modifyBy = "";
        if (processDefinitionLog != null) {
            User operator = this.userMapper.selectById(processDefinitionLog.getOperator());
            modifyBy = operator == null ? "" : operator.getUserName();
        }
        ProcessAlertContent processAlertContent = ProcessAlertContent.builder().projectCode(Long.valueOf(projectUser.getProjectCode())).projectName(projectUser.getProjectName()).owner(projectUser.getUserName()).processId(processInstance.getId()).processName(processInstance.getName()).processType(processInstance.getCommandType()).processState(processInstance.getState()).modifyBy(modifyBy).runTimes(Integer.valueOf(processInstance.getRunTimes())).processStartTime(processInstance.getStartTime()).processEndTime(processInstance.getEndTime()).processHost(processInstance.getHost()).build();
        blockingNodeList.add(processAlertContent);
        String content = JSONUtils.toJsonString(blockingNodeList);
        alert.setTitle(cmdName + " Blocked");
        alert.setContent(content);
        alert.setAlertGroupId(processInstance.getWarningGroupId());
        alert.setCreateTime(new Date());
        alert.setProjectCode(Long.valueOf(projectUser.getProjectCode()));
        alert.setProcessDefinitionCode(processInstance.getProcessDefinitionCode());
        alert.setProcessInstanceId(processInstance.getId());
        alert.setAlertType(AlertType.PROCESS_INSTANCE_BLOCKED);
        this.alertDao.addAlert(alert);
    }
}

