/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.utils;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.service.utils.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessUtils.class);
    private static final Pattern MACPATTERN = Pattern.compile("-[+|-]-\\s(\\d+)");
    private static final Pattern WINDOWSATTERN = Pattern.compile("\\w+\\((\\d+)\\)");

    static String getKerberosInitCommand() {
        log.info("get kerberos init command");
        StringBuilder kerberosCommandBuilder = new StringBuilder();
        boolean hadoopKerberosState = PropertyUtils.getBoolean((String)"hadoop.security.authentication.startup.state", (Boolean)false);
        if (hadoopKerberosState) {
            kerberosCommandBuilder.append("export KRB5_CONFIG=").append(PropertyUtils.getString((String)"java.security.krb5.conf.path")).append("\n\n").append(String.format("kinit -k -t %s %s || true", PropertyUtils.getString((String)"login.user.keytab.path"), PropertyUtils.getString((String)"login.user.keytab.username"))).append("\n\n");
            log.info("kerberos init command: {}", (Object)kerberosCommandBuilder);
        }
        return kerberosCommandBuilder.toString();
    }

    private static void execYarnKillCommand(Logger logger, String tenantCode, String appId, String commandFile, String cmd) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("#!/bin/sh\n");
            sb.append("BASEDIR=$(cd `dirname $0`; pwd)\n");
            sb.append("cd $BASEDIR\n");
            if (CommonUtils.getSystemEnvPath() != null) {
                sb.append("source ").append(CommonUtils.getSystemEnvPath()).append("\n");
            }
            sb.append("\n\n");
            sb.append(cmd);
            File f = new File(commandFile);
            if (!f.exists()) {
                FileUtils.writeStringToFile((File)new File(commandFile), (String)sb.toString(), (Charset)StandardCharsets.UTF_8);
            }
            String runCmd = String.format("%s %s", "sh", commandFile);
            runCmd = OSUtils.getSudoCmd((String)tenantCode, (String)runCmd);
            log.info("kill cmd:{}", (Object)runCmd);
            OSUtils.exeCmd((String)runCmd);
        }
        catch (Exception e) {
            log.error(String.format("Kill yarn application app id [%s] failed: [%s]", appId, e.getMessage()));
        }
    }

    public static String getPidsStr(int processId) throws Exception {
        String pids;
        List<String> pidList = new ArrayList<String>();
        Matcher mat = null;
        if (SystemUtils.IS_OS_MAC) {
            pids = OSUtils.exeCmd((String)String.format("%s -sp %d", "pstree", processId));
            if (null != pids) {
                mat = MACPATTERN.matcher(pids);
            }
        } else {
            pids = OSUtils.exeCmd((String)String.format("%s -p %d", "pstree", processId));
            if (null != pids) {
                mat = WINDOWSATTERN.matcher(pids);
            }
        }
        if (null != mat) {
            while (mat.find()) {
                pidList.add(mat.group(1));
            }
        }
        if (OSUtils.isSudoEnable() && !pidList.isEmpty()) {
            pidList = pidList.subList(1, pidList.size());
        }
        return String.join((CharSequence)" ", pidList).trim();
    }

    @Nullable
    public static List<String> killApplication(@NonNull List<String> appIds, @NonNull TaskExecutionContext taskExecutionContext) {
        if (appIds == null) {
            throw new NullPointerException("appIds is marked non-null but is null");
        }
        if (taskExecutionContext == null) {
            throw new NullPointerException("taskExecutionContext is marked non-null but is null");
        }
        try {
            Thread.sleep(1000L);
            if (CollectionUtils.isNotEmpty(appIds)) {
                taskExecutionContext.setAppIds(String.join((CharSequence)",", appIds));
                if (StringUtils.isEmpty((CharSequence)taskExecutionContext.getExecutePath())) {
                    taskExecutionContext.setExecutePath(org.apache.dolphinscheduler.common.utils.FileUtils.getTaskInstanceWorkingDirectory((String)taskExecutionContext.getTenantCode(), (long)taskExecutionContext.getProjectCode(), (long)taskExecutionContext.getProcessDefineCode(), (int)taskExecutionContext.getProcessDefineVersion(), (int)taskExecutionContext.getProcessInstanceId(), (int)taskExecutionContext.getTaskInstanceId()));
                }
                org.apache.dolphinscheduler.common.utils.FileUtils.createDirectoryWith755((Path)Paths.get(taskExecutionContext.getExecutePath(), new String[0]));
                org.apache.dolphinscheduler.plugin.task.api.utils.ProcessUtils.cancelApplication((TaskExecutionContext)taskExecutionContext);
                return appIds;
            }
            log.info("The current appId is empty, don't need to kill the yarn job, taskInstanceId: {}", (Object)taskExecutionContext.getTaskInstanceId());
        }
        catch (Exception e) {
            log.error("Kill yarn job failure, taskInstanceId: {}", (Object)taskExecutionContext.getTaskInstanceId(), (Object)e);
        }
        return Collections.emptyList();
    }
}

