/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.datasource;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.conf.HiveConf;

public class HiveConfUtils {
    private HiveConfUtils() {
        throw new UnsupportedOperationException("Construct HiveConfUtils");
    }

    public static HiveConf getInstance() {
        return HiveConfHandler.singleton;
    }

    public static Map<String, Object> getHiveConfVars() {
        return HiveConfHandler.hiveConfVars;
    }

    public static boolean isHiveConfVar(String conf) {
        String confKey = conf.split("=")[0];
        Map<String, Object> hiveConfVars = HiveConfUtils.getHiveConfVars();
        if (hiveConfVars.get(confKey) != null) {
            return true;
        }
        HiveConf hiveConf = HiveConfUtils.getInstance();
        String hiveAuthorizationSqlStdAuthConfigWhitelist = hiveConf.getVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_SQL_STD_AUTH_CONFIG_WHITELIST);
        Pattern modWhiteListPattern = Pattern.compile(hiveAuthorizationSqlStdAuthConfigWhitelist);
        Matcher matcher = modWhiteListPattern.matcher(confKey);
        return matcher.matches();
    }

    private static class HiveConfHandler {
        private static HiveConf singleton = new HiveConf();
        private static Map<String, Object> hiveConfVars = new HashMap<String, Object>();

        private HiveConfHandler() {
        }

        static {
            Arrays.stream(HiveConf.ConfVars.values()).forEach(confVar -> hiveConfVars.put(confVar.varname, confVar));
        }
    }
}

