/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.datasource.oracle;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.dolphinscheduler.plugin.task.datasource.AbstractDatasourceProcessor;
import org.apache.dolphinscheduler.plugin.task.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.plugin.task.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.task.datasource.ConnectionParam;
import org.apache.dolphinscheduler.plugin.task.datasource.PasswordUtils;
import org.apache.dolphinscheduler.plugin.task.datasource.oracle.OracleConnectionParam;
import org.apache.dolphinscheduler.plugin.task.datasource.oracle.OracleDatasourceParamDTO;
import org.apache.dolphinscheduler.spi.enums.DbConnectType;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.apache.dolphinscheduler.spi.utils.JSONUtils;
import org.apache.dolphinscheduler.spi.utils.StringUtils;

public class OracleDatasourceProcessor
extends AbstractDatasourceProcessor {
    @Override
    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        OracleConnectionParam connectionParams = (OracleConnectionParam)this.createConnectionParams(connectionJson);
        OracleDatasourceParamDTO oracleDatasourceParamDTO = new OracleDatasourceParamDTO();
        oracleDatasourceParamDTO.setDatabase(connectionParams.getDatabase());
        oracleDatasourceParamDTO.setUserName(connectionParams.getUser());
        oracleDatasourceParamDTO.setOther(this.parseOther(connectionParams.getOther()));
        String hostSeperator = "//";
        if (DbConnectType.ORACLE_SID.equals((Object)connectionParams.connectType)) {
            hostSeperator = "@";
        }
        String[] hostPort = connectionParams.getAddress().split(hostSeperator);
        String[] hostPortArray = hostPort[hostPort.length - 1].split(",");
        oracleDatasourceParamDTO.setPort(Integer.parseInt(hostPortArray[0].split(":")[1]));
        oracleDatasourceParamDTO.setHost(hostPortArray[0].split(":")[0]);
        return oracleDatasourceParamDTO;
    }

    @Override
    public BaseConnectionParam createConnectionParams(BaseDataSourceParamDTO datasourceParam) {
        OracleDatasourceParamDTO oracleParam = (OracleDatasourceParamDTO)datasourceParam;
        String address = DbConnectType.ORACLE_SID.equals((Object)oracleParam.getConnectType()) ? String.format("%s%s:%s", "jdbc:oracle:thin:@", oracleParam.getHost(), oracleParam.getPort()) : String.format("%s%s:%s", "jdbc:oracle:thin:@//", oracleParam.getHost(), oracleParam.getPort());
        String jdbcUrl = address + "/" + oracleParam.getDatabase();
        OracleConnectionParam oracleConnectionParam = new OracleConnectionParam();
        oracleConnectionParam.setUser(oracleParam.getUserName());
        oracleConnectionParam.setPassword(PasswordUtils.encodePassword(oracleParam.getPassword()));
        oracleConnectionParam.setAddress(address);
        oracleConnectionParam.setJdbcUrl(jdbcUrl);
        oracleConnectionParam.setDatabase(oracleParam.getDatabase());
        oracleConnectionParam.setConnectType(oracleParam.getConnectType());
        oracleConnectionParam.setOther(this.transformOther(oracleParam.getOther()));
        return oracleConnectionParam;
    }

    @Override
    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, OracleConnectionParam.class);
    }

    @Override
    public String getDatasourceDriver() {
        return "oracle.jdbc.driver.OracleDriver";
    }

    @Override
    public String getJdbcUrl(ConnectionParam connectionParam) {
        OracleConnectionParam oracleConnectionParam = (OracleConnectionParam)connectionParam;
        if (StringUtils.isNotEmpty((CharSequence)oracleConnectionParam.getOther())) {
            return String.format("%s?%s", oracleConnectionParam.getJdbcUrl(), oracleConnectionParam.getOther());
        }
        return oracleConnectionParam.getJdbcUrl();
    }

    @Override
    public Connection getConnection(ConnectionParam connectionParam) throws ClassNotFoundException, SQLException {
        OracleConnectionParam oracleConnectionParam = (OracleConnectionParam)connectionParam;
        Class.forName(this.getDatasourceDriver());
        return DriverManager.getConnection(this.getJdbcUrl(connectionParam), oracleConnectionParam.getUser(), PasswordUtils.decodePassword(oracleConnectionParam.getPassword()));
    }

    @Override
    public DbType getDbType() {
        return DbType.ORACLE;
    }

    private String transformOther(Map<String, String> otherMap) {
        if (MapUtils.isEmpty(otherMap)) {
            return null;
        }
        ArrayList list = new ArrayList();
        otherMap.forEach((key, value) -> list.add(String.format("%s=%s", key, value)));
        return String.join((CharSequence)"&", list);
    }

    private Map<String, String> parseOther(String other) {
        String[] configs;
        if (StringUtils.isEmpty((CharSequence)other)) {
            return null;
        }
        LinkedHashMap<String, String> otherMap = new LinkedHashMap<String, String>();
        for (String config : configs = other.split("&")) {
            otherMap.put(config.split("=")[0], config.split("=")[1]);
        }
        return otherMap;
    }
}

