/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api;

import java.util.StringJoiner;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.dolphinscheduler.spi.task.AbstractTask;
import org.apache.dolphinscheduler.spi.task.request.TaskRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public abstract class AbstractTaskExecutor
extends AbstractTask {
    public static final Marker FINALIZE_SESSION_MARKER = MarkerFactory.getMarker((String)"FINALIZE_SESSION");
    protected Logger logger;

    protected AbstractTaskExecutor(TaskRequest taskRequest) {
        super(taskRequest);
        this.logger = LoggerFactory.getLogger((String)taskRequest.getTaskLogName());
    }

    public void logHandle(LinkedBlockingQueue<String> logs) {
        if (logs.contains(FINALIZE_SESSION_MARKER.toString())) {
            this.logger.info(FINALIZE_SESSION_MARKER, FINALIZE_SESSION_MARKER.toString());
        } else {
            StringJoiner joiner = new StringJoiner("\n\t");
            while (!logs.isEmpty()) {
                joiner.add(logs.poll());
            }
            this.logger.info(" -> {}", (Object)joiner);
        }
    }
}

