/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api;

import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.ExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskAlertInfo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;

public abstract class AbstractTask {
    protected String varPool;
    TaskExecutionContext taskRequest;
    protected int processId;
    protected String resultString;
    protected String appIds;
    protected volatile boolean cancel = false;
    protected volatile int exitStatusCode = -1;
    protected boolean needAlert = false;
    protected TaskAlertInfo taskAlertInfo;

    protected AbstractTask(TaskExecutionContext taskExecutionContext) {
        this.taskRequest = taskExecutionContext;
    }

    public void init() {
    }

    public String getPreScript() {
        return null;
    }

    public abstract void handle() throws Exception;

    public void cancelApplication(boolean status) throws Exception {
        this.cancel = status;
    }

    public void setVarPool(String varPool) {
        this.varPool = varPool;
    }

    public String getVarPool() {
        return this.varPool;
    }

    public int getExitStatusCode() {
        return this.exitStatusCode;
    }

    public void setExitStatusCode(int exitStatusCode) {
        this.exitStatusCode = exitStatusCode;
    }

    public String getAppIds() {
        return this.appIds;
    }

    public void setAppIds(String appIds) {
        this.appIds = appIds;
    }

    public int getProcessId() {
        return this.processId;
    }

    public void setProcessId(int processId) {
        this.processId = processId;
    }

    public String getResultString() {
        return this.resultString;
    }

    public void setResultString(String resultString) {
        this.resultString = resultString;
    }

    public boolean getNeedAlert() {
        return this.needAlert;
    }

    public void setNeedAlert(boolean needAlert) {
        this.needAlert = needAlert;
    }

    public TaskAlertInfo getTaskAlertInfo() {
        return this.taskAlertInfo;
    }

    public void setTaskAlertInfo(TaskAlertInfo taskAlertInfo) {
        this.taskAlertInfo = taskAlertInfo;
    }

    public abstract AbstractParameters getParameters();

    public ExecutionStatus getExitStatus() {
        ExecutionStatus status;
        switch (this.getExitStatusCode()) {
            case 0: {
                status = ExecutionStatus.SUCCESS;
                break;
            }
            case 137: {
                status = ExecutionStatus.KILL;
                break;
            }
            default: {
                status = ExecutionStatus.FAILURE;
            }
        }
        return status;
    }
}

