/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api;

import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.dolphinscheduler.plugin.task.api.AbstractTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public abstract class AbstractTaskExecutor
extends AbstractTask {
    public static final Marker FINALIZE_SESSION_MARKER = MarkerFactory.getMarker((String)"FINALIZE_SESSION");
    protected final Logger logger = LoggerFactory.getLogger((String)String.format("TaskLogLogger-%s", this.getClass()));
    public String rgex = "['\"]*\\$\\{(.*?)\\}['\"]*";

    protected AbstractTaskExecutor(TaskExecutionContext taskRequest) {
        super(taskRequest);
    }

    public void logHandle(LinkedBlockingQueue<String> logs) {
        if (logs.contains(FINALIZE_SESSION_MARKER.toString())) {
            this.logger.info(FINALIZE_SESSION_MARKER, FINALIZE_SESSION_MARKER.toString());
        } else {
            StringJoiner joiner = new StringJoiner("\n\t");
            while (!logs.isEmpty()) {
                joiner.add(logs.poll());
            }
            this.logger.info(" -> {}", (Object)joiner);
        }
    }

    public void setSqlParamsMap(String content, String rgex, Map<Integer, Property> sqlParamsMap, Map<String, Property> paramsPropsMap, int taskInstanceId) {
        Pattern pattern = Pattern.compile(rgex);
        Matcher m = pattern.matcher(content);
        int index = 1;
        while (m.find()) {
            String paramName = m.group(1);
            Property prop = paramsPropsMap.get(paramName);
            if (prop == null) {
                this.logger.error("setSqlParamsMap: No Property with paramName: {} is found in paramsPropsMap of task instance with id: {}. So couldn't put Property in sqlParamsMap.", (Object)paramName, (Object)taskInstanceId);
                continue;
            }
            sqlParamsMap.put(index, prop);
            ++index;
            this.logger.info("setSqlParamsMap: Property with paramName: {} put in sqlParamsMap of content {} successfully.", (Object)paramName, (Object)content);
        }
    }
}

