/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.parser;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.DataType;
import org.apache.dolphinscheduler.plugin.task.api.enums.Direct;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parser.BusinessTimeUtils;
import org.apache.dolphinscheduler.plugin.task.api.parser.ParameterUtils;
import org.apache.dolphinscheduler.spi.enums.CommandType;
import org.apache.dolphinscheduler.spi.utils.StringUtils;

public class ParamUtils {
    public static Map<String, Property> convert(TaskExecutionContext taskExecutionContext, AbstractParameters parameters) {
        Preconditions.checkNotNull((Object)taskExecutionContext);
        Preconditions.checkNotNull((Object)parameters);
        Map<String, Property> globalParams = ParamUtils.getUserDefParamsMap(taskExecutionContext.getDefinedParams());
        Map<String, String> globalParamsMap = taskExecutionContext.getDefinedParams();
        CommandType commandType = CommandType.of((Integer)taskExecutionContext.getCmdTypeIfComplement());
        Date scheduleTime = taskExecutionContext.getScheduleTime();
        Map<String, Property> localParams = parameters.getInputLocalParametersMap();
        Map<String, Property> varParams = parameters.getVarPoolMap();
        if (globalParams.size() == 0 && localParams.size() == 0 && varParams.size() == 0) {
            return null;
        }
        Map<String, String> params = BusinessTimeUtils.getBusinessTime(commandType, scheduleTime);
        if (globalParamsMap != null) {
            params.putAll(globalParamsMap);
        }
        if (StringUtils.isNotBlank((CharSequence)taskExecutionContext.getExecutePath())) {
            params.put("system.task.execute.path", taskExecutionContext.getExecutePath());
        }
        params.put("system.task.instance.id", Integer.toString(taskExecutionContext.getTaskInstanceId()));
        if (varParams.size() != 0) {
            globalParams.putAll(varParams);
        }
        if (localParams.size() != 0) {
            globalParams.putAll(localParams);
        }
        for (Map.Entry<String, Property> en : globalParams.entrySet()) {
            Property property = en.getValue();
            if (!StringUtils.isNotEmpty((CharSequence)property.getValue()) || !property.getValue().startsWith("$")) continue;
            String val = property.getValue();
            val = ParameterUtils.convertParameterPlaceholders(val, params);
            property.setValue(val);
        }
        return globalParams;
    }

    public static Map<String, String> convert(Map<String, Property> paramsMap) {
        if (paramsMap == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, Property> en : paramsMap.entrySet()) {
            map.put(en.getKey(), en.getValue().getValue());
        }
        return map;
    }

    public static Map<String, Property> getUserDefParamsMap(Map<String, String> definedParams) {
        HashMap<String, Property> userDefParamsMaps = new HashMap<String, Property>();
        if (definedParams != null) {
            for (Map.Entry<String, String> en : definedParams.entrySet()) {
                Property property = new Property(en.getKey(), Direct.IN, DataType.VARCHAR, en.getValue());
                userDefParamsMaps.put(property.getProp(), property);
            }
        }
        return userDefParamsMaps;
    }
}

