/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.utils;

import org.apache.dolphinscheduler.plugin.task.api.model.JdbcInfo;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.apache.dolphinscheduler.spi.utils.StringUtils;

public class JdbcUrlParser {
    private JdbcUrlParser() {
        throw new IllegalStateException("Utility class");
    }

    public static DbType getDbType(String datasourceType) {
        switch (datasourceType.toUpperCase()) {
            case "MYSQL": {
                return DbType.MYSQL;
            }
            case "POSTGRESQL": {
                return DbType.POSTGRESQL;
            }
        }
        return null;
    }

    public static JdbcInfo getJdbcInfo(String jdbcUrl) {
        String tempUri;
        int pos1;
        JdbcInfo jdbcInfo = new JdbcInfo();
        if (jdbcUrl == null || !jdbcUrl.startsWith("jdbc:") || (pos1 = jdbcUrl.indexOf(":", 5)) == -1) {
            return null;
        }
        String driverName = jdbcUrl.substring(5, pos1);
        String params = "";
        String host = "";
        String database = "";
        String port = "";
        int pos2 = jdbcUrl.indexOf(";", pos1);
        if (pos2 == -1 && (pos2 = jdbcUrl.indexOf("?", pos1)) == -1) {
            tempUri = jdbcUrl.substring(pos1 + 1);
        } else {
            tempUri = jdbcUrl.substring(pos1 + 1, pos2);
            params = jdbcUrl.substring(pos2 + 1);
        }
        if (tempUri.startsWith("//")) {
            int pos = tempUri.indexOf("/", 2);
            if (pos != -1) {
                host = tempUri.substring(2, pos);
                database = tempUri.substring(pos + 1);
                pos = host.indexOf(":");
                if (pos != -1) {
                    port = host.substring(pos + 1);
                    host = host.substring(0, pos);
                }
            }
        } else {
            database = tempUri;
        }
        if (StringUtils.isEmpty((CharSequence)database)) {
            return null;
        }
        if (database.contains("?")) {
            database = database.substring(0, database.indexOf("?"));
        }
        if (database.contains(";")) {
            database = database.substring(0, database.indexOf(";"));
        }
        jdbcInfo.setDriverName(driverName);
        jdbcInfo.setHost(host);
        jdbcInfo.setPort(port);
        jdbcInfo.setDatabase(database);
        jdbcInfo.setParams(params);
        jdbcInfo.setAddress("jdbc:" + driverName + "://" + host + ":" + port);
        return jdbcInfo;
    }
}

