/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.enums.dp;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum DqTaskState {
    DEFAULT(0, "default"),
    SUCCESS(1, "success"),
    FAILURE(2, "failure");

    private final int code;
    private final String description;
    private static final Map<Integer, DqTaskState> VALUES_MAP;

    private DqTaskState(int code, String description) {
        this.code = code;
        this.description = description;
    }

    @JsonValue
    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static DqTaskState of(Integer status) {
        if (VALUES_MAP.containsKey(status)) {
            return VALUES_MAP.get(status);
        }
        throw new IllegalArgumentException("invalid code : " + status);
    }

    static {
        VALUES_MAP = new HashMap<Integer, DqTaskState>();
        for (DqTaskState type : DqTaskState.values()) {
            VALUES_MAP.put(type.code, type);
        }
    }
}

