/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractCommandExecutor;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.utils.OSUtils;
import org.slf4j.Logger;

public class ShellCommandExecutor
extends AbstractCommandExecutor {
    private static final String SH = "sh";
    private static final String CMD = "cmd.exe";

    public ShellCommandExecutor(Consumer<LinkedBlockingQueue<String>> logHandler, TaskExecutionContext taskRequest, Logger logger) {
        super(logHandler, taskRequest, logger);
    }

    public ShellCommandExecutor(LinkedBlockingQueue<String> logBuffer) {
        super(logBuffer);
    }

    @Override
    protected String buildCommandFilePath() {
        return String.format("%s/%s.%s", this.taskRequest.getExecutePath(), this.taskRequest.getTaskAppId(), OSUtils.isWindows() ? "bat" : "command");
    }

    @Override
    protected void createCommandFileIfNotExists(String execCommand, String commandFile) throws IOException {
        this.logger.info("tenantCode user:{}, task dir:{}", (Object)this.taskRequest.getTenantCode(), (Object)this.taskRequest.getTaskAppId());
        if (!Files.exists(Paths.get(commandFile, new String[0]), new LinkOption[0])) {
            this.logger.info("create command file:{}", (Object)commandFile);
            StringBuilder sb = new StringBuilder();
            if (OSUtils.isWindows()) {
                sb.append("@echo off\n");
                sb.append("cd /d %~dp0\n");
                if (StringUtils.isNotBlank((String)this.taskRequest.getEnvironmentConfig())) {
                    sb.append(this.taskRequest.getEnvironmentConfig()).append("\n");
                } else if (this.taskRequest.getEnvFile() != null) {
                    sb.append("call ").append(this.taskRequest.getEnvFile()).append("\n");
                }
            } else {
                sb.append("#!/bin/sh\n");
                sb.append("BASEDIR=$(cd `dirname $0`; pwd)\n");
                sb.append("cd $BASEDIR\n");
                if (StringUtils.isNotBlank((String)this.taskRequest.getEnvironmentConfig())) {
                    sb.append(this.taskRequest.getEnvironmentConfig()).append("\n");
                } else if (this.taskRequest.getEnvFile() != null) {
                    sb.append("source ").append(this.taskRequest.getEnvFile()).append("\n");
                }
            }
            sb.append(execCommand);
            this.logger.info("command : {}", (Object)sb);
            FileUtils.writeStringToFile((File)new File(commandFile), (String)sb.toString(), (Charset)StandardCharsets.UTF_8);
        }
    }

    @Override
    protected String commandInterpreter() {
        return OSUtils.isWindows() ? CMD : SH;
    }
}

