/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskAlertInfo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.spi.utils.StringUtils;

public abstract class AbstractTask {
    protected static final Pattern YARN_APPLICATION_REGEX = Pattern.compile("application_\\d+_\\d+");
    protected String varPool;
    protected TaskExecutionContext taskRequest;
    protected int processId;
    protected String resultString;
    protected String appIds;
    protected volatile boolean cancel = false;
    protected volatile int exitStatusCode = -1;
    protected boolean needAlert = false;
    protected TaskAlertInfo taskAlertInfo;

    protected AbstractTask(TaskExecutionContext taskExecutionContext) {
        this.taskRequest = taskExecutionContext;
    }

    public void init() {
    }

    public String getPreScript() {
        return null;
    }

    public abstract void handle() throws TaskException;

    public void cancelApplication(boolean status) throws Exception {
        this.cancel = status;
    }

    public Set<String> getApplicationIds() throws IOException {
        HashSet<String> appIds = new HashSet<String>();
        File file = new File(this.taskRequest.getLogPath());
        if (!file.exists()) {
            return appIds;
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.taskRequest.getLogPath()), StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                String appId = this.findAppId(line);
                if (!StringUtils.isNotEmpty((CharSequence)appId)) continue;
                appIds.add(appId);
            }
        }
        return appIds;
    }

    protected String findAppId(String line) {
        Matcher matcher = YARN_APPLICATION_REGEX.matcher(line);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    public void setVarPool(String varPool) {
        this.varPool = varPool;
    }

    public String getVarPool() {
        return this.varPool;
    }

    public int getExitStatusCode() {
        return this.exitStatusCode;
    }

    public void setExitStatusCode(int exitStatusCode) {
        this.exitStatusCode = exitStatusCode;
    }

    public String getAppIds() {
        return this.appIds;
    }

    public void setAppIds(String appIds) {
        this.appIds = appIds;
    }

    public int getProcessId() {
        return this.processId;
    }

    public void setProcessId(int processId) {
        this.processId = processId;
    }

    public String getResultString() {
        return this.resultString;
    }

    public void setResultString(String resultString) {
        this.resultString = resultString;
    }

    public boolean getNeedAlert() {
        return this.needAlert;
    }

    public void setNeedAlert(boolean needAlert) {
        this.needAlert = needAlert;
    }

    public TaskAlertInfo getTaskAlertInfo() {
        return this.taskAlertInfo;
    }

    public void setTaskAlertInfo(TaskAlertInfo taskAlertInfo) {
        this.taskAlertInfo = taskAlertInfo;
    }

    public abstract AbstractParameters getParameters();

    public TaskExecutionStatus getExitStatus() {
        TaskExecutionStatus status;
        switch (this.getExitStatusCode()) {
            case 0: {
                status = TaskExecutionStatus.SUCCESS;
                break;
            }
            case 137: {
                status = TaskExecutionStatus.KILL;
                break;
            }
            default: {
                status = TaskExecutionStatus.FAILURE;
            }
        }
        return status;
    }
}

