/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api;

import java.util.regex.Pattern;
import org.apache.dolphinscheduler.plugin.task.api.AbstractTaskExecutor;
import org.apache.dolphinscheduler.plugin.task.api.ShellCommandExecutor;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.ResourceInfo;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskResponse;

public abstract class AbstractYarnTask
extends AbstractTaskExecutor {
    private ShellCommandExecutor shellCommandExecutor;
    protected static final Pattern YARN_APPLICATION_REGEX = Pattern.compile("application_\\d+_\\d+");

    public AbstractYarnTask(TaskExecutionContext taskRequest) {
        super(taskRequest);
        this.shellCommandExecutor = new ShellCommandExecutor(this::logHandle, taskRequest, this.logger);
    }

    @Override
    public void handle() throws TaskException {
        try {
            TaskResponse response = this.shellCommandExecutor.run(this.buildCommand());
            this.setExitStatusCode(response.getExitStatusCode());
            this.setAppIds(String.join((CharSequence)",", this.getApplicationIds()));
            this.setProcessId(response.getProcessId());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            this.logger.info("The current yarn task has been interrupted", (Throwable)ex);
            this.setExitStatusCode(-1);
            throw new TaskException("The current yarn task has been interrupted", ex);
        }
        catch (Exception e) {
            this.logger.error("yarn process failure", (Throwable)e);
            this.exitStatusCode = -1;
            throw new TaskException("Execute task failed", e);
        }
    }

    @Override
    public void cancelApplication(boolean status) throws Exception {
        this.cancel = true;
        this.shellCommandExecutor.cancelApplication();
    }

    protected abstract String buildCommand();

    protected abstract void setMainJarName();

    protected String getResourceNameOfMainJar(ResourceInfo mainJar) {
        if (null == mainJar) {
            throw new RuntimeException("The jar for the task is required.");
        }
        return mainJar.getId() == null ? mainJar.getRes() : mainJar.getResourceName().replaceFirst("/", "");
    }
}

