/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractCommandExecutor;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.utils.FileUtils;
import org.slf4j.Logger;

public class ShellCommandExecutor
extends AbstractCommandExecutor {
    private static final String SH = "bash";
    private static final String CMD = "cmd.exe";

    public ShellCommandExecutor(Consumer<LinkedBlockingQueue<String>> logHandler, TaskExecutionContext taskRequest, Logger logger) {
        super(logHandler, taskRequest, logger);
    }

    public ShellCommandExecutor(LinkedBlockingQueue<String> logBuffer) {
        super(logBuffer);
    }

    @Override
    protected String buildCommandFilePath() {
        return String.format("%s/%s.%s", this.taskRequest.getExecutePath(), this.taskRequest.getTaskAppId(), SystemUtils.IS_OS_WINDOWS ? "bat" : "command");
    }

    @Override
    protected void createCommandFileIfNotExists(String execCommand, String commandFile) throws IOException {
        this.logger.info("Begin to create command file:{}", (Object)commandFile);
        Path commandFilePath = Paths.get(commandFile, new String[0]);
        if (Files.exists(commandFilePath, new LinkOption[0])) {
            this.logger.warn("The command file: {} is already exist, will not create a again", (Object)commandFile);
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (SystemUtils.IS_OS_WINDOWS) {
            sb.append("@echo off\n");
            sb.append("cd /d %~dp0\n");
            if (StringUtils.isNotBlank((CharSequence)this.taskRequest.getEnvironmentConfig())) {
                sb.append(this.taskRequest.getEnvironmentConfig()).append("\n");
            } else if (this.taskRequest.getEnvFile() != null) {
                sb.append("call ").append(this.taskRequest.getEnvFile()).append("\n");
            }
        } else {
            sb.append("#!/bin/bash\n");
            sb.append("BASEDIR=$(cd `dirname $0`; pwd)\n");
            sb.append("cd $BASEDIR\n");
            if (StringUtils.isNotBlank((CharSequence)this.taskRequest.getEnvironmentConfig())) {
                sb.append(this.taskRequest.getEnvironmentConfig()).append("\n");
            } else if (this.taskRequest.getEnvFile() != null) {
                sb.append("source ").append(this.taskRequest.getEnvFile()).append("\n");
            }
        }
        sb.append(execCommand);
        String commandContent = sb.toString();
        FileUtils.createFileWith755(commandFilePath);
        Files.write(commandFilePath, commandContent.getBytes(), StandardOpenOption.APPEND);
        this.logger.info("Success create command file, command: {}", (Object)commandContent);
    }

    @Override
    protected String commandInterpreter() {
        return SystemUtils.IS_OS_WINDOWS ? CMD : SH;
    }
}

