/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogUtils.class);
    private static final Pattern APPLICATION_REGEX = Pattern.compile("application_\\d+_\\d+");

    public static List<String> getAppIdsFromLogFile(@NonNull String logPath) {
        if (logPath == null) {
            throw new NullPointerException("logPath is marked non-null but is null");
        }
        return LogUtils.getAppIdsFromLogFile(logPath, log);
    }

    public static List<String> getAppIdsFromLogFile(@NonNull String logPath, Logger logger) {
        ArrayList<String> arrayList;
        block10: {
            if (logPath == null) {
                throw new NullPointerException("logPath is marked non-null but is null");
            }
            File logFile = new File(logPath);
            if (!logFile.exists() || !logFile.isFile()) {
                return Collections.emptyList();
            }
            HashSet appIds = new HashSet();
            Stream<String> stream = Files.lines(Paths.get(logPath, new String[0]));
            try {
                stream.filter(line -> {
                    Matcher matcher = APPLICATION_REGEX.matcher((CharSequence)line);
                    return matcher.find();
                }).forEach(line -> {
                    String appId;
                    Matcher matcher = APPLICATION_REGEX.matcher((CharSequence)line);
                    if (matcher.find() && appIds.add(appId = matcher.group())) {
                        logger.info("Find appId: {} from {}", (Object)appId, (Object)logPath);
                    }
                });
                arrayList = new ArrayList<String>(appIds);
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error("Get appId from log file erro, logPath: {}", (Object)logPath, (Object)e);
                    return Collections.emptyList();
                }
            }
            stream.close();
        }
        return arrayList;
    }

    @Generated
    private LogUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

