/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.loop.template.http.method;

import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.plugin.task.api.loop.LoopTaskInstanceInfo;
import org.apache.dolphinscheduler.plugin.task.api.loop.LoopTaskInstanceStatus;
import org.apache.dolphinscheduler.plugin.task.api.loop.LoopTaskQueryStatusMethodDefinition;
import org.apache.dolphinscheduler.plugin.task.api.loop.template.http.HttpLoopTaskInstanceStatus;
import org.apache.dolphinscheduler.plugin.task.api.loop.template.http.HttpLoopTaskMethodDefinition;
import org.apache.dolphinscheduler.plugin.task.api.utils.JsonPathUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.OkHttpUtils;

public class HttpLoopTaskQueryStatusMethodDefinition
extends HttpLoopTaskMethodDefinition
implements LoopTaskQueryStatusMethodDefinition {
    private final String taskInstanceFinishedJPath;
    private final String taskInstanceIdHolder = "${taskInstanceId}";

    public HttpLoopTaskQueryStatusMethodDefinition(String url, String httpMethodType, String dataType, Map<String, String> httpHeaders, Map<String, Object> requestParams, Map<String, Object> requestBody, String taskInstanceFinishedJPath) {
        super(url, httpMethodType, dataType, httpHeaders, requestParams, requestBody);
        this.taskInstanceFinishedJPath = taskInstanceFinishedJPath;
    }

    @Override
    @NonNull
    public LoopTaskInstanceStatus queryTaskInstanceStatus(@NonNull LoopTaskInstanceInfo loopTaskInstanceInfo) {
        String responseBody;
        block10: {
            if (loopTaskInstanceInfo == null) {
                throw new NullPointerException("loopTaskInstanceInfo is marked non-null but is null");
            }
            if (this.requestParams != null) {
                for (Map.Entry entry : this.requestParams.entrySet()) {
                    if (!StringUtils.equals((CharSequence)entry.getValue().toString(), (CharSequence)"${taskInstanceId}")) continue;
                    entry.setValue(loopTaskInstanceInfo.getTaskInstanceId());
                }
            }
            if (this.requestBody != null) {
                for (Map.Entry entry : this.requestBody.entrySet()) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)entry.getValue().toString(), (CharSequence)"${taskInstanceId}")) continue;
                    entry.setValue(loopTaskInstanceInfo.getTaskInstanceId());
                }
            }
            try {
                if (StringUtils.equalsIgnoreCase((CharSequence)"get", (CharSequence)this.httpMethodType)) {
                    responseBody = OkHttpUtils.get(this.url, this.httpHeaders, this.requestParams);
                    break block10;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)"post", (CharSequence)this.httpMethodType)) {
                    responseBody = OkHttpUtils.post(this.url, this.httpHeaders, this.requestParams, this.requestBody);
                    break block10;
                }
                throw new IllegalArgumentException(String.format("http method type: %s is not supported", this.httpMethodType));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                throw new RuntimeException("Query loop task instance status failed", exception);
            }
        }
        return new HttpLoopTaskInstanceStatus(JsonPathUtils.exist(responseBody, this.taskInstanceFinishedJPath));
    }
}

