/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.loop.template.http.parser;

import com.google.common.base.Preconditions;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.plugin.task.api.loop.template.LoopTaskYamlDefinition;
import org.apache.dolphinscheduler.plugin.task.api.loop.template.TaskDefinitionParser;
import org.apache.dolphinscheduler.plugin.task.api.loop.template.http.HttpLoopTaskDefinition;
import org.apache.dolphinscheduler.plugin.task.api.loop.template.http.method.HttpLoopTaskCancelTaskMethodDefinition;
import org.apache.dolphinscheduler.plugin.task.api.loop.template.http.method.HttpLoopTaskQueryStatusMethodDefinition;
import org.apache.dolphinscheduler.plugin.task.api.loop.template.http.method.HttpLoopTaskSubmitTaskMethodDefinition;
import org.apache.dolphinscheduler.plugin.task.api.loop.template.http.parser.CancelTemplateMethodTransformer;
import org.apache.dolphinscheduler.plugin.task.api.loop.template.http.parser.QueryStateTemplateMethodTransformer;
import org.apache.dolphinscheduler.plugin.task.api.loop.template.http.parser.SubmitTemplateMethodTransformer;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class HttpTaskDefinitionParser
implements TaskDefinitionParser<HttpLoopTaskDefinition> {
    @Override
    @NonNull
    public HttpLoopTaskDefinition parse(@NonNull String yamlConfigFile) {
        LoopTaskYamlDefinition loopTaskYamlDefinition;
        if (yamlConfigFile == null) {
            throw new NullPointerException("yamlConfigFile is marked non-null but is null");
        }
        try {
            loopTaskYamlDefinition = this.parseYamlConfigFile(yamlConfigFile);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(String.format("Parse yaml file: %s error", yamlConfigFile), ex);
        }
        this.validateYamlDefinition(loopTaskYamlDefinition);
        LoopTaskYamlDefinition.LoopTaskServiceYamlDefinition service = loopTaskYamlDefinition.getService();
        LoopTaskYamlDefinition.LoopTaskAPIYamlDefinition api = service.getApi();
        HttpLoopTaskSubmitTaskMethodDefinition submitTaskMethod = new SubmitTemplateMethodTransformer().transform(api.getSubmit());
        HttpLoopTaskQueryStatusMethodDefinition queryTaskStateMethod = new QueryStateTemplateMethodTransformer().transform(api.getQueryState());
        HttpLoopTaskCancelTaskMethodDefinition cancelTaskMethod = new CancelTemplateMethodTransformer().transform(api.getCancel());
        return new HttpLoopTaskDefinition(service.getName(), submitTaskMethod, queryTaskStateMethod, cancelTaskMethod);
    }

    @NonNull
    protected LoopTaskYamlDefinition parseYamlConfigFile(@NonNull String yamlConfigFile) throws IOException {
        if (yamlConfigFile == null) {
            throw new NullPointerException("yamlConfigFile is marked non-null but is null");
        }
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(LoopTaskYamlDefinition.class));
        try (FileReader fileReader = new FileReader(yamlConfigFile);){
            LoopTaskYamlDefinition loopTaskYamlDefinition = (LoopTaskYamlDefinition)yaml.load((Reader)fileReader);
            return loopTaskYamlDefinition;
        }
    }

    protected void validateYamlDefinition(@NonNull LoopTaskYamlDefinition loopTaskYamlDefinition) {
        if (loopTaskYamlDefinition == null) {
            throw new NullPointerException("loopTaskYamlDefinition is marked non-null but is null");
        }
        LoopTaskYamlDefinition.LoopTaskServiceYamlDefinition service = loopTaskYamlDefinition.getService();
        Preconditions.checkNotNull((Object)service, (Object)"service is null");
        Preconditions.checkNotNull((Object)service.getName(), (Object)"service name is null");
        if (!StringUtils.equalsIgnoreCase((CharSequence)service.getType(), (CharSequence)"http")) {
            throw new IllegalArgumentException(String.format("service type: %s is invalidated", service.getType()));
        }
    }
}

