/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.lang3.SystemUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.utils.OSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProcessUtils.class);
    private static final Pattern MACPATTERN = Pattern.compile("-[+|-]-\\s(\\d+)");
    private static final Pattern WINDOWSATTERN = Pattern.compile("(\\d+)");

    private ProcessUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean kill(@NonNull TaskExecutionContext request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        try {
            logger.info("Begin kill task instance, processId: {}", (Object)request.getProcessId());
            int processId = request.getProcessId();
            if (processId == 0) {
                logger.error("Task instance kill failed, processId is not exist");
                return false;
            }
            String cmd = String.format("kill -9 %s", ProcessUtils.getPidsStr(processId));
            cmd = OSUtils.getSudoCmd(request.getTenantCode(), cmd);
            logger.info("process id:{}, cmd:{}", (Object)processId, (Object)cmd);
            OSUtils.exeCmd(cmd);
            logger.info("Success kill task instance, processId: {}", (Object)request.getProcessId());
            return true;
        }
        catch (Exception e) {
            logger.error("Kill task instance error, processId: {}", (Object)request.getProcessId(), (Object)e);
            return false;
        }
    }

    public static String getPidsStr(int processId) throws Exception {
        String pids;
        StringBuilder sb = new StringBuilder();
        Matcher mat = null;
        if (SystemUtils.IS_OS_MAC) {
            pids = OSUtils.exeCmd(String.format("%s -sp %d", "pstree", processId));
            if (null != pids) {
                mat = MACPATTERN.matcher(pids);
            }
        } else {
            pids = OSUtils.exeCmd(String.format("%s -p %d", "pstree", processId));
            mat = WINDOWSATTERN.matcher(pids);
        }
        if (null != mat) {
            while (mat.find()) {
                sb.append(mat.group(1)).append(" ");
            }
        }
        return sb.toString().trim();
    }
}

