/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api;

import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskAlertInfo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTask {
    protected final Logger log = LoggerFactory.getLogger(AbstractTask.class);
    private static String groupName1 = "paramName1";
    private static String groupName2 = "paramName2";
    public String rgex = String.format("['\"]\\$\\{(?<%s>.*?)}['\"]|\\$\\{(?<%s>.*?)}", groupName1, groupName2);
    protected String varPool;
    protected TaskExecutionContext taskRequest;
    protected int processId;
    protected String appIds;
    protected volatile int exitStatusCode = -1;
    protected boolean needAlert = false;
    protected TaskAlertInfo taskAlertInfo;

    protected AbstractTask(TaskExecutionContext taskExecutionContext) {
        this.taskRequest = taskExecutionContext;
    }

    public void init() {
    }

    public abstract void handle(TaskCallBack var1) throws TaskException;

    public abstract void cancel() throws TaskException;

    public void setVarPool(String varPool) {
        this.varPool = varPool;
    }

    public String getVarPool() {
        return this.varPool;
    }

    public int getExitStatusCode() {
        return this.exitStatusCode;
    }

    public void setExitStatusCode(int exitStatusCode) {
        this.exitStatusCode = exitStatusCode;
    }

    public int getProcessId() {
        return this.processId;
    }

    public void setProcessId(int processId) {
        this.processId = processId;
    }

    public String getAppIds() {
        return this.appIds;
    }

    public void setAppIds(String appIds) {
        this.appIds = appIds;
    }

    public boolean getNeedAlert() {
        return this.needAlert;
    }

    public void setNeedAlert(boolean needAlert) {
        this.needAlert = needAlert;
    }

    public TaskAlertInfo getTaskAlertInfo() {
        return this.taskAlertInfo;
    }

    public void setTaskAlertInfo(TaskAlertInfo taskAlertInfo) {
        this.taskAlertInfo = taskAlertInfo;
    }

    public abstract AbstractParameters getParameters();

    public TaskExecutionStatus getExitStatus() {
        switch (this.getExitStatusCode()) {
            case 0: {
                return TaskExecutionStatus.SUCCESS;
            }
            case 137: {
                return TaskExecutionStatus.KILL;
            }
        }
        return TaskExecutionStatus.FAILURE;
    }

    public void logHandle(LinkedBlockingQueue<String> logs) {
        StringJoiner joiner = new StringJoiner("\n\t");
        while (!logs.isEmpty()) {
            joiner.add(logs.poll());
        }
        this.log.info(" -> {}", (Object)joiner);
    }

    public void setSqlParamsMap(String content, String rgex, Map<Integer, Property> sqlParamsMap, Map<String, Property> paramsPropsMap, int taskInstanceId) {
        if (paramsPropsMap == null) {
            return;
        }
        Pattern pattern = Pattern.compile(rgex);
        Matcher m = pattern.matcher(content);
        int index = 1;
        while (m.find()) {
            Property prop;
            String paramName = m.group(groupName1);
            if (paramName == null) {
                paramName = m.group(groupName2);
            }
            if ((prop = paramsPropsMap.get(paramName)) == null) {
                this.log.error("setSqlParamsMap: No Property with paramName: {} is found in paramsPropsMap of task instance with id: {}. So couldn't put Property in sqlParamsMap.", (Object)paramName, (Object)taskInstanceId);
                continue;
            }
            sqlParamsMap.put(index, prop);
            ++index;
            this.log.info("setSqlParamsMap: Property with paramName: {} put in sqlParamsMap of content {} successfully.", (Object)paramName, (Object)content);
        }
    }
}

