/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.k8s;

import org.apache.dolphinscheduler.plugin.task.api.AbstractRemoteTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.k8s.AbstractK8sTaskExecutor;
import org.apache.dolphinscheduler.plugin.task.api.k8s.impl.K8sTaskExecutor;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskResponse;

public abstract class AbstractK8sTask
extends AbstractRemoteTask {
    private AbstractK8sTaskExecutor abstractK8sTaskExecutor;

    protected AbstractK8sTask(TaskExecutionContext taskRequest) {
        super(taskRequest);
        this.abstractK8sTaskExecutor = new K8sTaskExecutor(this.log, taskRequest);
    }

    @Override
    public void handle(TaskCallBack taskCallBack) throws TaskException {
        try {
            TaskResponse response = this.abstractK8sTaskExecutor.run(this.buildCommand());
            this.setExitStatusCode(response.getExitStatusCode());
            this.setAppIds(response.getAppIds());
            this.dealOutParam(this.abstractK8sTaskExecutor.getVarPool());
        }
        catch (Exception e) {
            this.log.error("k8s task submit failed with error");
            this.exitStatusCode = -1;
            throw new TaskException("Execute k8s task error", e);
        }
    }

    @Override
    public void submitApplication() throws TaskException {
    }

    @Override
    public void trackApplicationStatus() throws TaskException {
    }

    @Override
    public void cancelApplication() throws TaskException {
        this.abstractK8sTaskExecutor.cancelApplication(this.buildCommand());
    }

    protected abstract String buildCommand();

    protected abstract void dealOutParam(String var1);
}

