/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.k8s;

import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskResponse;
import org.apache.dolphinscheduler.plugin.task.api.utils.K8sUtils;
import org.slf4j.Logger;
import org.yaml.snakeyaml.Yaml;

public abstract class AbstractK8sTaskExecutor {
    protected Logger log;
    protected TaskExecutionContext taskRequest;
    protected K8sUtils k8sUtils;
    protected Yaml yaml;
    protected StringBuilder varPool;

    protected AbstractK8sTaskExecutor(Logger log, TaskExecutionContext taskRequest) {
        this.log = log;
        this.taskRequest = taskRequest;
        this.k8sUtils = new K8sUtils();
        this.yaml = new Yaml();
        this.varPool = new StringBuilder();
    }

    public String getVarPool() {
        return this.varPool.toString();
    }

    public abstract TaskResponse run(String var1) throws Exception;

    public abstract void cancelApplication(String var1);

    public void waitTimeout(Boolean timeout) throws TaskException {
        if (Boolean.TRUE.equals(timeout)) {
            throw new TaskException("K8sTask is timeout");
        }
    }

    public abstract void submitJob2k8s(String var1);

    public abstract void stopJobOnK8s(String var1);
}

