/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.loop.template.http.method;

import java.util.Map;
import java.util.Optional;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.OkHttpUtils;
import org.apache.dolphinscheduler.plugin.task.api.loop.LoopTaskInstanceInfo;
import org.apache.dolphinscheduler.plugin.task.api.loop.LoopTaskSubmitTaskMethodDefinition;
import org.apache.dolphinscheduler.plugin.task.api.loop.template.http.HttpLoopTaskInstanceInfo;
import org.apache.dolphinscheduler.plugin.task.api.loop.template.http.HttpLoopTaskMethodDefinition;
import org.apache.dolphinscheduler.plugin.task.api.utils.JsonPathUtils;

public class HttpLoopTaskSubmitTaskMethodDefinition
extends HttpLoopTaskMethodDefinition
implements LoopTaskSubmitTaskMethodDefinition {
    private final String taskInstanceIdJPath;

    public HttpLoopTaskSubmitTaskMethodDefinition(String url, String httpMethodType, String dataType, Map<String, String> httpHeaders, Map<String, Object> requestParams, Map<String, Object> requestBody, @NonNull String taskInstanceIdJPath) {
        super(url, httpMethodType, dataType, httpHeaders, requestParams, requestBody);
        if (taskInstanceIdJPath == null) {
            throw new NullPointerException("taskInstanceIdJPath is marked non-null but is null");
        }
        this.taskInstanceIdJPath = taskInstanceIdJPath;
    }

    @Override
    @NonNull
    public LoopTaskInstanceInfo submitLoopTask() {
        String responseBody;
        block5: {
            try {
                if (StringUtils.equalsIgnoreCase((CharSequence)this.httpMethodType, (CharSequence)"GET")) {
                    responseBody = OkHttpUtils.get((String)this.url, (Map)this.httpHeaders, (Map)this.requestParams);
                    break block5;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)this.httpMethodType, (CharSequence)"POST")) {
                    responseBody = OkHttpUtils.post((String)this.url, (Map)this.httpHeaders, (Map)this.requestParams, (Map)this.requestBody);
                    break block5;
                }
                throw new IllegalArgumentException(String.format("The request method type: %s is not supported.", this.httpMethodType));
            }
            catch (IllegalArgumentException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException("Submit loop task error", ex);
            }
        }
        Optional taskInstanceIdOptional = JsonPathUtils.read(responseBody, this.taskInstanceIdJPath);
        String taskInstanceId = (String)taskInstanceIdOptional.orElseThrow(() -> new RuntimeException(String.format("Resolve the taskInstanceId error, responseBody: %s, taskInstanceIdJPath: %s", responseBody, this.taskInstanceIdJPath)));
        return new HttpLoopTaskInstanceInfo(taskInstanceId);
    }
}

