/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.parameters;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.enums.Direct;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.model.ResourceInfo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.IParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.resource.ResourceParametersHelper;

public abstract class AbstractParameters
implements IParameters {
    public List<Property> localParams;
    public List<Property> varPool;

    @Override
    public abstract boolean checkParameters();

    @Override
    public List<ResourceInfo> getResourceFilesList() {
        return new ArrayList<ResourceInfo>();
    }

    public List<Property> getLocalParams() {
        return this.localParams;
    }

    public void setLocalParams(List<Property> localParams) {
        this.localParams = localParams;
    }

    public Map<String, Property> getLocalParametersMap() {
        LinkedHashMap<String, Property> localParametersMaps = new LinkedHashMap<String, Property>();
        if (this.localParams != null) {
            for (Property property : this.localParams) {
                localParametersMaps.put(property.getProp(), property);
            }
        }
        return localParametersMaps;
    }

    public Map<String, Property> getInputLocalParametersMap() {
        LinkedHashMap<String, Property> localParametersMaps = new LinkedHashMap<String, Property>();
        if (this.localParams != null) {
            for (Property property : this.localParams) {
                if (property.getDirect() != null && !Objects.equals((Object)Direct.IN, (Object)property.getDirect())) continue;
                localParametersMaps.put(property.getProp(), property);
            }
        }
        return localParametersMaps;
    }

    public Map<String, Property> getVarPoolMap() {
        LinkedHashMap<String, Property> varPoolMap = new LinkedHashMap<String, Property>();
        if (this.varPool != null) {
            for (Property property : this.varPool) {
                varPoolMap.put(property.getProp(), property);
            }
        }
        return varPoolMap;
    }

    public List<Property> getVarPool() {
        return this.varPool;
    }

    public void setVarPool(String varPool) {
        this.varPool = StringUtils.isEmpty((CharSequence)varPool) ? new ArrayList<Property>() : JSONUtils.toList((String)varPool, Property.class);
    }

    public void dealOutParam(String result) {
        if (CollectionUtils.isEmpty(this.localParams)) {
            return;
        }
        List<Property> outProperty = this.getOutProperty(this.localParams);
        if (CollectionUtils.isEmpty(outProperty)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)result)) {
            outProperty.forEach(this::addPropertyToValPool);
            return;
        }
        Map<String, String> taskResult = AbstractParameters.getMapByString(result);
        if (taskResult.size() == 0) {
            return;
        }
        for (Property info : outProperty) {
            String propValue = taskResult.get(info.getProp());
            if (!StringUtils.isNotEmpty((CharSequence)propValue)) continue;
            info.setValue(propValue);
            this.addPropertyToValPool(info);
        }
    }

    public List<Property> getOutProperty(List<Property> params) {
        if (CollectionUtils.isEmpty(params)) {
            return new ArrayList<Property>();
        }
        ArrayList<Property> result = new ArrayList<Property>();
        for (Property info : params) {
            if (info.getDirect() != Direct.OUT) continue;
            result.add(info);
        }
        return result;
    }

    public List<Map<String, String>> getListMapByString(String json) {
        ArrayList<Map<String, String>> allParams = new ArrayList<Map<String, String>>();
        ArrayNode paramsByJson = JSONUtils.parseArray((String)json);
        for (JsonNode jsonNode : paramsByJson) {
            Map param = JSONUtils.toMap((String)jsonNode.toString());
            allParams.add(param);
        }
        return allParams;
    }

    public static Map<String, String> getMapByString(String result) {
        String[] formatResult = result.split("\\$VarPool\\$");
        HashMap<String, String> format = new HashMap<String, String>();
        for (String info : formatResult) {
            if (!StringUtils.isNotEmpty((CharSequence)info) || !info.contains("=")) continue;
            String[] keyValue = info.split("=");
            format.put(keyValue[0], keyValue[1]);
        }
        return format;
    }

    public ResourceParametersHelper getResources() {
        return new ResourceParametersHelper();
    }

    public void addPropertyToValPool(Property property) {
        this.varPool.removeIf(p -> p.getProp().equals(property.getProp()));
        this.varPool.add(property);
    }
}

