/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.shell;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.task.api.shell.BaseShellInterceptor;
import org.apache.dolphinscheduler.plugin.task.api.shell.BaseShellInterceptorBuilder;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseLinuxShellInterceptorBuilder<T extends BaseLinuxShellInterceptorBuilder<T, Y>, Y extends BaseShellInterceptor>
extends BaseShellInterceptorBuilder<T, Y> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseLinuxShellInterceptorBuilder.class);

    protected void generateShellScript() throws IOException {
        ArrayList<String> finalScripts = new ArrayList<String>();
        finalScripts.add(this.shellHeader());
        finalScripts.add("BASEDIR=$(cd `dirname $0`; pwd)");
        finalScripts.add("cd $BASEDIR");
        finalScripts.addAll(this.systemEnvScript());
        finalScripts.addAll(this.customEnvScript());
        finalScripts.addAll(this.k8sConfig());
        finalScripts.add(this.shellBody());
        String finalScript = finalScripts.stream().collect(Collectors.joining(System.lineSeparator()));
        Path shellAbsolutePath = this.shellAbsolutePath();
        FileUtils.createFileWith755((Path)shellAbsolutePath);
        Files.write(shellAbsolutePath, finalScript.getBytes(), StandardOpenOption.APPEND);
        log.info("Final Shell file is : \n{}", (Object)finalScript);
    }

    protected List<String> generateBootstrapCommand() {
        if (this.sudoEnable) {
            return this.bootstrapCommandInSudoMode();
        }
        return this.bootstrapCommandInNormalMode();
    }

    protected abstract String shellHeader();

    protected abstract String shellInterpreter();

    protected abstract String shellExtension();

    private List<String> systemEnvScript() {
        if (CollectionUtils.isEmpty((Collection)this.systemEnvs)) {
            return Collections.emptyList();
        }
        return this.systemEnvs.stream().map(systemEnv -> "source " + systemEnv).collect(Collectors.toList());
    }

    private List<String> customEnvScript() {
        if (CollectionUtils.isEmpty((Collection)this.customEnvScripts)) {
            return Collections.emptyList();
        }
        return this.customEnvScripts;
    }

    private List<String> k8sConfig() throws IOException {
        if (StringUtils.isEmpty((CharSequence)this.k8sConfigYaml)) {
            return Collections.emptyList();
        }
        Path kubeConfigPath = Paths.get(FileUtils.getKubeConfigPath((String)this.shellDirectory), new String[0]);
        FileUtils.createFileWith755((Path)kubeConfigPath);
        Files.write(kubeConfigPath, this.k8sConfigYaml.getBytes(), StandardOpenOption.APPEND);
        log.info("Created kubernetes configuration file: {}.", (Object)kubeConfigPath);
        return Collections.singletonList("export KUBECONFIG=" + kubeConfigPath);
    }

    private String shellBody() {
        if (CollectionUtils.isEmpty((Collection)this.scripts)) {
            return "";
        }
        String scriptBody = this.scripts.stream().collect(Collectors.joining(System.lineSeparator()));
        scriptBody = scriptBody.replaceAll("\\r\\n", System.lineSeparator());
        return ParameterUtils.convertParameterPlaceholders(scriptBody, this.propertyMap);
    }

    private Path shellAbsolutePath() {
        return Paths.get(this.shellDirectory, this.shellName + this.shellExtension());
    }

    private List<String> bootstrapCommandInSudoMode() {
        if (PropertyUtils.getBoolean((String)"task.resource.limit.state", (Boolean)false).booleanValue()) {
            return this.bootstrapCommandInResourceLimitMode();
        }
        ArrayList<String> bootstrapCommand = new ArrayList<String>();
        bootstrapCommand.add("sudo");
        if (StringUtils.isNotBlank((CharSequence)this.runUser)) {
            bootstrapCommand.add("-u");
            bootstrapCommand.add(this.runUser);
        }
        bootstrapCommand.add("-i");
        bootstrapCommand.add(this.shellAbsolutePath().toString());
        return bootstrapCommand;
    }

    private List<String> bootstrapCommandInNormalMode() {
        ArrayList<String> bootstrapCommand = new ArrayList<String>();
        bootstrapCommand.add(this.shellInterpreter());
        bootstrapCommand.add(this.shellAbsolutePath().toString());
        return bootstrapCommand;
    }

    private List<String> bootstrapCommandInResourceLimitMode() {
        ArrayList<String> bootstrapCommand = new ArrayList<String>();
        bootstrapCommand.add("sudo");
        bootstrapCommand.add("systemd-run");
        bootstrapCommand.add("-q");
        bootstrapCommand.add("--scope");
        if (this.cpuQuota == -1) {
            bootstrapCommand.add("-p");
            bootstrapCommand.add("CPUQuota=");
        } else {
            bootstrapCommand.add("-p");
            bootstrapCommand.add(String.format("CPUQuota=%s%%", this.cpuQuota));
        }
        if (this.memoryQuota == -1) {
            bootstrapCommand.add("-p");
            bootstrapCommand.add(String.format("MemoryLimit=%s", "infinity"));
        } else {
            bootstrapCommand.add("-p");
            bootstrapCommand.add(String.format("MemoryLimit=%sM", this.memoryQuota));
        }
        bootstrapCommand.add(String.format("--uid=%s", this.runUser));
        return bootstrapCommand;
    }
}

