/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.utils;

import io.fabric8.kubernetes.client.dsl.LogWatch;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.dolphinscheduler.common.enums.ResourceManagerType;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.task.api.K8sTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.TaskConstants;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.am.ApplicationManager;
import org.apache.dolphinscheduler.plugin.task.api.am.KubernetesApplicationManager;
import org.apache.dolphinscheduler.plugin.task.api.am.KubernetesApplicationManagerContext;
import org.apache.dolphinscheduler.plugin.task.api.am.YarnApplicationManagerContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessUtils.class);
    private static final Map<ResourceManagerType, ApplicationManager> applicationManagerMap = new HashMap<ResourceManagerType, ApplicationManager>();
    private static final Pattern MACPATTERN;
    private static final Pattern WINDOWSPATTERN;
    private static final Pattern LINUXPATTERN;

    private ProcessUtils() {
        throw new IllegalStateException("Utility class");
    }

    @Deprecated
    public static boolean kill(@NonNull TaskExecutionContext request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        try {
            log.info("Begin kill task instance, processId: {}", (Object)request.getProcessId());
            int processId = request.getProcessId();
            if (processId == 0) {
                log.error("Task instance kill failed, processId is not exist");
                return false;
            }
            String cmd = String.format("kill -9 %s", ProcessUtils.getPidsStr(processId));
            cmd = OSUtils.getSudoCmd((String)request.getTenantCode(), (String)cmd);
            log.info("process id:{}, cmd:{}", (Object)processId, (Object)cmd);
            OSUtils.exeCmd((String)cmd);
            log.info("Success kill task instance, processId: {}", (Object)request.getProcessId());
            return true;
        }
        catch (Exception e) {
            log.error("Kill task instance error, processId: {}", (Object)request.getProcessId(), (Object)e);
            return false;
        }
    }

    public static String getPidsStr(int processId) throws Exception {
        String pids;
        StringBuilder sb = new StringBuilder();
        Matcher mat = null;
        if (SystemUtils.IS_OS_MAC) {
            pids = OSUtils.exeCmd((String)String.format("%s -sp %d", "pstree", processId));
            if (StringUtils.isNotEmpty((CharSequence)pids)) {
                mat = MACPATTERN.matcher(pids);
            }
        } else if (SystemUtils.IS_OS_LINUX) {
            pids = OSUtils.exeCmd((String)String.format("%s -p %d", "pstree", processId));
            if (StringUtils.isNotEmpty((CharSequence)pids)) {
                mat = LINUXPATTERN.matcher(pids);
            }
        } else {
            pids = OSUtils.exeCmd((String)String.format("%s -p %d", "pstree", processId));
            if (StringUtils.isNotEmpty((CharSequence)pids)) {
                mat = WINDOWSPATTERN.matcher(pids);
            }
        }
        if (null != mat) {
            while (mat.find()) {
                sb.append(mat.group(1)).append(" ");
            }
        }
        return sb.toString().trim();
    }

    public static void cancelApplication(TaskExecutionContext taskExecutionContext) {
        try {
            if (Objects.nonNull(taskExecutionContext.getK8sTaskExecutionContext())) {
                if (!TaskConstants.TASK_TYPE_SET_K8S.contains(taskExecutionContext.getTaskType())) {
                    applicationManagerMap.get(ResourceManagerType.KUBERNETES).killApplication(new KubernetesApplicationManagerContext(taskExecutionContext.getK8sTaskExecutionContext(), taskExecutionContext.getTaskAppId(), ""));
                }
            } else {
                List<String> appIds;
                String host = taskExecutionContext.getHost();
                String executePath = taskExecutionContext.getExecutePath();
                String tenantCode = taskExecutionContext.getTenantCode();
                if (StringUtils.isNotEmpty((CharSequence)taskExecutionContext.getAppIds())) {
                    appIds = Arrays.asList(taskExecutionContext.getAppIds().split(","));
                } else {
                    String logPath = taskExecutionContext.getLogPath();
                    String appInfoPath = taskExecutionContext.getAppInfoPath();
                    if (logPath == null || appInfoPath == null || executePath == null || tenantCode == null) {
                        log.error("Kill yarn job error, the input params is illegal, host: {}, logPath: {}, appInfoPath: {}, executePath: {}, tenantCode: {}", new Object[]{host, logPath, appInfoPath, executePath, tenantCode});
                        throw new TaskException("Cancel application failed!");
                    }
                    log.info("Get appIds from worker {}, taskLogPath: {}", (Object)host, (Object)logPath);
                    appIds = LogUtils.getAppIds(logPath, appInfoPath, PropertyUtils.getString((String)"appId.collect", (String)"log"));
                    taskExecutionContext.setAppIds(String.join((CharSequence)",", appIds));
                }
                if (CollectionUtils.isEmpty(appIds)) {
                    log.info("The appId is empty");
                    return;
                }
                ApplicationManager applicationManager = applicationManagerMap.get(ResourceManagerType.YARN);
                applicationManager.killApplication(new YarnApplicationManagerContext(executePath, tenantCode, appIds));
            }
        }
        catch (Exception e) {
            log.error("Cancel application failed: {}", (Object)e.getMessage());
        }
    }

    public static TaskExecutionStatus getApplicationStatus(K8sTaskExecutionContext k8sTaskExecutionContext, String taskAppId) {
        if (Objects.isNull(k8sTaskExecutionContext)) {
            return TaskExecutionStatus.SUCCESS;
        }
        KubernetesApplicationManager applicationManager = (KubernetesApplicationManager)applicationManagerMap.get(ResourceManagerType.KUBERNETES);
        return applicationManager.getApplicationStatus(new KubernetesApplicationManagerContext(k8sTaskExecutionContext, taskAppId, ""));
    }

    public static LogWatch getPodLogWatcher(K8sTaskExecutionContext k8sTaskExecutionContext, String taskAppId, String containerName) {
        KubernetesApplicationManager applicationManager = (KubernetesApplicationManager)applicationManagerMap.get(ResourceManagerType.KUBERNETES);
        return applicationManager.getPodLogWatcher(new KubernetesApplicationManagerContext(k8sTaskExecutionContext, taskAppId, containerName));
    }

    static {
        ServiceLoader.load(ApplicationManager.class).forEach(applicationManager -> applicationManagerMap.put(applicationManager.getResourceManagerType(), (ApplicationManager)applicationManager));
        MACPATTERN = Pattern.compile("-[+|-]-\\s(\\d+)");
        WINDOWSPATTERN = Pattern.compile("(\\d+)");
        LINUXPATTERN = Pattern.compile("\\((\\d+)\\)");
    }
}

