/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.k8s;

import java.util.HashMap;
import java.util.Map;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskResponse;
import org.apache.dolphinscheduler.plugin.task.api.utils.K8sUtils;
import org.yaml.snakeyaml.Yaml;

public abstract class AbstractK8sTaskExecutor {
    protected TaskExecutionContext taskRequest;
    protected K8sUtils k8sUtils;
    protected Yaml yaml;
    protected volatile Map<String, String> taskOutputParams;

    protected AbstractK8sTaskExecutor(TaskExecutionContext taskRequest) {
        this.taskRequest = taskRequest;
        this.k8sUtils = new K8sUtils();
        this.yaml = new Yaml();
        this.taskOutputParams = new HashMap<String, String>();
    }

    public Map<String, String> getTaskOutputParams() {
        return this.taskOutputParams;
    }

    public abstract TaskResponse run(String var1) throws Exception;

    public abstract void cancelApplication(String var1);

    public void waitTimeout(Boolean timeout) throws TaskException {
        if (Boolean.TRUE.equals(timeout)) {
            throw new TaskException("K8sTask is timeout");
        }
    }

    public abstract void submitJob2k8s(String var1);

    public abstract void stopJobOnK8s(String var1);
}

