/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.k8s.impl;

import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.AffinityBuilder;
import io.fabric8.kubernetes.api.model.AffinityFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.NodeAffinityFluent;
import io.fabric8.kubernetes.api.model.NodeSelectorTerm;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.batch.v1.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.JobFluent;
import io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluent;
import io.fabric8.kubernetes.api.model.batch.v1.JobStatus;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.K8sTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.plugin.task.api.k8s.AbstractK8sTaskExecutor;
import org.apache.dolphinscheduler.plugin.task.api.k8s.K8sTaskMainParameters;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskResponse;
import org.apache.dolphinscheduler.plugin.task.api.parser.TaskOutputParameterParser;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.MapUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.ProcessUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8sTaskExecutor
extends AbstractK8sTaskExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(K8sTaskExecutor.class);
    private Job job;
    protected boolean podLogOutputIsFinished = false;
    protected Future<?> podLogOutputFuture;

    public K8sTaskExecutor(TaskExecutionContext taskRequest) {
        super(taskRequest);
    }

    public void buildK8sJob(K8sTaskMainParameters k8STaskMainParameters) {
        String taskInstanceId = String.valueOf(this.taskRequest.getTaskInstanceId());
        String taskName = this.taskRequest.getTaskName().toLowerCase(Locale.ROOT);
        String image = k8STaskMainParameters.getImage();
        String pullSecret = k8STaskMainParameters.getPullSecret();
        String namespaceName = k8STaskMainParameters.getNamespaceName();
        String imagePullPolicy = k8STaskMainParameters.getImagePullPolicy();
        Map<String, String> otherParams = k8STaskMainParameters.getParamsMap();
        Double podMem = k8STaskMainParameters.getMinMemorySpace();
        Double podCpu = k8STaskMainParameters.getMinCpuCores();
        Double limitPodMem = podMem * 2.0;
        Double limitPodCpu = podCpu * 2.0;
        int retryNum = 0;
        String k8sJobName = String.format("%s-%s", taskName, taskInstanceId);
        HashMap<String, Quantity> reqRes = new HashMap<String, Quantity>();
        reqRes.put("memory", new Quantity(String.format("%s%s", podMem, "Mi")));
        reqRes.put("cpu", new Quantity(String.valueOf(podCpu)));
        HashMap<String, Quantity> limitRes = new HashMap<String, Quantity>();
        limitRes.put("memory", new Quantity(String.format("%s%s", limitPodMem, "Mi")));
        limitRes.put("cpu", new Quantity(String.valueOf(limitPodCpu)));
        Map<String, String> labelMap = k8STaskMainParameters.getLabelMap();
        HashMap<String, String> jobLabelMap = new HashMap<String, String>();
        jobLabelMap.put("k8s.cn/layer", "batch");
        jobLabelMap.put("k8s.cn/name", k8sJobName);
        jobLabelMap.putAll(labelMap);
        HashMap<String, String> podLabelMap = new HashMap<String, String>();
        podLabelMap.put("dolphinscheduler-label", this.taskRequest.getTaskAppId());
        podLabelMap.putAll(labelMap);
        EnvVar taskInstanceIdVar = new EnvVar("taskInstanceId", taskInstanceId, null);
        ArrayList<EnvVar> envVars = new ArrayList<EnvVar>();
        envVars.add(taskInstanceIdVar);
        if (MapUtils.isNotEmpty(otherParams)) {
            for (Map.Entry<String, String> entry : otherParams.entrySet()) {
                String param = entry.getKey();
                String paramValue = entry.getValue();
                EnvVar envVar = new EnvVar(param, paramValue, null);
                envVars.add(envVar);
            }
        }
        String commandString = k8STaskMainParameters.getCommand();
        String argsString = k8STaskMainParameters.getArgs();
        List commands = new ArrayList();
        List args = new ArrayList();
        try {
            if (!StringUtils.isEmpty((CharSequence)commandString)) {
                commands = (List)this.yaml.load(commandString.trim());
            }
            if (!StringUtils.isEmpty((CharSequence)argsString)) {
                args = (List)this.yaml.load(argsString.trim());
            }
        }
        catch (Exception e) {
            throw new TaskException("Parse yaml-like commands and args failed", e);
        }
        NodeSelectorTerm nodeSelectorTerm = new NodeSelectorTerm();
        nodeSelectorTerm.setMatchExpressions(k8STaskMainParameters.getNodeSelectorRequirements());
        Affinity affinity = k8STaskMainParameters.getNodeSelectorRequirements().size() == 0 ? null : ((AffinityBuilder)((AffinityFluent.NodeAffinityNested)((NodeAffinityFluent.RequiredDuringSchedulingIgnoredDuringExecutionNested)new AffinityBuilder().withNewNodeAffinity().withNewRequiredDuringSchedulingIgnoredDuringExecution().addNewNodeSelectorTermLike(nodeSelectorTerm).endNodeSelectorTerm()).endRequiredDuringSchedulingIgnoredDuringExecution()).endNodeAffinity()).build();
        this.job = ((JobBuilder)((JobFluent.SpecNested)((JobFluent.SpecNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((JobSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((JobFluent.SpecNested)((JobBuilder)((JobFluent.MetadataNested)((JobFluent.MetadataNested)((JobFluent.MetadataNested)((JobBuilder)new JobBuilder().withApiVersion("batch/v1")).withNewMetadata().withName(k8sJobName)).withLabels(jobLabelMap)).withNamespace(namespaceName)).endMetadata()).withNewSpec().withTtlSecondsAfterFinished(Integer.valueOf(300))).withNewTemplate().withNewMetadata().withLabels(podLabelMap)).endMetadata()).withNewSpec().addNewContainer().withName(k8sJobName)).withImage(image)).withCommand(commands.size() == 0 ? null : commands)).withArgs(args.size() == 0 ? null : args)).withImagePullPolicy(imagePullPolicy)).withResources(new ResourceRequirements(limitRes, reqRes))).withEnv(envVars)).endContainer()).withImagePullSecrets(StringUtils.isEmpty((CharSequence)pullSecret) ? null : Collections.singletonList(new LocalObjectReference(pullSecret)))).withRestartPolicy("Never")).withAffinity(affinity)).endSpec()).endTemplate()).withBackoffLimit(Integer.valueOf(retryNum))).endSpec()).build();
    }

    public void registerBatchJobWatcher(final Job job, final String taskInstanceId, final TaskResponse taskResponse) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Watcher<Job> watcher = new Watcher<Job>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void eventReceived(Watcher.Action action, Job job2) {
                try {
                    LogUtils.setWorkflowAndTaskInstanceIDMDC(K8sTaskExecutor.this.taskRequest.getProcessInstanceId(), K8sTaskExecutor.this.taskRequest.getTaskInstanceId());
                    LogUtils.setTaskInstanceLogFullPathMDC(K8sTaskExecutor.this.taskRequest.getLogPath());
                    log.info("event received : job:{} action:{}", (Object)job2.getMetadata().getName(), (Object)action);
                    if (action == Watcher.Action.DELETED) {
                        log.error("[K8sJobExecutor-{}] fail in k8s", (Object)job2.getMetadata().getName());
                        taskResponse.setExitStatusCode(-1);
                        countDownLatch.countDown();
                    } else if (action != Watcher.Action.ADDED) {
                        int jobStatus = K8sTaskExecutor.this.getK8sJobStatus(job2);
                        log.info("job {} status {}", (Object)job2.getMetadata().getName(), (Object)jobStatus);
                        if (jobStatus == 1) {
                            return;
                        }
                        K8sTaskExecutor.this.setTaskStatus(jobStatus, taskInstanceId, taskResponse);
                        countDownLatch.countDown();
                    }
                }
                finally {
                    LogUtils.removeTaskInstanceLogFullPathMDC();
                    LogUtils.removeWorkflowAndTaskInstanceIdMDC();
                }
            }

            public void onClose(WatcherException e) {
                LogUtils.setWorkflowAndTaskInstanceIDMDC(K8sTaskExecutor.this.taskRequest.getProcessInstanceId(), K8sTaskExecutor.this.taskRequest.getTaskInstanceId());
                log.error("[K8sJobExecutor-{}] fail in k8s: {}", (Object)job.getMetadata().getName(), (Object)e.getMessage());
                taskResponse.setExitStatusCode(-1);
                countDownLatch.countDown();
                LogUtils.removeWorkflowAndTaskInstanceIdMDC();
            }
        };
        try (Watch watch = this.k8sUtils.createBatchJobWatcher(job.getMetadata().getName(), watcher);){
            boolean timeoutFlag;
            boolean bl = timeoutFlag = this.taskRequest.getTaskTimeoutStrategy() == TaskTimeoutStrategy.FAILED || this.taskRequest.getTaskTimeoutStrategy() == TaskTimeoutStrategy.WARNFAILED;
            if (timeoutFlag) {
                Boolean timeout = !countDownLatch.await(this.taskRequest.getTaskTimeout(), TimeUnit.SECONDS);
                this.waitTimeout(timeout);
            } else {
                countDownLatch.await();
            }
        }
        catch (InterruptedException e) {
            log.error("job failed in k8s: {}", (Object)e.getMessage(), (Object)e);
            Thread.currentThread().interrupt();
            taskResponse.setExitStatusCode(-1);
        }
        catch (Exception e) {
            log.error("job failed in k8s: {}", (Object)e.getMessage(), (Object)e);
            taskResponse.setExitStatusCode(-1);
        }
    }

    private void parsePodLogOutput() {
        ScheduledExecutorService collectPodLogExecutorService = ThreadUtils.newSingleDaemonScheduledExecutorService((String)("CollectPodLogOutput-thread-" + this.taskRequest.getTaskName()));
        String taskInstanceId = String.valueOf(this.taskRequest.getTaskInstanceId());
        String taskName = this.taskRequest.getTaskName().toLowerCase(Locale.ROOT);
        String containerName = String.format("%s-%s", taskName, taskInstanceId);
        this.podLogOutputFuture = collectPodLogExecutorService.submit(() -> {
            TaskOutputParameterParser taskOutputParameterParser = new TaskOutputParameterParser();
            LogUtils.setWorkflowAndTaskInstanceIDMDC(this.taskRequest.getProcessInstanceId(), this.taskRequest.getTaskInstanceId());
            LogUtils.setTaskInstanceLogFullPathMDC(this.taskRequest.getLogPath());
            try (LogWatch watcher = ProcessUtils.getPodLogWatcher(this.taskRequest.getK8sTaskExecutionContext(), this.taskRequest.getTaskAppId(), containerName);
                 BufferedReader reader = new BufferedReader(new InputStreamReader(watcher.getOutput()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    log.info("[K8S-pod-log] {}", (Object)line);
                    taskOutputParameterParser.appendParseLog(line);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                LogUtils.removeTaskInstanceLogFullPathMDC();
                this.podLogOutputIsFinished = true;
            }
            this.taskOutputParams = taskOutputParameterParser.getTaskOutputParams();
        });
        collectPodLogExecutorService.shutdown();
    }

    @Override
    public TaskResponse run(String k8sParameterStr) throws Exception {
        TaskResponse result = new TaskResponse();
        int taskInstanceId = this.taskRequest.getTaskInstanceId();
        try {
            if (StringUtils.isEmpty((CharSequence)k8sParameterStr)) {
                return result;
            }
            K8sTaskExecutionContext k8sTaskExecutionContext = this.taskRequest.getK8sTaskExecutionContext();
            String configYaml = k8sTaskExecutionContext.getConfigYaml();
            this.k8sUtils.buildClient(configYaml);
            this.submitJob2k8s(k8sParameterStr);
            this.parsePodLogOutput();
            this.registerBatchJobWatcher(this.job, Integer.toString(taskInstanceId), result);
            if (this.podLogOutputFuture != null) {
                try {
                    this.podLogOutputFuture.get();
                }
                catch (ExecutionException e) {
                    log.error("Handle pod log error", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this.cancelApplication(k8sParameterStr);
            Thread.currentThread().interrupt();
            result.setExitStatusCode(-1);
            throw e;
        }
        return result;
    }

    @Override
    public void cancelApplication(String k8sParameterStr) {
        if (this.job != null) {
            this.stopJobOnK8s(k8sParameterStr);
        }
    }

    @Override
    public void submitJob2k8s(String k8sParameterStr) {
        int taskInstanceId = this.taskRequest.getTaskInstanceId();
        String taskName = this.taskRequest.getTaskName().toLowerCase(Locale.ROOT);
        K8sTaskMainParameters k8STaskMainParameters = (K8sTaskMainParameters)JSONUtils.parseObject((String)k8sParameterStr, K8sTaskMainParameters.class);
        try {
            log.info("[K8sJobExecutor-{}-{}] start to submit job", (Object)taskName, (Object)taskInstanceId);
            this.buildK8sJob(k8STaskMainParameters);
            this.stopJobOnK8s(k8sParameterStr);
            String namespaceName = k8STaskMainParameters.getNamespaceName();
            this.k8sUtils.createJob(namespaceName, this.job);
            log.info("[K8sJobExecutor-{}-{}] submitted job successfully", (Object)taskName, (Object)taskInstanceId);
        }
        catch (Exception e) {
            log.error("[K8sJobExecutor-{}-{}] fail to submit job", (Object)taskName, (Object)taskInstanceId);
            throw new TaskException("K8sJobExecutor fail to submit job", e);
        }
    }

    @Override
    public void stopJobOnK8s(String k8sParameterStr) {
        K8sTaskMainParameters k8STaskMainParameters = (K8sTaskMainParameters)JSONUtils.parseObject((String)k8sParameterStr, K8sTaskMainParameters.class);
        String namespaceName = k8STaskMainParameters.getNamespaceName();
        String jobName = this.job.getMetadata().getName();
        try {
            if (Boolean.TRUE.equals(this.k8sUtils.jobExist(jobName, namespaceName))) {
                this.k8sUtils.deleteJob(jobName, namespaceName);
            }
        }
        catch (Exception e) {
            log.error("[K8sJobExecutor-{}] fail to stop job", (Object)jobName);
            throw new TaskException("K8sJobExecutor fail to stop job", e);
        }
    }

    public int getK8sJobStatus(Job job) {
        JobStatus jobStatus = job.getStatus();
        if (jobStatus.getSucceeded() != null && jobStatus.getSucceeded() == 1) {
            return 0;
        }
        if (jobStatus.getFailed() != null && jobStatus.getFailed() == 1) {
            return -1;
        }
        return 1;
    }

    public void setTaskStatus(int jobStatus, String taskInstanceId, TaskResponse taskResponse) {
        if (jobStatus == 0 || jobStatus == -1) {
            if (jobStatus == 0) {
                log.info("[K8sJobExecutor-{}] succeed in k8s", (Object)this.job.getMetadata().getName());
                taskResponse.setExitStatusCode(0);
            } else {
                log.error("[K8sJobExecutor-{}] fail in k8s", (Object)this.job.getMetadata().getName());
                taskResponse.setExitStatusCode(-1);
            }
        }
    }

    public Job getJob() {
        return this.job;
    }

    public void setJob(Job job) {
        this.job = job;
    }
}

