/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.parameters;

import com.google.common.base.Enums;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.SQLTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.DataType;
import org.apache.dolphinscheduler.plugin.task.api.enums.ResourceType;
import org.apache.dolphinscheduler.plugin.task.api.enums.UdfType;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.model.ResourceInfo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.resource.DataSourceParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.resource.ResourceParametersHelper;
import org.apache.dolphinscheduler.plugin.task.api.parameters.resource.UdfFuncParameters;

public class SqlParameters
extends AbstractParameters {
    private String type;
    private int datasource;
    private String sql;
    private int sqlType;
    private Boolean sendEmail;
    private int displayRows;
    private String udfs;
    private String showType;
    private String connParams;
    private List<String> preStatements;
    private List<String> postStatements;
    private int groupId;
    private String title;
    private int limit;

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getDatasource() {
        return this.datasource;
    }

    public void setDatasource(int datasource) {
        this.datasource = datasource;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getUdfs() {
        return this.udfs;
    }

    public void setUdfs(String udfs) {
        this.udfs = udfs;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(int sqlType) {
        this.sqlType = sqlType;
    }

    public Boolean getSendEmail() {
        return this.sendEmail;
    }

    public void setSendEmail(Boolean sendEmail) {
        this.sendEmail = sendEmail;
    }

    public int getDisplayRows() {
        return this.displayRows;
    }

    public void setDisplayRows(int displayRows) {
        this.displayRows = displayRows;
    }

    public String getShowType() {
        return this.showType;
    }

    public void setShowType(String showType) {
        this.showType = showType;
    }

    public String getConnParams() {
        return this.connParams;
    }

    public void setConnParams(String connParams) {
        this.connParams = connParams;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<String> getPreStatements() {
        return this.preStatements;
    }

    public void setPreStatements(List<String> preStatements) {
        this.preStatements = preStatements;
    }

    public List<String> getPostStatements() {
        return this.postStatements;
    }

    public void setPostStatements(List<String> postStatements) {
        this.postStatements = postStatements;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    @Override
    public boolean checkParameters() {
        return this.datasource != 0 && StringUtils.isNotEmpty((CharSequence)this.type) && StringUtils.isNotEmpty((CharSequence)this.sql);
    }

    @Override
    public List<ResourceInfo> getResourceFilesList() {
        return new ArrayList<ResourceInfo>();
    }

    public void dealOutParam(String result) {
        if (CollectionUtils.isEmpty((Collection)this.localParams)) {
            return;
        }
        List<Property> outProperty = this.getOutProperty(this.localParams);
        if (CollectionUtils.isEmpty(outProperty)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)result)) {
            this.varPool.addAll(outProperty);
            return;
        }
        List<Map<String, String>> sqlResult = this.getListMapByString(result);
        if (CollectionUtils.isEmpty(sqlResult)) {
            return;
        }
        if (sqlResult.size() > 1) {
            HashMap sqlResultFormat = new HashMap();
            Set<String> keySet = sqlResult.get(0).keySet();
            for (String string : keySet) {
                sqlResultFormat.put(string, new ArrayList());
            }
            for (Map map : sqlResult) {
                for (String key : map.keySet()) {
                    ((List)sqlResultFormat.get(key)).add(String.valueOf(map.get(key)));
                }
            }
            for (Property property : outProperty) {
                if (property.getType() != DataType.LIST) continue;
                property.setValue(JSONUtils.toJsonString(sqlResultFormat.get(property.getProp())));
                this.varPool.add(property);
            }
        } else {
            Map<String, String> firstRow = sqlResult.get(0);
            for (Property info : outProperty) {
                info.setValue(String.valueOf(firstRow.get(info.getProp())));
                this.varPool.add(info);
            }
        }
    }

    public String toString() {
        return "SqlParameters{type='" + this.type + '\'' + ", datasource=" + this.datasource + ", sql='" + this.sql + '\'' + ", sqlType=" + this.sqlType + ", sendEmail=" + this.sendEmail + ", displayRows=" + this.displayRows + ", limit=" + this.limit + ", udfs='" + this.udfs + '\'' + ", showType='" + this.showType + '\'' + ", connParams='" + this.connParams + '\'' + ", groupId='" + this.groupId + '\'' + ", title='" + this.title + '\'' + ", preStatements=" + this.preStatements + ", postStatements=" + this.postStatements + '}';
    }

    @Override
    public ResourceParametersHelper getResources() {
        boolean udfTypeFlag;
        ResourceParametersHelper resources = super.getResources();
        resources.put(ResourceType.DATASOURCE, this.datasource);
        boolean bl = udfTypeFlag = Enums.getIfPresent(UdfType.class, (String)Strings.nullToEmpty((String)this.getType())).isPresent() && !StringUtils.isEmpty((CharSequence)this.getUdfs());
        if (udfTypeFlag) {
            String[] udfFunIds = this.getUdfs().split(",");
            for (int i = 0; i < udfFunIds.length; ++i) {
                resources.put(ResourceType.UDF, Integer.parseInt(udfFunIds[i]));
            }
        }
        return resources;
    }

    public SQLTaskExecutionContext generateExtendedContext(ResourceParametersHelper parametersHelper) {
        boolean udfTypeFlag;
        SQLTaskExecutionContext sqlTaskExecutionContext = new SQLTaskExecutionContext();
        DataSourceParameters dbSource = (DataSourceParameters)parametersHelper.getResourceParameters(ResourceType.DATASOURCE, this.datasource);
        sqlTaskExecutionContext.setConnectionParams(dbSource.getConnectionParams());
        boolean bl = udfTypeFlag = Enums.getIfPresent(UdfType.class, (String)Strings.nullToEmpty((String)this.getType())).isPresent() && !StringUtils.isEmpty((CharSequence)this.getUdfs());
        if (udfTypeFlag) {
            List<UdfFuncParameters> collect = parametersHelper.getResourceMap(ResourceType.UDF).entrySet().stream().map(entry -> (UdfFuncParameters)entry.getValue()).collect(Collectors.toList());
            sqlTaskExecutionContext.setUdfFuncParametersList(collect);
        }
        return sqlTaskExecutionContext;
    }
}

