/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.parser;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.dolphinscheduler.plugin.task.api.parser.PropertyPlaceholderHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimePlaceholderUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimePlaceholderUtils.class);
    public static final String PLACEHOLDER_PREFIX = "$[";
    public static final String PLACEHOLDER_SUFFIX = "]";

    public static String replacePlaceholders(String value, Date date, boolean ignoreUnresolvablePlaceholders) {
        PropertyPlaceholderHelper strictHelper = TimePlaceholderUtils.getPropertyPlaceholderHelper(false);
        PropertyPlaceholderHelper nonStrictHelper = TimePlaceholderUtils.getPropertyPlaceholderHelper(true);
        PropertyPlaceholderHelper helper = ignoreUnresolvablePlaceholders ? nonStrictHelper : strictHelper;
        return helper.replacePlaceholders(value, new TimePlaceholderResolver(value, date));
    }

    private static PropertyPlaceholderHelper getPropertyPlaceholderHelper(boolean ignoreUnresolvablePlaceholders) {
        return new PropertyPlaceholderHelper(PLACEHOLDER_PREFIX, PLACEHOLDER_SUFFIX, null, ignoreUnresolvablePlaceholders);
    }

    public static Integer calculate(String expression) {
        expression = StringUtils.trim((String)expression);
        expression = TimePlaceholderUtils.convert(expression);
        List<String> result = TimePlaceholderUtils.string2List(expression);
        result = TimePlaceholderUtils.convert2SuffixList(result);
        return TimePlaceholderUtils.calculate(result);
    }

    private static String convert(String expression) {
        char[] arr = expression.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            char c;
            if (arr[i] == '-') {
                if (i == 0) {
                    arr[i] = 78;
                    continue;
                }
                c = arr[i - 1];
                if (c != '+' && c != '-' && c != '*' && c != '/' && c != '(') continue;
                arr[i] = 78;
                continue;
            }
            if (arr[i] != '+') continue;
            if (i == 0) {
                arr[i] = 80;
                continue;
            }
            c = arr[i - 1];
            if (c != '+' && c != '-' && c != '*' && c != '/' && c != '(') continue;
            arr[i] = 80;
        }
        return new String(arr);
    }

    private static List<String> convert2SuffixList(List<String> srcList) {
        ArrayList<String> result = new ArrayList<String>();
        Stack<String> stack = new Stack<String>();
        block4: for (int i = 0; i < srcList.size(); ++i) {
            if (Character.isDigit(srcList.get(i).charAt(0))) {
                result.add(srcList.get(i));
                continue;
            }
            switch (srcList.get(i).charAt(0)) {
                case '(': {
                    stack.push(srcList.get(i));
                    continue block4;
                }
                case ')': {
                    while (!"(".equals(stack.peek())) {
                        result.add((String)stack.pop());
                    }
                    stack.pop();
                    continue block4;
                }
                default: {
                    while (!stack.isEmpty() && TimePlaceholderUtils.compare((String)stack.peek(), srcList.get(i))) {
                        result.add((String)stack.pop());
                    }
                    stack.push(srcList.get(i));
                }
            }
        }
        while (!stack.isEmpty()) {
            result.add((String)stack.pop());
        }
        return result;
    }

    private static Integer calculate(List<String> result) {
        Stack<Integer> stack = new Stack<Integer>();
        for (int i = 0; i < result.size(); ++i) {
            if (Character.isDigit(result.get(i).charAt(0))) {
                stack.push(Integer.parseInt(result.get(i)));
                continue;
            }
            Integer backInt = (Integer)stack.pop();
            Integer frontInt = 0;
            char op = result.get(i).charAt(0);
            if (op != 'P' && op != 'N') {
                frontInt = (Integer)stack.pop();
            }
            Integer res = 0;
            switch (result.get(i).charAt(0)) {
                case 'P': {
                    res = frontInt + backInt;
                    break;
                }
                case 'N': {
                    res = frontInt - backInt;
                    break;
                }
                case '+': {
                    res = frontInt + backInt;
                    break;
                }
                case '-': {
                    res = frontInt - backInt;
                    break;
                }
                case '*': {
                    res = frontInt * backInt;
                    break;
                }
                case '/': {
                    res = frontInt / backInt;
                    break;
                }
            }
            stack.push(res);
        }
        return (Integer)stack.pop();
    }

    private static List<String> string2List(String expression) {
        ArrayList<String> result = new ArrayList<String>();
        String num = "";
        for (int i = 0; i < expression.length(); ++i) {
            if (Character.isDigit(expression.charAt(i))) {
                num = num + expression.charAt(i);
                continue;
            }
            if (!StringUtils.isEmpty((CharSequence)num)) {
                result.add(num);
            }
            result.add(expression.charAt(i) + "");
            num = "";
        }
        if (!num.isEmpty()) {
            result.add(num);
        }
        return result;
    }

    private static boolean compare(String peek, String cur) {
        if ("*".equals(peek) && ("/".equals(cur) || "*".equals(cur) || "+".equals(cur) || "-".equals(cur))) {
            return true;
        }
        if ("/".equals(peek) && ("/".equals(cur) || "*".equals(cur) || "+".equals(cur) || "-".equals(cur))) {
            return true;
        }
        if ("+".equals(peek) && ("+".equals(cur) || "-".equals(cur))) {
            return true;
        }
        return "-".equals(peek) && ("+".equals(cur) || "-".equals(cur));
    }

    public static String getPlaceHolderTime(String expression, Date date) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            throw new IllegalArgumentException("expression is null");
        }
        if (null == date) {
            throw new IllegalArgumentException("date is null");
        }
        return TimePlaceholderUtils.calculateTime(expression, date);
    }

    private static String calculateTime(String expression, Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Cannot parse the expression: " + expression + ", date is null");
        }
        try {
            if (expression.startsWith("timestamp")) {
                String timeExpression = expression.substring("timestamp".length() + 1, expression.length() - 1);
                Map.Entry<Date, String> entry = TimePlaceholderUtils.calcTimeExpression(timeExpression, date);
                String dateStr = org.apache.dolphinscheduler.common.utils.DateUtils.format((Date)entry.getKey(), (String)entry.getValue());
                Date timestamp = org.apache.dolphinscheduler.common.utils.DateUtils.parse((String)dateStr, (String)"yyyyMMddHHmmss");
                return String.valueOf(timestamp.getTime() / 1000L);
            }
            if (expression.startsWith("year_week")) {
                return TimePlaceholderUtils.calculateYearWeek(expression, date);
            }
            Map.Entry<Date, String> entry = TimePlaceholderUtils.calcTimeExpression(expression, date);
            return org.apache.dolphinscheduler.common.utils.DateUtils.format((Date)entry.getKey(), (String)entry.getValue());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unsupported placeholder expression: " + expression, e);
        }
    }

    public static String calculateYearWeek(String expression, Date date) {
        String dataFormat = expression.substring("year_week".length() + 1, expression.length() - 1);
        String targetDate = "";
        try {
            if (dataFormat.contains(",")) {
                String param1 = dataFormat.split(",")[0];
                String param2 = dataFormat.split(",")[1];
                dataFormat = param1;
                targetDate = TimePlaceholderUtils.transformYearWeek(date, dataFormat, TimePlaceholderUtils.calculate(param2));
            } else {
                targetDate = TimePlaceholderUtils.transformYearWeek(date, dataFormat, 1);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("expression not valid");
        }
        return targetDate;
    }

    private static String transformYearWeek(Date date, String format, int weekDay) {
        Calendar calendar = Calendar.getInstance();
        calendar.setMinimalDaysInFirstWeek(4);
        switch (weekDay) {
            case 2: {
                calendar.setFirstDayOfWeek(3);
                break;
            }
            case 3: {
                calendar.setFirstDayOfWeek(4);
                break;
            }
            case 4: {
                calendar.setFirstDayOfWeek(5);
                break;
            }
            case 5: {
                calendar.setFirstDayOfWeek(6);
                break;
            }
            case 6: {
                calendar.setFirstDayOfWeek(7);
                break;
            }
            case 7: {
                calendar.setFirstDayOfWeek(1);
                break;
            }
            default: {
                calendar.setFirstDayOfWeek(2);
            }
        }
        calendar.setTimeInMillis(date.getTime());
        int weekOfYear = calendar.get(3);
        int year = calendar.get(1);
        String weekYearStr = "";
        weekYearStr = weekOfYear < 10 && format.contains("-") ? String.format("%d%s0%d", year, "-", weekOfYear) : (weekOfYear >= 10 && format.contains("-") ? String.format("%d%s%d", year, "-", weekOfYear) : (weekOfYear < 10 ? String.format("%d0%d", year, weekOfYear) : String.format("%d%d", year, weekOfYear)));
        return weekYearStr;
    }

    public static Map.Entry<Date, String> calcTimeExpression(String expression, Date date) {
        Map.Entry<Date, String> resultEntry = expression.startsWith("add_months") ? TimePlaceholderUtils.calcMonths(expression, date) : (expression.startsWith("month_begin") ? TimePlaceholderUtils.calcMonthBegin(expression, date) : (expression.startsWith("month_end") ? TimePlaceholderUtils.calcMonthEnd(expression, date) : (expression.startsWith("week_begin") ? TimePlaceholderUtils.calcWeekStart(expression, date) : (expression.startsWith("week_end") ? TimePlaceholderUtils.calcWeekEnd(expression, date) : (expression.startsWith("month_first_day") ? TimePlaceholderUtils.calcCustomDay(expression, "month_first_day", date) : (expression.startsWith("month_last_day") ? TimePlaceholderUtils.calcCustomDay(expression, "month_last_day", date) : (expression.startsWith("this_day") ? TimePlaceholderUtils.calcCustomDay(expression, "this_day", date) : (expression.startsWith("last_day") ? TimePlaceholderUtils.calcCustomDay(expression, "last_day", date) : (expression.startsWith("week_first_day") ? TimePlaceholderUtils.calcCustomDay(expression, "week_first_day", date) : (expression.startsWith("week_last_day") ? TimePlaceholderUtils.calcCustomDay(expression, "week_last_day", date) : TimePlaceholderUtils.calcMinutes(expression, date)))))))))));
        return resultEntry;
    }

    public static Map.Entry<Date, String> calcMonthBegin(String expression, Date date) {
        String addMonthExpr = expression.substring("month_begin".length() + 1, expression.length() - 1);
        String[] params = addMonthExpr.split(",");
        if (params.length == 2) {
            String dateFormat = params[0];
            String dayExpr = params[1];
            Integer day = TimePlaceholderUtils.calculate(dayExpr);
            Date targetDate = org.apache.dolphinscheduler.common.utils.DateUtils.getFirstDayOfMonth((Date)date);
            targetDate = org.apache.dolphinscheduler.common.utils.DateUtils.addDays((Date)targetDate, (int)day);
            return new AbstractMap.SimpleImmutableEntry<Date, String>(targetDate, dateFormat);
        }
        throw new RuntimeException("expression not valid");
    }

    public static Map.Entry<Date, String> calcMonthEnd(String expression, Date date) {
        String addMonthExpr = expression.substring("month_end".length() + 1, expression.length() - 1);
        String[] params = addMonthExpr.split(",");
        if (params.length == 2) {
            String dateFormat = params[0];
            String dayExpr = params[1];
            Integer day = TimePlaceholderUtils.calculate(dayExpr);
            Date targetDate = org.apache.dolphinscheduler.common.utils.DateUtils.getLastDayOfMonth((Date)date);
            targetDate = org.apache.dolphinscheduler.common.utils.DateUtils.addDays((Date)targetDate, (int)day);
            return new AbstractMap.SimpleImmutableEntry<Date, String>(targetDate, dateFormat);
        }
        throw new RuntimeException("expression not valid");
    }

    public static Map.Entry<Date, String> calcCustomDay(String expression, String keyDate, Date date) {
        String dataFormat = "yyyy-MM-dd";
        Date targetDate = new Date();
        switch (keyDate) {
            case "month_first_day": {
                dataFormat = expression.substring("month_first_day".length() + 1, expression.length() - 1);
                if (dataFormat.contains(",")) {
                    String param1 = dataFormat.split(",")[0];
                    String param2 = dataFormat.split(",")[1];
                    dataFormat = param1;
                    targetDate = org.apache.dolphinscheduler.common.utils.DateUtils.addMonths((Date)org.apache.dolphinscheduler.common.utils.DateUtils.getFirstDayOfMonth((Date)date), (int)TimePlaceholderUtils.calculate(param2));
                    break;
                }
                targetDate = org.apache.dolphinscheduler.common.utils.DateUtils.getFirstDayOfMonth((Date)date);
                break;
            }
            case "month_last_day": {
                dataFormat = expression.substring("month_last_day".length() + 1, expression.length() - 1);
                if (dataFormat.contains(",")) {
                    String param1 = dataFormat.split(",")[0];
                    String param2 = dataFormat.split(",")[1];
                    dataFormat = param1;
                    Date lastMonthDay = org.apache.dolphinscheduler.common.utils.DateUtils.addMonths((Date)date, (int)TimePlaceholderUtils.calculate(param2));
                    targetDate = org.apache.dolphinscheduler.common.utils.DateUtils.getLastDayOfMonth((Date)lastMonthDay);
                    break;
                }
                targetDate = org.apache.dolphinscheduler.common.utils.DateUtils.getLastDayOfMonth((Date)date);
                break;
            }
            case "this_day": {
                dataFormat = expression.substring("this_day".length() + 1, expression.length() - 1);
                targetDate = org.apache.dolphinscheduler.common.utils.DateUtils.addDays((Date)date, (int)0);
                break;
            }
            case "last_day": {
                dataFormat = expression.substring("last_day".length() + 1, expression.length() - 1);
                targetDate = org.apache.dolphinscheduler.common.utils.DateUtils.addDays((Date)date, (int)-1);
                break;
            }
            case "week_first_day": {
                dataFormat = expression.substring("week_first_day".length() + 1, expression.length() - 1);
                if (dataFormat.contains(",")) {
                    String param1 = dataFormat.split(",")[0];
                    String param2 = dataFormat.split(",")[1];
                    dataFormat = param1;
                    targetDate = DateUtils.addWeeks((Date)org.apache.dolphinscheduler.common.utils.DateUtils.getMonday((Date)date), (int)TimePlaceholderUtils.calculate(param2));
                    break;
                }
                targetDate = DateUtils.addWeeks((Date)org.apache.dolphinscheduler.common.utils.DateUtils.getMonday((Date)date), (int)0);
                break;
            }
            case "week_last_day": {
                dataFormat = expression.substring("week_last_day".length() + 1, expression.length() - 1);
                if (dataFormat.contains(",")) {
                    String param1 = dataFormat.split(",")[0];
                    String param2 = dataFormat.split(",")[1];
                    dataFormat = param1;
                    targetDate = DateUtils.addWeeks((Date)org.apache.dolphinscheduler.common.utils.DateUtils.getSunday((Date)date), (int)TimePlaceholderUtils.calculate(param2));
                    break;
                }
                targetDate = DateUtils.addWeeks((Date)org.apache.dolphinscheduler.common.utils.DateUtils.getSunday((Date)date), (int)0);
                break;
            }
        }
        return new AbstractMap.SimpleImmutableEntry<Date, String>(targetDate, dataFormat);
    }

    public static Map.Entry<Date, String> calcWeekStart(String expression, Date date) {
        String addMonthExpr = expression.substring("week_begin".length() + 1, expression.length() - 1);
        String[] params = addMonthExpr.split(",");
        if (params.length == 2) {
            String dateFormat = params[0];
            String dayExpr = params[1];
            Integer day = TimePlaceholderUtils.calculate(dayExpr);
            Date targetDate = org.apache.dolphinscheduler.common.utils.DateUtils.getMonday((Date)date);
            targetDate = org.apache.dolphinscheduler.common.utils.DateUtils.addDays((Date)targetDate, (int)day);
            return new AbstractMap.SimpleImmutableEntry<Date, String>(targetDate, dateFormat);
        }
        throw new RuntimeException("expression not valid");
    }

    public static Map.Entry<Date, String> calcWeekEnd(String expression, Date date) {
        String addMonthExpr = expression.substring("week_end".length() + 1, expression.length() - 1);
        String[] params = addMonthExpr.split(",");
        if (params.length == 2) {
            String dateFormat = params[0];
            String dayExpr = params[1];
            Integer day = TimePlaceholderUtils.calculate(dayExpr);
            Date targetDate = org.apache.dolphinscheduler.common.utils.DateUtils.getSunday((Date)date);
            targetDate = org.apache.dolphinscheduler.common.utils.DateUtils.addDays((Date)targetDate, (int)day);
            return new AbstractMap.SimpleImmutableEntry<Date, String>(targetDate, dateFormat);
        }
        throw new RuntimeException("Expression not valid");
    }

    public static Map.Entry<Date, String> calcMonths(String expression, Date date) {
        String addMonthExpr = expression.substring("add_months".length() + 1, expression.length() - 1);
        String[] params = addMonthExpr.split(",");
        if (params.length == 2) {
            String dateFormat = params[0];
            String monthExpr = params[1];
            Integer addMonth = TimePlaceholderUtils.calculate(monthExpr);
            Date targetDate = org.apache.dolphinscheduler.common.utils.DateUtils.addMonths((Date)date, (int)addMonth);
            return new AbstractMap.SimpleImmutableEntry<Date, String>(targetDate, dateFormat);
        }
        throw new RuntimeException("expression not valid");
    }

    public static Map.Entry<Date, String> calcMinutes(String expression, Date date) {
        if (expression.contains("+")) {
            int index = expression.lastIndexOf(43);
            if (Character.isDigit(expression.charAt(index + 1))) {
                String addMinuteExpr = expression.substring(index + 1);
                Date targetDate = org.apache.dolphinscheduler.common.utils.DateUtils.addMinutes((Date)date, (int)TimePlaceholderUtils.calcMinutes(addMinuteExpr));
                String dateFormat = expression.substring(0, index);
                return new AbstractMap.SimpleImmutableEntry<Date, String>(targetDate, dateFormat);
            }
        } else if (expression.contains("-")) {
            int index = expression.lastIndexOf(45);
            if (Character.isDigit(expression.charAt(index + 1))) {
                String addMinuteExpr = expression.substring(index + 1);
                Date targetDate = org.apache.dolphinscheduler.common.utils.DateUtils.addMinutes((Date)date, (int)(0 - TimePlaceholderUtils.calcMinutes(addMinuteExpr)));
                String dateFormat = expression.substring(0, index);
                return new AbstractMap.SimpleImmutableEntry<Date, String>(targetDate, dateFormat);
            }
            return new AbstractMap.SimpleImmutableEntry<Date, String>(date, expression);
        }
        return new AbstractMap.SimpleImmutableEntry<Date, String>(date, expression);
    }

    public static Integer calcMinutes(String minuteExpression) {
        int index = minuteExpression.indexOf(47);
        String calcExpression = index == -1 ? String.format("60*24*(%s)", minuteExpression) : String.format("60*24*(%s)%s", minuteExpression.substring(0, index), minuteExpression.substring(index));
        return TimePlaceholderUtils.calculate(calcExpression);
    }

    private static class TimePlaceholderResolver
    implements PropertyPlaceholderHelper.PlaceholderResolver {
        private final String value;
        private final Date date;

        public TimePlaceholderResolver(String value, Date date) {
            this.value = value;
            this.date = date;
        }

        @Override
        public String resolvePlaceholder(String placeholderName) {
            try {
                return TimePlaceholderUtils.calculateTime(placeholderName, this.date);
            }
            catch (Exception ex) {
                log.error("resolve placeholder '{}' in [ {} ]", new Object[]{placeholderName, this.value, ex});
                return null;
            }
        }
    }
}

