/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.utils;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.batch.v1.JobList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8sUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(K8sUtils.class);
    private KubernetesClient client;

    public void createJob(String namespace, Job job) {
        try {
            ((NonNamespaceOperation)this.client.batch().v1().jobs().inNamespace(namespace)).create((Object)job);
        }
        catch (Exception e) {
            throw new TaskException("fail to create job", e);
        }
    }

    public void deleteJob(String jobName, String namespace) {
        try {
            ((ScalableResource)((NonNamespaceOperation)this.client.batch().v1().jobs().inNamespace(namespace)).withName(jobName)).delete();
        }
        catch (Exception e) {
            throw new TaskException("fail to delete job", e);
        }
    }

    public Boolean jobExist(String jobName, String namespace) {
        try {
            JobList jobList = (JobList)((NonNamespaceOperation)this.client.batch().jobs().inNamespace(namespace)).list();
            List jobs = jobList.getItems();
            Optional<Job> result = jobs.stream().filter(job -> job.getMetadata().getName().equals(jobName)).findFirst();
            return result.isPresent();
        }
        catch (Exception e) {
            throw new TaskException("fail to check job: ", e);
        }
    }

    public Watch createBatchJobWatcher(String jobName, Watcher<Job> watcher) {
        try {
            return ((ScalableResource)this.client.batch().v1().jobs().withName(jobName)).watch(watcher);
        }
        catch (Exception e) {
            throw new TaskException("fail to register batch job watcher", e);
        }
    }

    public String getPodLog(String jobName, String namespace) {
        try {
            Pod pod;
            List podList = ((PodList)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).list()).getItems();
            String podName = null;
            Iterator iterator = podList.iterator();
            while (!(!iterator.hasNext() || (podName = (pod = (Pod)iterator.next()).getMetadata().getName()).contains("-") && jobName.equals(podName.substring(0, podName.lastIndexOf("-"))))) {
            }
            return ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withName(podName)).tailingLines(500).getLog(Boolean.TRUE.booleanValue());
        }
        catch (Exception e) {
            log.error("fail to getPodLog", (Throwable)e);
            log.error("response bodies : {}", (Object)e.getMessage());
            return null;
        }
    }

    public void buildClient(String configYaml) {
        try {
            Config config = Config.fromKubeconfig((String)configYaml);
            this.client = new KubernetesClientBuilder().withConfig(config).build();
        }
        catch (Exception e) {
            throw new TaskException("fail to build k8s ApiClient", e);
        }
    }
}

