/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.utils;

import ch.qos.logback.classic.sift.SiftingAppender;
import ch.qos.logback.core.spi.AppenderAttachable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.log.TaskLogDiscriminator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class LogUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogUtils.class);
    private static Path TASK_INSTANCE_LOG_BASE_PATH = LogUtils.getTaskInstanceLogBasePath();
    public static final String TASK_INSTANCE_LOG_FULL_PATH_MDC_KEY = "taskInstanceLogFullPath";
    private static final Pattern APPLICATION_REGEX = Pattern.compile("application_\\d+_\\d+");

    public static List<String> getAppIds(String logPath, String appInfoPath, String fetchWay) {
        if (!StringUtils.isEmpty((CharSequence)fetchWay) && fetchWay.equals("aop")) {
            log.info("Start finding appId in {}, fetch way: {} ", (Object)appInfoPath, (Object)fetchWay);
            return LogUtils.getAppIdsFromAppInfoFile(appInfoPath);
        }
        log.info("Start finding appId in {}, fetch way: {} ", (Object)logPath, (Object)fetchWay);
        return LogUtils.getAppIdsFromLogFile(logPath);
    }

    public static String getTaskInstanceLogFullPath(TaskExecutionContext taskExecutionContext) {
        return LogUtils.getTaskInstanceLogFullPath(DateUtils.timeStampToDate((long)taskExecutionContext.getFirstSubmitTime()), taskExecutionContext.getProcessDefineCode(), taskExecutionContext.getProcessDefineVersion(), taskExecutionContext.getProcessInstanceId(), taskExecutionContext.getTaskInstanceId());
    }

    public static String getTaskInstanceLogFullPath(Date taskFirstSubmitTime, Long workflowDefinitionCode, int workflowDefinitionVersion, int workflowInstanceId, int taskInstanceId) {
        if (TASK_INSTANCE_LOG_BASE_PATH == null) {
            throw new IllegalArgumentException("Cannot find the task instance log base path, please check your logback.xml file");
        }
        String taskLogFileName = Paths.get(String.valueOf(workflowDefinitionCode), String.valueOf(workflowDefinitionVersion), String.valueOf(workflowInstanceId), String.format("%s.log", taskInstanceId)).toString();
        return TASK_INSTANCE_LOG_BASE_PATH.resolve(DateUtils.format((Date)taskFirstSubmitTime, (String)"yyyyMMdd", null)).resolve(taskLogFileName).toString();
    }

    public static Path getTaskInstanceLogBasePath() {
        return Optional.of(LoggerFactory.getILoggerFactory()).map(e -> (AppenderAttachable)e.getLogger("ROOT")).map(e -> (SiftingAppender)e.getAppender("TASKLOGFILE")).map(e -> (TaskLogDiscriminator)e.getDiscriminator()).map(TaskLogDiscriminator::getLogBase).map(e -> Paths.get(e, new String[0]).toAbsolutePath()).orElse(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getAppIdsFromAppInfoFile(String appInfoPath) {
        if (StringUtils.isEmpty((CharSequence)appInfoPath)) {
            log.warn("appInfoPath is empty");
            return Collections.emptyList();
        }
        File appInfoFile = new File(appInfoPath);
        if (!appInfoFile.exists()) return Collections.emptyList();
        if (!appInfoFile.isFile()) {
            return Collections.emptyList();
        }
        ArrayList appIds = new ArrayList();
        try (Stream<String> stream = Files.lines(Paths.get(appInfoPath, new String[0]));){
            stream.forEach(appIds::add);
            ArrayList<String> arrayList = new ArrayList<String>(appIds);
            return arrayList;
        }
        catch (IOException e) {
            log.error("Get appId from appInfo file error, appInfoPath: {}", (Object)appInfoPath, (Object)e);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getAppIdsFromLogFile(@NonNull String logPath) {
        if (logPath == null) {
            throw new NullPointerException("logPath is marked non-null but is null");
        }
        File logFile = new File(logPath);
        if (!logFile.exists()) return Collections.emptyList();
        if (!logFile.isFile()) {
            return Collections.emptyList();
        }
        HashSet appIds = new HashSet();
        try (Stream<String> stream = Files.lines(Paths.get(logPath, new String[0]));){
            stream.forEach(line -> {
                String appId;
                Matcher matcher = APPLICATION_REGEX.matcher((CharSequence)line);
                if (matcher.find() && appIds.add(appId = matcher.group())) {
                    log.info("Find appId: {} from {}", (Object)appId, (Object)logPath);
                }
            });
            ArrayList<String> arrayList = new ArrayList<String>(appIds);
            return arrayList;
        }
        catch (IOException e) {
            log.error("Get appId from log file error, logPath: {}", (Object)logPath, (Object)e);
            return Collections.emptyList();
        }
    }

    public static String getTaskInstanceLogFullPathMdc() {
        return MDC.get((String)TASK_INSTANCE_LOG_FULL_PATH_MDC_KEY);
    }

    public static void setTaskInstanceLogFullPathMDC(String taskInstanceLogFullPath) {
        if (taskInstanceLogFullPath == null) {
            log.warn("taskInstanceLogFullPath is null");
            return;
        }
        MDC.put((String)TASK_INSTANCE_LOG_FULL_PATH_MDC_KEY, (String)taskInstanceLogFullPath);
    }

    public static void removeTaskInstanceLogFullPathMDC() {
        MDC.remove((String)TASK_INSTANCE_LOG_FULL_PATH_MDC_KEY);
    }

    public static void setWorkflowAndTaskInstanceIDMDC(Integer workflowInstanceId, Integer taskInstanceId) {
        MDC.put((String)"workflowInstanceId", (String)String.valueOf(workflowInstanceId));
        MDC.put((String)"taskInstanceId", (String)String.valueOf(taskInstanceId));
    }

    public static void setWorkflowInstanceIdMDC(Integer workflowInstanceId) {
        MDC.put((String)"workflowInstanceId", (String)String.valueOf(workflowInstanceId));
    }

    public static void setTaskInstanceIdMDC(Integer taskInstanceId) {
        MDC.put((String)"taskInstanceId", (String)String.valueOf(taskInstanceId));
    }

    public static void removeWorkflowAndTaskInstanceIdMDC() {
        LogUtils.removeWorkflowInstanceIdMDC();
        LogUtils.removeTaskInstanceIdMDC();
    }

    public static void removeWorkflowInstanceIdMDC() {
        MDC.remove((String)"workflowInstanceId");
    }

    public static void removeTaskInstanceIdMDC() {
        MDC.remove((String)"taskInstanceId");
    }

    @Generated
    private LogUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class MDCAutoClosableContext
    implements AutoCloseable {
        private final Runnable closeAction;

        @Override
        public void close() {
            this.closeAction.run();
        }

        @Generated
        public MDCAutoClosableContext(Runnable closeAction) {
            this.closeAction = closeAction;
        }
    }
}

