/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.memory;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.DrillBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.memory.Accountor;
import org.apache.drill.exec.memory.AtomicRemainder;
import org.apache.drill.exec.memory.LimitConsumer;
import org.apache.drill.exec.util.AssertionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountorImpl
implements Accountor {
    static final Logger logger = LoggerFactory.getLogger(AccountorImpl.class);
    private static final boolean ENABLE_ACCOUNTING = AssertionUtil.isAssertionsEnabled();
    public static final String ENABLE_FRAGMENT_MEMORY_LIMIT = "drill.exec.memory.enable_frag_limit";
    public static final String FRAGMENT_MEM_OVERCOMMIT_FACTOR = "drill.exec.memory.frag_mem_overcommit_factor";
    private final AtomicRemainder remainder;
    private final long total;
    private ConcurrentMap<ByteBuf, DebugStackTrace> buffers = Maps.newConcurrentMap();
    private AccountorImpl parent;
    private final boolean errorOnLeak;
    private final boolean enableFragmentLimit;
    private final double fragmentMemOvercommitFactor;
    private final boolean DEFAULT_ENABLE_FRAGMENT_LIMIT = false;
    private final double DEFAULT_FRAGMENT_MEM_OVERCOMMIT_FACTOR = 1.5;
    private final boolean applyFragmentLimit;
    private final LimitConsumer limitConsumer;
    long fragmentLimit;
    private long peakMemoryAllocation = 0L;
    private final List<LimitConsumer> limitConsumers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountorImpl(DrillConfig config, boolean errorOnLeak, LimitConsumer context, AccountorImpl parent, long max, long preAllocated, boolean applyFragLimit) {
        double fragmentMemOvercommitFactor;
        boolean enableFragmentLimit;
        this.errorOnLeak = errorOnLeak;
        AtomicRemainder parentRemainder = parent != null ? parent.remainder : null;
        this.parent = parent;
        try {
            enableFragmentLimit = config.getBoolean(ENABLE_FRAGMENT_MEMORY_LIMIT);
            fragmentMemOvercommitFactor = config.getDouble(FRAGMENT_MEM_OVERCOMMIT_FACTOR);
        }
        catch (Exception e) {
            enableFragmentLimit = false;
            fragmentMemOvercommitFactor = 1.5;
        }
        this.enableFragmentLimit = enableFragmentLimit;
        this.fragmentMemOvercommitFactor = fragmentMemOvercommitFactor;
        this.applyFragmentLimit = applyFragLimit;
        this.remainder = new AtomicRemainder(errorOnLeak, parentRemainder, max, preAllocated, this.applyFragmentLimit);
        this.total = max;
        this.limitConsumer = context;
        this.fragmentLimit = this.total;
        this.buffers = ENABLE_ACCOUNTING ? Maps.newConcurrentMap() : null;
        this.limitConsumers = new ArrayList<LimitConsumer>();
        if (parent != null && parent.parent == null) {
            AccountorImpl accountorImpl = this;
            synchronized (accountorImpl) {
                this.addLimitConsumer(this.limitConsumer);
            }
        }
    }

    public boolean transferTo(Accountor target, DrillBuf buf, long size) {
        return this.transfer(target, buf, size, true);
    }

    public boolean transferIn(DrillBuf buf, long size) {
        return this.transfer(this, buf, size, false);
    }

    private boolean transfer(Accountor target, DrillBuf buf, long size, boolean release) {
        boolean withinLimit = target.forceAdditionalReservation(size);
        if (release) {
            this.release(buf, size);
        }
        if (ENABLE_ACCOUNTING && target instanceof AccountorImpl) {
            ((AccountorImpl)target).buffers.put((ByteBuf)buf, new DebugStackTrace(buf.capacity(), Thread.currentThread().getStackTrace()));
        }
        return withinLimit;
    }

    public long getAvailable() {
        if (this.parent != null) {
            return Math.min(this.parent.getAvailable(), this.getCapacity() - this.getAllocation());
        }
        return this.getCapacity() - this.getAllocation();
    }

    public long getCapacity() {
        return this.fragmentLimit;
    }

    public long getAllocation() {
        return this.remainder.getUsed();
    }

    public long getPeakMemoryAllocation() {
        return this.peakMemoryAllocation;
    }

    public boolean reserve(long size) {
        boolean status = this.remainder.get(size, this.applyFragmentLimit);
        this.peakMemoryAllocation = Math.max(this.peakMemoryAllocation, this.getAllocation());
        return status;
    }

    public boolean forceAdditionalReservation(long size) {
        if (size > 0L) {
            boolean status = this.remainder.forceGet(size);
            this.peakMemoryAllocation = Math.max(this.peakMemoryAllocation, this.getAllocation());
            return status;
        }
        return true;
    }

    public void reserved(long expected, DrillBuf buf) {
        long additional = (long)buf.capacity() - expected;
        if (additional > 0L) {
            this.remainder.forceGet(additional);
        }
        if (ENABLE_ACCOUNTING) {
            this.buffers.put((ByteBuf)buf, new DebugStackTrace(buf.capacity(), Thread.currentThread().getStackTrace()));
        }
        this.peakMemoryAllocation = Math.max(this.peakMemoryAllocation, this.getAllocation());
    }

    public void releasePartial(DrillBuf buf, long size) {
        this.remainder.returnAllocation(size);
        if (ENABLE_ACCOUNTING && buf != null) {
            DebugStackTrace dst = (DebugStackTrace)this.buffers.get(buf);
            if (dst == null) {
                throw new IllegalStateException("Partially releasing a buffer that has already been released. Buffer: " + buf);
            }
            dst.size -= size;
            if (dst.size < 0L) {
                throw new IllegalStateException("Partially releasing a buffer that has already been released. Buffer: " + buf);
            }
        }
    }

    void release(long size) {
        this.remainder.returnAllocation(size);
    }

    public void release(DrillBuf buf, long size) {
        this.remainder.returnAllocation(size);
        if (ENABLE_ACCOUNTING && buf != null && this.buffers.remove(buf) == null) {
            throw new IllegalStateException("Releasing a buffer that has already been released. Buffer: " + buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLimitConsumer(LimitConsumer c) {
        if (c == null) {
            return;
        }
        if (this.parent != null) {
            this.parent.addLimitConsumer(c);
        } else {
            if (logger.isTraceEnabled()) {
                String fragStr = c == null ? "[Null Context]" : c.getIdentifier();
                fragStr = fragStr + " (Object Id: " + System.identityHashCode(c) + ")";
                StackTraceElement[] ste = new Throwable().getStackTrace();
                StringBuffer sb = new StringBuffer();
                for (StackTraceElement s : ste) {
                    sb.append(s.toString());
                    sb.append("\n");
                }
                logger.trace("Fragment " + fragStr + " added to root accountor.\n" + sb.toString());
            }
            AccountorImpl accountorImpl = this;
            synchronized (accountorImpl) {
                this.limitConsumers.add(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLimitConsumer(LimitConsumer c) {
        if (c == null) {
            return;
        }
        if (this.parent != null) {
            if (this.parent.parent == null) {
                this.parent.removeLimitConsumer(c);
            }
        } else {
            if (logger.isDebugEnabled()) {
                String fragStr = c == null ? "[Null Context]" : c.getIdentifier();
                fragStr = fragStr + " (Object Id: " + System.identityHashCode(c) + ")";
                logger.trace("Fragment " + fragStr + " removed from root accountor");
            }
            AccountorImpl accountorImpl = this;
            synchronized (accountorImpl) {
                this.limitConsumers.remove(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long resetFragmentLimits() {
        if (!this.enableFragmentLimit) {
            return this.getCapacity();
        }
        if (this.parent != null) {
            this.parent.resetFragmentLimits();
        } else {
            AccountorImpl accountorImpl = this;
            synchronized (accountorImpl) {
                int nFragments = this.limitConsumers.size();
                long allocatedMemory = 0L;
                for (LimitConsumer fragment : this.limitConsumers) {
                    allocatedMemory += fragment.getAllocated();
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Resetting Fragment Memory Limit: total Available memory== " + this.total + " Total Allocated Memory :" + allocatedMemory + " Number of fragments: " + nFragments + " fragmentMemOvercommitFactor: " + this.fragmentMemOvercommitFactor + " Root fragment limit: " + this.fragmentLimit + "(Root obj: " + System.identityHashCode(this) + ")");
                }
                if (nFragments > 0) {
                    long rem = (this.total - allocatedMemory) / (long)nFragments;
                    for (LimitConsumer fragment : this.limitConsumers) {
                        fragment.setLimit((long)((double)rem * this.fragmentMemOvercommitFactor));
                    }
                }
                if (logger.isTraceEnabled()) {
                    // empty if block
                }
            }
        }
        return this.getCapacity();
    }

    public void close() {
        if (this.parent != null && this.parent.parent == null && this.limitConsumer != null) {
            logger.debug("Fragment " + this.limitConsumer.getIdentifier() + "  accountor being closed");
            this.removeLimitConsumer(this.limitConsumer);
        }
        this.resetFragmentLimits();
        if (ENABLE_ACCOUNTING && !this.buffers.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            sb.append("Attempted to close accountor with ");
            sb.append(this.buffers.size());
            sb.append(" buffer(s) still allocated for ");
            sb.append(this.limitConsumer.getIdentifier());
            sb.append(".\n");
            LinkedListMultimap multi = LinkedListMultimap.create();
            for (DebugStackTrace t : this.buffers.values()) {
                multi.put((Object)t, (Object)t);
            }
            for (DebugStackTrace entry : multi.keySet()) {
                Collection allocs = multi.get((Object)entry);
                sb.append("\n\n\tTotal ");
                sb.append(allocs.size());
                sb.append(" allocation(s) of byte size(s): ");
                for (DebugStackTrace alloc : allocs) {
                    sb.append(alloc.size);
                    sb.append(", ");
                }
                sb.append("at stack location:\n");
                entry.addToString(sb);
            }
            if (!this.buffers.isEmpty()) {
                IllegalStateException e = new IllegalStateException(sb.toString());
                if (this.errorOnLeak) {
                    throw e;
                }
                logger.warn("Memory leaked.", (Throwable)e);
            }
        }
        this.remainder.close();
    }

    public void setFragmentLimit(long add) {
        if (this.parent != null && this.parent.parent == null) {
            this.fragmentLimit = this.getAllocation() + add;
            this.remainder.setLimit(this.fragmentLimit);
            logger.trace("Fragment " + this.limitConsumer.getIdentifier() + " memory limit set to " + this.fragmentLimit);
        }
    }

    public long getFragmentLimit() {
        return this.fragmentLimit;
    }

    public class DebugStackTrace {
        private StackTraceElement[] elements;
        private long size;

        public DebugStackTrace(long size, StackTraceElement[] elements) {
            this.elements = elements;
            this.size = size;
        }

        public void addToString(StringBuffer sb) {
            for (int i = 3; i < this.elements.length; ++i) {
                sb.append("\t\t");
                sb.append(this.elements[i]);
                sb.append("\n");
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.elements);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DebugStackTrace other = (DebugStackTrace)obj;
            return Arrays.equals(this.elements, other.elements);
        }
    }
}

