/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.memory;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.DrillBuf;
import io.netty.buffer.PooledByteBufAllocatorL;
import io.netty.buffer.UnsafeDirectLittleEndian;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.memory.Accountor;
import org.apache.drill.exec.memory.AccountorImpl;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.LimitConsumer;
import org.apache.drill.exec.metrics.DrillMetrics;
import org.apache.drill.exec.util.AssertionUtil;
import org.apache.drill.exec.util.Pointer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopLevelAllocator
implements BufferAllocator {
    private static final Logger logger = LoggerFactory.getLogger(TopLevelAllocator.class);
    public static final String CHILD_BUFFER_INJECTION_SITE = "child.buffer";
    private static final PooledByteBufAllocatorL ALLOCATOR = new PooledByteBufAllocatorL(DrillMetrics.getInstance());
    public static final String TOP_LEVEL_MAX_ALLOC = "drill.memory.top.max";
    public static final String ERROR_ON_MEMORY_LEAK = "drill.memory.debug.error_on_leak";
    public static long MAXIMUM_DIRECT_MEMORY;
    private static final boolean ENABLE_ACCOUNTING;
    private final Map<ChildAllocator, StackTraceElement[]> childrenMap;
    private final PooledByteBufAllocatorL innerAllocator;
    private final AccountorImpl acct;
    private final boolean errorOnLeak;
    private final DrillBuf empty;
    private final DrillConfig config;

    private TopLevelAllocator(DrillConfig config, long maximumAllocation, boolean errorOnLeak) {
        MAXIMUM_DIRECT_MEMORY = maximumAllocation;
        this.innerAllocator = ALLOCATOR;
        this.config = config != null ? config : DrillConfig.create();
        this.errorOnLeak = errorOnLeak;
        this.acct = new AccountorImpl(config, errorOnLeak, null, null, maximumAllocation, 0L, true);
        this.empty = DrillBuf.getEmpty((BufferAllocator)this, (Accountor)this.acct);
        this.childrenMap = ENABLE_ACCOUNTING ? new IdentityHashMap() : null;
    }

    TopLevelAllocator(DrillConfig config) {
        this(config, Math.min(DrillConfig.getMaxDirectMemory(), config.getLong(TOP_LEVEL_MAX_ALLOC)), config.getBoolean(ERROR_ON_MEMORY_LEAK));
    }

    public boolean takeOwnership(DrillBuf buf) {
        return buf.transferAccounting((Accountor)this.acct);
    }

    public boolean takeOwnership(DrillBuf buf, Pointer<DrillBuf> out) {
        DrillBuf b = new DrillBuf((BufferAllocator)this, (Accountor)this.acct, buf);
        out.value = b;
        return this.acct.transferIn(b, b.capacity());
    }

    public DrillBuf buffer(int min, int max) {
        if (min == 0) {
            return this.empty;
        }
        if (!this.acct.reserve(min)) {
            throw new OutOfMemoryException(TopLevelAllocator.createErrorMsg(this, min));
        }
        try {
            UnsafeDirectLittleEndian buffer = this.innerAllocator.directBuffer(min, max);
            DrillBuf wrapped = new DrillBuf((BufferAllocator)this, (Accountor)this.acct, buffer);
            this.acct.reserved(min, wrapped);
            return wrapped;
        }
        catch (OutOfMemoryError e) {
            if ("Direct buffer memory".equals(e.getMessage())) {
                this.acct.release(min);
                throw new OutOfMemoryException(TopLevelAllocator.createErrorMsg(this, min), (Throwable)e);
            }
            throw e;
        }
    }

    public DrillBuf buffer(int size) {
        return this.buffer(size, size);
    }

    public long getAllocatedMemory() {
        return this.acct.getAllocation();
    }

    public long getPeakMemoryAllocation() {
        return this.acct.getPeakMemoryAllocation();
    }

    public ByteBufAllocator getUnderlyingAllocator() {
        return this.innerAllocator;
    }

    public BufferAllocator getChildAllocator(LimitConsumer limitConsumer, long initialReservation, long maximumReservation, boolean applyFragmentLimit) {
        if (!this.acct.reserve(initialReservation)) {
            logger.debug(String.format("You attempted to create a new child allocator with initial reservation %d but only %d bytes of memory were available.", initialReservation, this.acct.getCapacity() - this.acct.getAllocation()));
            throw new OutOfMemoryException(String.format("You attempted to create a new child allocator with initial reservation %d but only %d bytes of memory were available.", initialReservation, this.acct.getCapacity() - this.acct.getAllocation()));
        }
        logger.debug("New child allocator with initial reservation {}", (Object)initialReservation);
        ChildAllocator allocator = new ChildAllocator(limitConsumer, this.acct, maximumReservation, initialReservation, this.childrenMap, applyFragmentLimit);
        if (ENABLE_ACCOUNTING) {
            this.childrenMap.put(allocator, Thread.currentThread().getStackTrace());
        }
        return allocator;
    }

    public void resetLimits() {
        this.acct.resetFragmentLimits();
    }

    public void setLimit(long limit) {
        this.acct.setFragmentLimit(limit);
    }

    public long getLimit() {
        return this.acct.getFragmentLimit();
    }

    public void close() {
        if (ENABLE_ACCOUNTING) {
            for (Map.Entry<ChildAllocator, StackTraceElement[]> child : this.childrenMap.entrySet()) {
                if (child.getKey().isClosed()) continue;
                StringBuilder sb = new StringBuilder();
                StackTraceElement[] elements = child.getValue();
                for (int i = 0; i < elements.length; ++i) {
                    sb.append("\t\t");
                    sb.append(elements[i]);
                    sb.append("\n");
                }
                throw new IllegalStateException("Failure while trying to close allocator: Child level allocators not closed. Stack trace: \n" + sb);
            }
        }
        this.acct.close();
    }

    public DrillBuf getEmpty() {
        return this.empty;
    }

    public BufferAllocator.PreAllocator getNewPreAllocator() {
        return new PreAlloc(this, this.acct);
    }

    private static String createErrorMsg(BufferAllocator allocator, int size) {
        return String.format("Unable to allocate buffer of size %d due to memory limit. Current allocation: %d", size, allocator.getAllocatedMemory());
    }

    static {
        ENABLE_ACCOUNTING = AssertionUtil.isAssertionsEnabled();
    }

    public class PreAlloc
    implements BufferAllocator.PreAllocator {
        int bytes = 0;
        final Accountor acct;
        final BufferAllocator allocator;

        private PreAlloc(BufferAllocator allocator, Accountor acct) {
            this.acct = acct;
            this.allocator = allocator;
        }

        public boolean preAllocate(int bytes) {
            if (!this.acct.reserve((long)bytes)) {
                return false;
            }
            this.bytes += bytes;
            return true;
        }

        public DrillBuf getAllocation() {
            DrillBuf b = new DrillBuf(this.allocator, this.acct, TopLevelAllocator.this.innerAllocator.directBuffer(this.bytes, this.bytes));
            this.acct.reserved((long)this.bytes, b);
            return b;
        }
    }

    private class ChildAllocator
    implements BufferAllocator {
        private final DrillBuf empty;
        private AccountorImpl childAcct;
        private Map<ChildAllocator, StackTraceElement[]> children = new HashMap<ChildAllocator, StackTraceElement[]>();
        private boolean closed = false;
        private LimitConsumer limitConsumer;
        private Map<ChildAllocator, StackTraceElement[]> thisMap;
        private boolean applyFragmentLimit;

        public ChildAllocator(LimitConsumer limitConsumer, AccountorImpl parentAccountor, long max, long pre, Map<ChildAllocator, StackTraceElement[]> map, boolean applyFragmentLimit) {
            assert (max >= pre);
            this.applyFragmentLimit = applyFragmentLimit;
            this.limitConsumer = limitConsumer;
            this.childAcct = new AccountorImpl(TopLevelAllocator.this.config, TopLevelAllocator.this.errorOnLeak, limitConsumer, parentAccountor, max, pre, applyFragmentLimit);
            this.thisMap = map;
            this.empty = DrillBuf.getEmpty((BufferAllocator)this, (Accountor)this.childAcct);
        }

        public boolean takeOwnership(DrillBuf buf) {
            return buf.transferAccounting((Accountor)this.childAcct);
        }

        public boolean takeOwnership(DrillBuf buf, Pointer<DrillBuf> out) {
            DrillBuf b = new DrillBuf((BufferAllocator)this, (Accountor)TopLevelAllocator.this.acct, buf);
            out.value = b;
            return TopLevelAllocator.this.acct.transferIn(b, b.capacity());
        }

        public DrillBuf buffer(int size, int max) {
            if (size == 0) {
                return this.empty;
            }
            if (!this.childAcct.reserve(size)) {
                throw new OutOfMemoryException(TopLevelAllocator.createErrorMsg(this, size));
            }
            try {
                UnsafeDirectLittleEndian buffer = TopLevelAllocator.this.innerAllocator.directBuffer(size, max);
                DrillBuf wrapped = new DrillBuf((BufferAllocator)this, (Accountor)this.childAcct, buffer);
                this.childAcct.reserved(buffer.capacity(), wrapped);
                return wrapped;
            }
            catch (OutOfMemoryError e) {
                if ("Direct buffer memory".equals(e.getMessage())) {
                    this.childAcct.release(size);
                    throw new OutOfMemoryException(TopLevelAllocator.createErrorMsg(this, size), (Throwable)e);
                }
                throw e;
            }
        }

        public DrillBuf buffer(int size) {
            return this.buffer(size, size);
        }

        public ByteBufAllocator getUnderlyingAllocator() {
            return TopLevelAllocator.this.innerAllocator;
        }

        public BufferAllocator getChildAllocator(LimitConsumer limitConsumer, long initialReservation, long maximumReservation, boolean applyFragmentLimit) {
            if (!this.childAcct.reserve(initialReservation)) {
                throw new OutOfMemoryException(String.format("You attempted to create a new child allocator with initial reservation %d but only %d bytes of memory were available.", initialReservation, this.childAcct.getAvailable()));
            }
            logger.debug("New child allocator with initial reservation {}", (Object)initialReservation);
            ChildAllocator newChildAllocator = new ChildAllocator(limitConsumer, this.childAcct, maximumReservation, initialReservation, null, applyFragmentLimit);
            this.children.put(newChildAllocator, Thread.currentThread().getStackTrace());
            return newChildAllocator;
        }

        public BufferAllocator.PreAllocator getNewPreAllocator() {
            return new PreAlloc(this, this.childAcct);
        }

        public void resetLimits() {
            this.childAcct.resetFragmentLimits();
        }

        public void setLimit(long limit) {
            this.childAcct.setFragmentLimit(limit);
        }

        public long getLimit() {
            return this.childAcct.getFragmentLimit();
        }

        public void close() {
            if (ENABLE_ACCOUNTING) {
                if (this.thisMap != null) {
                    this.thisMap.remove(this);
                }
                for (ChildAllocator child : this.children.keySet()) {
                    if (child.isClosed()) continue;
                    StringBuilder sb = new StringBuilder();
                    StackTraceElement[] elements = this.children.get(child);
                    for (int i = 1; i < elements.length; ++i) {
                        sb.append("\t\t");
                        sb.append(elements[i]);
                        sb.append("\n");
                    }
                    IllegalStateException e = new IllegalStateException(String.format("Failure while trying to close child allocator: Child level allocators not closed. Identifier: %s. Stack trace: \n %s", this.limitConsumer.getIdentifier(), sb.toString()));
                    if (TopLevelAllocator.this.errorOnLeak) {
                        throw e;
                    }
                    logger.warn("Memory leak.", (Throwable)e);
                }
            }
            this.childAcct.close();
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public long getAllocatedMemory() {
            return this.childAcct.getAllocation();
        }

        public long getPeakMemoryAllocation() {
            return this.childAcct.getPeakMemoryAllocation();
        }

        public DrillBuf getEmpty() {
            return this.empty;
        }
    }
}

