/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.pac4j;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.security.pac4j.Pac4jSessionStore;
import org.apache.druid.server.security.AuthenticationResult;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.CallbackLogic;
import org.pac4j.core.engine.DefaultCallbackLogic;
import org.pac4j.core.engine.DefaultSecurityLogic;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.profile.CommonProfile;

public class Pac4jFilter
implements Filter {
    private static final Logger LOGGER = new Logger(Pac4jFilter.class);
    private static final HttpActionAdapter<String, J2EContext> NOOP_HTTP_ACTION_ADAPTER = (code, ctx) -> null;
    private final Config pac4jConfig;
    private final SecurityLogic<String, J2EContext> securityLogic;
    private final CallbackLogic<String, J2EContext> callbackLogic;
    private final SessionStore<J2EContext> sessionStore;
    private final String name;
    private final String authorizerName;

    public Pac4jFilter(String name, String authorizerName, Config pac4jConfig, String cookiePassphrase) {
        this.pac4jConfig = pac4jConfig;
        this.securityLogic = new DefaultSecurityLogic();
        this.callbackLogic = new DefaultCallbackLogic();
        this.name = name;
        this.authorizerName = authorizerName;
        this.sessionStore = new Pac4jSessionStore<J2EContext>(cookiePassphrase);
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest.getAttribute("Druid-Authentication-Result") != null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        J2EContext context = new J2EContext(httpServletRequest, httpServletResponse, this.sessionStore);
        if ("/druid-ext/druid-pac4j/callback".equals(httpServletRequest.getRequestURI())) {
            this.callbackLogic.perform((WebContext)context, this.pac4jConfig, NOOP_HTTP_ACTION_ADAPTER, "/", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null);
        } else {
            String uid = (String)this.securityLogic.perform((WebContext)context, this.pac4jConfig, (ctx, profiles, parameters) -> {
                if (profiles.isEmpty()) {
                    LOGGER.warn("No profiles found after OIDC auth.", new Object[0]);
                    return null;
                }
                return ((CommonProfile)profiles.iterator().next()).getId();
            }, NOOP_HTTP_ACTION_ADAPTER, null, null, null, null, new Object[0]);
            if (uid != null) {
                AuthenticationResult authenticationResult = new AuthenticationResult(uid, this.authorizerName, this.name, null);
                servletRequest.setAttribute("Druid-Authentication-Result", (Object)authenticationResult);
                filterChain.doFilter(servletRequest, servletResponse);
            }
        }
    }

    public void destroy() {
    }
}

