/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.pac4j;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.primitives.Ints;
import com.google.inject.Provider;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import java.util.EnumSet;
import java.util.Map;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.apache.druid.security.pac4j.CustomSSLResourceRetriever;
import org.apache.druid.security.pac4j.OIDCConfig;
import org.apache.druid.security.pac4j.Pac4jCommonConfig;
import org.apache.druid.security.pac4j.Pac4jFilter;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Authenticator;
import org.pac4j.core.client.Client;
import org.pac4j.core.config.Config;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.callback.NoParameterCallbackUrlResolver;
import org.pac4j.core.http.url.DefaultUrlResolver;
import org.pac4j.core.http.url.UrlResolver;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.OidcConfiguration;

@JsonTypeName(value="pac4j")
public class Pac4jAuthenticator
implements Authenticator {
    private final String name;
    private final String authorizerName;
    private final Supplier<Config> pac4jConfigSupplier;
    private final Pac4jCommonConfig pac4jCommonConfig;
    private final SSLSocketFactory sslSocketFactory;

    @JsonCreator
    public Pac4jAuthenticator(@JsonProperty(value="name") String name, @JsonProperty(value="authorizerName") String authorizerName, @JacksonInject Pac4jCommonConfig pac4jCommonConfig, @JacksonInject OIDCConfig oidcConfig, @JacksonInject Provider<SSLContext> sslContextSupplier) {
        this.name = name;
        this.authorizerName = authorizerName;
        this.pac4jCommonConfig = pac4jCommonConfig;
        this.sslSocketFactory = pac4jCommonConfig.isEnableCustomSslContext() ? ((SSLContext)sslContextSupplier.get()).getSocketFactory() : null;
        this.pac4jConfigSupplier = Suppliers.memoize(() -> this.createPac4jConfig(oidcConfig));
    }

    public Filter getFilter() {
        return new Pac4jFilter(this.name, this.authorizerName, (Config)this.pac4jConfigSupplier.get(), this.pac4jCommonConfig.getCookiePassphrase().getPassword());
    }

    public String getAuthChallengeHeader() {
        return null;
    }

    @Nullable
    public AuthenticationResult authenticateJDBCContext(Map<String, Object> context) {
        return null;
    }

    public Class<? extends Filter> getFilterClass() {
        return null;
    }

    public Map<String, String> getInitParameters() {
        return null;
    }

    public String getPath() {
        return "/*";
    }

    public EnumSet<DispatcherType> getDispatcherType() {
        return null;
    }

    private Config createPac4jConfig(OIDCConfig oidcConfig) {
        OidcConfiguration oidcConf = new OidcConfiguration();
        oidcConf.setClientId(oidcConfig.getClientID());
        oidcConf.setSecret(oidcConfig.getClientSecret().getPassword());
        oidcConf.setDiscoveryURI(oidcConfig.getDiscoveryURI());
        oidcConf.setExpireSessionWithToken(true);
        oidcConf.setUseNonce(true);
        oidcConf.setReadTimeout(Ints.checkedCast((long)this.pac4jCommonConfig.getReadTimeout().getMillis()));
        oidcConf.setResourceRetriever((ResourceRetriever)new CustomSSLResourceRetriever(this.pac4jCommonConfig.getReadTimeout().getMillis(), this.sslSocketFactory));
        OidcClient oidcClient = new OidcClient(oidcConf);
        oidcClient.setUrlResolver((UrlResolver)new DefaultUrlResolver(true));
        oidcClient.setCallbackUrlResolver((CallbackUrlResolver)new NoParameterCallbackUrlResolver());
        if (this.sslSocketFactory != null) {
            HTTPRequest.setDefaultSSLSocketFactory((SSLSocketFactory)this.sslSocketFactory);
        }
        return new Config("/druid-ext/druid-pac4j/callback", (Client)oidcClient);
    }
}

