/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging;

import flex.management.ManageableComponent;
import flex.management.runtime.messaging.MessageBrokerControl;
import flex.management.runtime.messaging.log.LogManager;
import flex.messaging.Destination;
import flex.messaging.FlexContext;
import flex.messaging.FlexFactory;
import flex.messaging.FlexRemoteCredentials;
import flex.messaging.FlexSession;
import flex.messaging.FlexSessionManager;
import flex.messaging.HttpFlexSession;
import flex.messaging.MessageClient;
import flex.messaging.MessageException;
import flex.messaging.Server;
import flex.messaging.ServiceValidationListener;
import flex.messaging.client.FlexClient;
import flex.messaging.client.FlexClientManager;
import flex.messaging.cluster.ClusterManager;
import flex.messaging.config.ChannelSettings;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationException;
import flex.messaging.config.FlexClientSettings;
import flex.messaging.config.SecurityConstraint;
import flex.messaging.config.SecuritySettings;
import flex.messaging.config.SystemSettings;
import flex.messaging.endpoints.AbstractEndpoint;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.endpoints.Endpoint2;
import flex.messaging.factories.JavaFactory;
import flex.messaging.io.BeanProxy;
import flex.messaging.io.PropertyProxyRegistry;
import flex.messaging.log.Log;
import flex.messaging.messages.AbstractMessage;
import flex.messaging.messages.AcknowledgeMessage;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import flex.messaging.security.LoginManager;
import flex.messaging.security.SecurityException;
import flex.messaging.services.AbstractService;
import flex.messaging.services.Service;
import flex.messaging.services.ServiceException;
import flex.messaging.services.messaging.ThrottleManager;
import flex.messaging.util.Base64;
import flex.messaging.util.ClassUtil;
import flex.messaging.util.ExceptionUtil;
import flex.messaging.util.RedeployManager;
import flex.messaging.util.StringUtils;
import flex.messaging.util.UUIDGenerator;
import flex.messaging.util.UUIDUtils;
import flex.messaging.validators.DeserializationValidator;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;

public class MessageBroker
extends ManageableComponent {
    public static final String AUTHENTICATION_SERVICE_ID = "authentication-service";
    public static final int ERR_MSG_NO_SERVICE_FOR_DEST = 10004;
    public static final int ERR_MSG_DESTINATION_UNACCESSIBLE = 10005;
    public static final int ERR_MSG_UNKNOWN_REMOTE_CREDENTIALS_FORMAT = 10020;
    public static final int ERR_MSG_NULL_MESSAGE_ID = 10029;
    public static final int ERR_MSG_CANNOT_SERVICE_STOPPED = 10038;
    public static final int ERR_MSG_NULL_ENDPOINT_URL = 10128;
    public static final int ERR_MSG_SERVICE_CMD_NOT_SUPPORTED = 10451;
    public static final int ERR_MSG_URI_ALREADY_REGISTERED = 11109;
    public static final String LOG_CATEGORY = "Message.General";
    public static final String LOG_CATEGORY_STARTUP_SERVICE = "Startup.Service";
    public static final String TYPE = "MessageBroker";
    public static final String DEFAULT_BROKER_ID = "__default__";
    static final Map<String, MessageBroker> messageBrokers = new HashMap<String, MessageBroker>();
    private static final String LOG_MANAGER_ID = "log";
    private static final Integer INTEGER_ONE = 1;
    private static final String MESSAGEBROKER = "MessageBroker";
    private static final String ENDPOINT = "Endpoint";
    private static final String SERVICE = "Service";
    private Map<String, Object> attributes;
    private final Map<String, Integer> attributeIdRefCounts = new HashMap<String, Integer>();
    private Map<String, ChannelSettings> channelSettings;
    private ClassLoader classLoader;
    private ClusterManager clusterManager;
    private MessageBrokerControl controller;
    private List<String> defaultChannels;
    private DeserializationValidator deserializationValidator;
    private Map<String, String> destinationToService;
    private Map<String, Endpoint> endpoints;
    private boolean enforceEndpointValidation;
    private Map<String, FlexFactory> factories;
    private FlexClientManager flexClientManager;
    private FlexClientSettings flexClientSettings;
    private FlexSessionManager flexSessionManager;
    private PathResolver externalPathResolver;
    private InternalPathResolver internalPathResolver;
    private Log log;
    private LogManager logManager;
    private LoginManager loginManager;
    private RedeployManager redeployManager;
    private Map<String, String> registeredEndpoints;
    private SecuritySettings securitySettings;
    private Map<String, Service> services;
    private Map<String, Server> servers;
    private final ConcurrentHashMap<String, ServiceValidationListener> serviceValidationListeners = new ConcurrentHashMap();
    private ServletContext servletContext;
    private SystemSettings systemSettings;
    private Class<? extends ThrottleManager> throttleManagerClass = ThrottleManager.class;
    private UUIDGenerator uuidGenerator;

    public MessageBroker() {
        this(true, null);
    }

    public MessageBroker(boolean enableManagement) {
        this(enableManagement, null);
    }

    public MessageBroker(boolean enableManagement, String mbid) {
        this(enableManagement, mbid, MessageBroker.class.getClassLoader());
    }

    public MessageBroker(boolean enableManagement, String mbid, ClassLoader loader) {
        super(enableManagement);
        this.classLoader = loader;
        this.attributes = new ConcurrentHashMap<String, Object>();
        this.destinationToService = new ConcurrentHashMap<String, String>();
        this.endpoints = new LinkedHashMap<String, Endpoint>();
        this.services = new LinkedHashMap<String, Service>();
        this.servers = new LinkedHashMap<String, Server>();
        this.factories = new HashMap<String, FlexFactory>();
        this.registeredEndpoints = new HashMap<String, String>();
        this.addFactory("java", new JavaFactory());
        this.setId(mbid);
        this.log = Log.createLog();
        this.clusterManager = new ClusterManager(this);
        this.systemSettings = new SystemSettings();
        if (this.isManaged()) {
            this.controller = new MessageBrokerControl(this);
            this.controller.register();
            this.setControl(this.controller);
            this.logManager = new LogManager();
            this.logManager.setLog(this.log);
            this.logManager.setParent(this);
            this.logManager.setupLogControl();
            this.logManager.initialize(LOG_MANAGER_ID, null);
        }
    }

    @Override
    public void setId(String id) {
        if (id == null) {
            id = DEFAULT_BROKER_ID;
        }
        super.setId(id);
    }

    public static MessageBroker getMessageBroker(String id) {
        if (id == null) {
            MessageBroker broker = FlexContext.getMessageBroker();
            if (broker != null) {
                return broker;
            }
            id = DEFAULT_BROKER_ID;
        }
        return messageBrokers.get(id);
    }

    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        if (Log.isDebug()) {
            StringBuffer sb = new StringBuffer(100);
            if (this.classLoader == MessageBroker.class.getClassLoader()) {
                sb.append(" the MessageBroker's class loader");
            }
            if (this.classLoader == Thread.currentThread().getContextClassLoader()) {
                if (sb.length() > 0) {
                    sb.append(" and");
                }
                sb.append(" the context class loader");
            }
            if (sb.length() == 0) {
                sb.append(" not the context or the message broker's class loader");
            }
            Log.getLogger((String)"Configuration").debug("MessageBroker id: " + this.getId() + " classLoader is:" + sb.toString() + " (" + "classLoader " + ClassUtil.classLoaderToString(this.classLoader));
        }
        try {
            this.setStarted(true);
            this.registerMessageBroker();
            if (this.flexClientManager == null) {
                this.flexClientManager = new FlexClientManager(this.isManaged(), this);
            }
            this.flexClientManager.start();
            this.flexSessionManager = new FlexSessionManager(this.isManaged(), this);
            this.flexSessionManager.start();
            if (this.systemSettings == null) {
                this.systemSettings = new SystemSettings();
            }
            this.startServices();
            this.loginManager.start();
            this.startEndpoints();
            this.startServers();
            this.redeployManager.start();
        }
        catch (Exception e) {
            if (Log.isError()) {
                Log.getLogger((String)"Configuration").error("MessageBroker failed to start: " + ExceptionUtil.exceptionFollowedByRootCausesToString((Throwable)e));
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        if (Log.isDebug()) {
            Log.getLogger((String)"Configuration").debug("MessageBroker stopping: " + this.getId());
        }
        this.serviceValidationListeners.clear();
        this.flexSessionManager.stop();
        this.flexClientManager.stop();
        this.stopServers();
        this.stopEndpoints();
        FlexContext.setThreadLocalMessageBroker(this);
        this.stopServices();
        FlexContext.setThreadLocalMessageBroker(null);
        if (this.loginManager != null) {
            this.loginManager.stop();
        }
        try {
            if (this.redeployManager != null) {
                this.redeployManager.stop();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.clusterManager.destroyClusters();
        super.stop();
        this.unRegisterMessageBroker();
        BeanProxy.clear();
        PropertyProxyRegistry.release();
        this.systemSettings.clear();
        this.systemSettings = null;
        if (Log.isDebug()) {
            Log.getLogger((String)"Configuration").debug("MessageBroker stopped: " + this.getId());
        }
    }

    public Iterator<String> getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.removeAttribute(name);
        } else {
            this.attributes.put(name, value);
        }
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public DeserializationValidator getDeserializationValidator() {
        return this.deserializationValidator;
    }

    public void setDeserializationValidator(DeserializationValidator deserializationValidator) {
        this.deserializationValidator = deserializationValidator;
    }

    public void setExternalPathResolver(PathResolver externalPathResolver) {
        this.externalPathResolver = externalPathResolver;
    }

    public void setInternalPathResolver(InternalPathResolver internalPathResolver) {
        this.internalPathResolver = internalPathResolver;
    }

    public InputStream resolveExternalPath(String filename) throws IOException {
        return this.externalPathResolver.resolve(filename);
    }

    public InputStream resolveInternalPath(String filename) throws IOException {
        return this.internalPathResolver.resolve(filename);
    }

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public void addServer(Server server) {
        if (server == null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11110, new Object[]{"Server", "MessageBroker"});
            throw ex;
        }
        String id = server.getId();
        if (id == null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11111, new Object[]{"Server", "MessageBroker"});
            throw ex;
        }
        Server currentServer = this.getServer(id);
        if (currentServer == server) {
            return;
        }
        if (currentServer != null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11112, new Object[]{"Server", id, "MessageBroker"});
            throw ex;
        }
        this.servers.put(id, server);
    }

    public Server getServer(String id) {
        return this.servers.get(id);
    }

    public Server removeServer(String id) {
        Server server = this.servers.get(id);
        if (server != null) {
            server.stop();
            this.servers.remove(id);
        }
        return server;
    }

    public Endpoint createEndpoint(String id, String url, String className) {
        Class endpointClass = ClassUtil.createClass(className, this.getClassLoader());
        Endpoint endpoint = (Endpoint)ClassUtil.createDefaultInstance(endpointClass, Endpoint.class);
        endpoint.setId(id);
        endpoint.setUrl(url);
        endpoint.setManaged(this.isManaged());
        endpoint.setMessageBroker(this);
        return endpoint;
    }

    public void addEndpoint(Endpoint endpoint) {
        if (endpoint == null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11110, new Object[]{ENDPOINT, "MessageBroker"});
            throw ex;
        }
        String id = endpoint.getId();
        if (id == null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11111, new Object[]{ENDPOINT, "MessageBroker"});
            throw ex;
        }
        if (this.getEndpoint(id) == endpoint) {
            return;
        }
        if (this.getEndpoint(id) != null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11112, new Object[]{ENDPOINT, id, "MessageBroker"});
            throw ex;
        }
        this.checkEndpointUrl(id, endpoint.getUrl());
        this.endpoints.put(id, endpoint);
    }

    public Endpoint getEndpoint(String id) {
        return this.endpoints.get(id);
    }

    public Map<String, Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public Endpoint getEndpoint(String path, String contextPath) {
        for (String id : this.endpoints.keySet()) {
            Endpoint e = this.endpoints.get(id);
            if (!this.matchEndpoint(path, contextPath, e)) continue;
            return e;
        }
        MessageException lme = new MessageException();
        lme.setMessage(10003, new Object[]{path});
        throw lme;
    }

    public Endpoint removeEndpoint(String id) {
        Endpoint endpoint = this.getEndpoint(id);
        if (endpoint != null) {
            endpoint.stop();
            this.endpoints.remove(id);
        }
        return endpoint;
    }

    public boolean isEnforceEndpointValidation() {
        return this.enforceEndpointValidation;
    }

    public void setEnforceEndpointValidation(boolean enforceEndpointValidation) {
        this.enforceEndpointValidation = enforceEndpointValidation;
    }

    public FlexFactory getFactory(String id) {
        return this.factories.get(id);
    }

    public Map<String, FlexFactory> getFactories() {
        return this.factories;
    }

    public void addFactory(String id, FlexFactory factory) {
        if (id == null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11111, new Object[]{"FlexFactory", "MessageBroker"});
            throw ex;
        }
        if (this.getFactory(id) == factory) {
            return;
        }
        if (this.getFactory(id) != null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11112, new Object[]{"FlexFactory", id, "MessageBroker"});
            throw ex;
        }
        this.factories.put(id, factory);
    }

    public FlexFactory removeFactory(String id) {
        FlexFactory factory = this.getFactory(id);
        if (factory != null) {
            this.factories.remove(id);
        }
        return factory;
    }

    public Service getService(String id) {
        return this.services.get(id);
    }

    public Service getServiceByType(String type) {
        for (Service svc : this.services.values()) {
            if (!svc.getClass().getName().equals(type)) continue;
            return svc;
        }
        return null;
    }

    public Map<String, Service> getServices() {
        return this.services;
    }

    public ConfigMap describeServices(Endpoint endpoint) {
        return this.describeServices(endpoint, true);
    }

    public ConfigMap describeServices(Endpoint endpoint, boolean onlyReliable) {
        if (!this.serviceValidationListeners.isEmpty()) {
            Enumeration<ServiceValidationListener> iter = this.serviceValidationListeners.elements();
            while (iter.hasMoreElements()) {
                iter.nextElement().validateServices();
            }
        }
        ConfigMap servicesConfig = new ConfigMap();
        ArrayList<String> channelIds = new ArrayList<String>();
        if (endpoint == null) {
            for (Endpoint endpointToAdd : this.getEndpoints().values()) {
                channelIds.add(endpointToAdd.getId());
            }
        } else {
            channelIds.add(endpoint.getId());
        }
        if (this.defaultChannels != null) {
            ConfigMap defaultChannelsMap = new ConfigMap();
            Iterator<String> i$ = this.defaultChannels.iterator();
            while (i$.hasNext()) {
                String defaultChannel;
                String id = defaultChannel = i$.next();
                ConfigMap channelConfig = new ConfigMap();
                channelConfig.addProperty("ref", id);
                defaultChannelsMap.addProperty("channel", channelConfig);
                if (channelIds.contains(id)) continue;
                channelIds.add(id);
            }
            if (defaultChannelsMap.size() > 0) {
                servicesConfig.addProperty("default-channels", defaultChannelsMap);
            }
        }
        for (Service service : this.services.values()) {
            ConfigMap serviceConfig = service instanceof AbstractService ? ((AbstractService)service).describeService(endpoint, onlyReliable) : service.describeService(endpoint);
            if (serviceConfig == null || serviceConfig.size() <= 0) continue;
            servicesConfig.addProperty("service", serviceConfig);
        }
        ConfigMap channels = new ConfigMap();
        for (String id : channelIds) {
            ConfigMap channel;
            Endpoint currentEndpoint = this.getEndpoint(id);
            if (currentEndpoint instanceof AbstractEndpoint && ((AbstractEndpoint)currentEndpoint).isRemote() || (channel = currentEndpoint.describeEndpoint()) == null || channel.size() <= 0) continue;
            channels.addProperty("channel", channel);
        }
        if (channels.size() > 0) {
            servicesConfig.addProperty("channels", channels);
        }
        if (Log.isDebug()) {
            Log.getLogger((String)"Configuration").debug("Returning service description for endpoint: " + (endpoint == null ? "all" : endpoint.getId()) + " config: " + servicesConfig);
        }
        return servicesConfig;
    }

    public void addServiceValidationListener(String id, ServiceValidationListener listener) {
        if (listener != null) {
            this.serviceValidationListeners.putIfAbsent(id, listener);
        }
    }

    public Iterator<ServiceValidationListener> getServiceValidationListenerIterator() {
        return this.serviceValidationListeners.values().iterator();
    }

    public void removeServiceValidationListener(String id) {
        if (this.serviceValidationListeners.containsKey(id)) {
            this.serviceValidationListeners.remove(id);
        }
    }

    public Service createService(String id, String className) {
        Class svcClass = ClassUtil.createClass(className, this.getClassLoader());
        Service service = (Service)ClassUtil.createDefaultInstance(svcClass, Service.class);
        service.setId(id);
        service.setManaged(this.isManaged());
        service.setMessageBroker(this);
        return service;
    }

    public void addService(Service service) {
        if (service == null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11110, new Object[]{SERVICE, "MessageBroker"});
            throw ex;
        }
        String id = service.getId();
        if (id == null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11111, new Object[]{SERVICE, "MessageBroker"});
            throw ex;
        }
        if (this.getService(id) == service) {
            return;
        }
        if (this.getService(id) != null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11112, new Object[]{SERVICE, id, "MessageBroker"});
            throw ex;
        }
        String type = service.getClass().getName();
        if (this.getServiceByType(type) != null && Log.isWarn()) {
            Log.getLogger((String)LOG_CATEGORY).warn("Adding a service type '{0}' that is already registered with the MessageBroker", new Object[]{type});
        }
        this.services.put(id, service);
        if (service.getMessageBroker() == null || service.getMessageBroker() != this) {
            service.setMessageBroker(this);
        }
    }

    public Service removeService(String id) {
        Service service = this.getService(id);
        if (service != null) {
            service.stop();
            this.services.remove(id);
        }
        return service;
    }

    public Log getLog() {
        return this.log;
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    public LoginManager getLoginManager() {
        return this.loginManager;
    }

    public void setLoginManager(LoginManager loginManager) {
        if (this.loginManager != null && this.loginManager.isStarted()) {
            this.loginManager.stop();
        }
        this.loginManager = loginManager;
        if (this.isStarted()) {
            loginManager.start();
        }
    }

    public FlexClientManager getFlexClientManager() {
        return this.flexClientManager;
    }

    public void setFlexClientManager(FlexClientManager value) {
        this.flexClientManager = value;
    }

    public FlexSessionManager getFlexSessionManager() {
        return this.flexSessionManager;
    }

    public void setFlexSessionManager(FlexSessionManager value) {
        this.flexSessionManager = value;
    }

    public RedeployManager getRedeployManager() {
        return this.redeployManager;
    }

    public void setRedeployManager(RedeployManager redeployManager) {
        if (this.redeployManager != null && this.redeployManager.isStarted()) {
            this.redeployManager.stop();
        }
        this.redeployManager = redeployManager;
        if (this.isStarted()) {
            redeployManager.start();
        }
    }

    public Class<? extends ThrottleManager> getThrottleManagerClass() {
        return this.throttleManagerClass;
    }

    public void setThrottleManagerClass(Class<? extends ThrottleManager> throttleManagerClass) {
        this.throttleManagerClass = throttleManagerClass;
    }

    public String createUUID() {
        return this.uuidGenerator != null ? this.uuidGenerator.createUUID() : UUIDUtils.createUUID();
    }

    public UUIDGenerator getUUIDGenerator() {
        return this.uuidGenerator;
    }

    public void setUUIDGenerator(UUIDGenerator value) {
        this.uuidGenerator = value;
    }

    public List<String> getChannelIds() {
        return this.endpoints != null && this.endpoints.size() != 0 ? new ArrayList<String>(this.endpoints.keySet()) : null;
    }

    public ChannelSettings getChannelSettings(String ref) {
        return this.channelSettings.get(ref);
    }

    public Map<String, ChannelSettings> getAllChannelSettings() {
        return this.channelSettings;
    }

    public void setChannelSettings(Map<String, ChannelSettings> channelSettings) {
        this.channelSettings = channelSettings;
    }

    public List<String> getDefaultChannels() {
        return this.defaultChannels;
    }

    public void addDefaultChannel(String id) {
        if (this.defaultChannels == null) {
            this.defaultChannels = new ArrayList<String>();
        } else if (this.defaultChannels.contains(id)) {
            return;
        }
        List<String> channelIds = this.getChannelIds();
        if (channelIds == null || !channelIds.contains(id)) {
            if (Log.isWarn()) {
                Log.getLogger((String)LOG_CATEGORY).warn("No channel with id '{0}' is known by the MessageBroker. Not adding the channel.", new Object[]{id});
            }
            return;
        }
        this.defaultChannels.add(id);
    }

    public void setDefaultChannels(List<String> ids) {
        if (ids != null) {
            List<String> channelIds = this.getChannelIds();
            Iterator<String> iter = ids.iterator();
            while (iter.hasNext()) {
                String id = iter.next();
                if (channelIds != null && channelIds.contains(id)) continue;
                iter.remove();
                if (!Log.isWarn()) continue;
                Log.getLogger((String)LOG_CATEGORY).warn("No channel with id '{0}' is known by the MessageBroker. Not adding the channel.", new Object[]{id});
            }
        }
        this.defaultChannels = ids;
    }

    public boolean removeDefaultChannel(String id) {
        return this.defaultChannels != null && this.defaultChannels.remove(id);
    }

    public SecurityConstraint getSecurityConstraint(String ref) {
        return this.getSecuritySettings().getConstraint(ref);
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public SecuritySettings getSecuritySettings() {
        return this.securitySettings;
    }

    public void setSecuritySettings(SecuritySettings securitySettings) {
        this.securitySettings = securitySettings;
    }

    public SystemSettings getSystemSettings() {
        return this.systemSettings;
    }

    public void setSystemSettings(SystemSettings l) {
        this.systemSettings = l;
    }

    public FlexClientSettings getFlexClientSettings() {
        return this.flexClientSettings;
    }

    public void setFlexClientSettings(FlexClientSettings value) {
        this.flexClientSettings = value;
    }

    public void initThreadLocals() {
    }

    public AcknowledgeMessage routeMessageToService(Message message, Endpoint endpoint) {
        this.checkMessageId(message);
        Object serviceResult = null;
        boolean serviced = false;
        Service service = null;
        String destId = message.getDestination();
        try {
            AcknowledgeMessage ack;
            String serviceId;
            String string = serviceId = destId != null ? this.destinationToService.get(destId) : null;
            if (serviceId == null && destId != null && !this.serviceValidationListeners.isEmpty()) {
                Enumeration<ServiceValidationListener> iter = this.serviceValidationListeners.elements();
                while (iter.hasMoreElements()) {
                    iter.nextElement().validateDestination(destId);
                }
                serviceId = this.destinationToService.get(destId);
            }
            if (serviceId != null) {
                service = this.services.get(serviceId);
                serviced = true;
                Destination destination = service.getDestination(destId);
                this.inspectOperation(message, destination);
                if (message.headerExists("DSValidateEndpoint")) {
                    message.getHeaders().remove("DSValidateEndpoint");
                }
                if (Log.isDebug()) {
                    Log.getLogger((String)this.getLogCategory(message)).debug("Before invoke service: " + service.getId() + StringUtils.NEWLINE + "  incomingMessage: " + message + StringUtils.NEWLINE);
                }
                this.extractRemoteCredentials(service, message);
                serviceResult = service.serviceMessage(message);
            }
            if (!serviced) {
                MessageException lme = new MessageException();
                lme.setMessage(10004);
                throw lme;
            }
            if (Log.isDebug()) {
                String debugServiceResult = Log.getPrettyPrinter().prettify(serviceResult);
                Log.getLogger((String)this.getLogCategory(message)).debug("After invoke service: " + service.getId() + StringUtils.NEWLINE + "  reply: " + debugServiceResult + StringUtils.NEWLINE);
            }
            if (serviceResult instanceof AcknowledgeMessage) {
                ack = (AcknowledgeMessage)serviceResult;
            } else {
                ack = new AcknowledgeMessage();
                ack.setBody(serviceResult);
            }
            ack.setCorrelationId(message.getMessageId());
            ack.setClientId(message.getClientId());
            return ack;
        }
        catch (MessageException exc) {
            exc.logAtHingePoint(message, null, "Exception when invoking service '" + (service == null ? "(none)" : service.getId()) + "': ");
            throw exc;
        }
        catch (RuntimeException exc) {
            Log.getLogger((String)LOG_CATEGORY).error("Exception when invoking service: " + (service == null ? "(none)" : service.getId()) + StringUtils.NEWLINE + "  with message: " + message + StringUtils.NEWLINE + ExceptionUtil.exceptionFollowedByRootCausesToString((Throwable)exc) + StringUtils.NEWLINE);
            throw exc;
        }
        catch (Error exc) {
            Log.getLogger((String)LOG_CATEGORY).error("Error when invoking service: " + (service == null ? "(none)" : service.getId()) + StringUtils.NEWLINE + "  with message: " + message + StringUtils.NEWLINE + ExceptionUtil.exceptionFollowedByRootCausesToString((Throwable)exc) + StringUtils.NEWLINE);
            throw exc;
        }
    }

    public AsyncMessage routeCommandToService(CommandMessage command, Endpoint endpoint) {
        AsyncMessage replyMessage;
        Service service;
        String serviceId;
        this.checkMessageId(command);
        String destId = command.getDestination();
        Object commandResult = null;
        boolean serviced = false;
        boolean recreateHttpFlexSessionAfterLogin = false;
        int operation = command.getOperation();
        if (operation == 8 || operation == 9) {
            serviceId = AUTHENTICATION_SERVICE_ID;
            recreateHttpFlexSessionAfterLogin = this.securitySettings.isRecreateHttpSessionAfterLogin() && operation == 8 && FlexContext.getFlexSession() instanceof HttpFlexSession;
        } else {
            serviceId = destId != null ? this.destinationToService.get(destId) : null;
        }
        Service service2 = service = serviceId != null ? this.services.get(serviceId) : null;
        if (service != null) {
            Destination destination = service.getDestination(destId);
            if (destination != null) {
                this.inspectOperation(command, destination);
            }
            try {
                this.extractRemoteCredentials(service, command);
                commandResult = service.serviceCommand(command);
                serviced = true;
            }
            catch (UnsupportedOperationException e) {
                ServiceException se = new ServiceException();
                se.setMessage(10451, new Object[]{service.getClass().getName()});
                throw se;
            }
            catch (SecurityException se) {
                if (AUTHENTICATION_SERVICE_ID.equals(serviceId)) {
                    commandResult = se.createErrorMessage();
                    if (Log.isDebug()) {
                        Log.getLogger((String)LOG_CATEGORY).debug("Security error for message: " + se.toString() + StringUtils.NEWLINE + "  incomingMessage: " + command + StringUtils.NEWLINE + "  errorReply: " + commandResult);
                    }
                    serviced = true;
                }
                throw se;
            }
        }
        if (recreateHttpFlexSessionAfterLogin) {
            this.recreateHttpFlexSessionAfterLogin();
        }
        if (commandResult == null) {
            replyMessage = new AcknowledgeMessage();
        } else if (commandResult instanceof AsyncMessage) {
            replyMessage = (AsyncMessage)commandResult;
        } else {
            replyMessage = new AcknowledgeMessage();
            replyMessage.setBody(commandResult);
        }
        if (command.getOperation() == 5 || command.getOperation() == 8) {
            FlexClient flexClient;
            double msgVersion;
            ConfigMap serverConfig;
            boolean needsConfig = false;
            if (command.getHeader("DSNeedsConfig") != null) {
                needsConfig = (Boolean)command.getHeader("DSNeedsConfig");
            }
            if (needsConfig && (serverConfig = this.describeServices(endpoint)).size() > 0) {
                replyMessage.setBody(serverConfig);
            }
            if ((msgVersion = endpoint.getMessagingVersion()) > 0.0) {
                replyMessage.setHeader("DSMessagingVersion", new Double(msgVersion));
            }
            if ((flexClient = FlexContext.getFlexClient()) != null) {
                replyMessage.setHeader("DSId", flexClient.getId());
            }
        } else if (!serviced) {
            MessageException lme = new MessageException();
            lme.setMessage(10004);
            throw lme;
        }
        replyMessage.setCorrelationId(command.getMessageId());
        replyMessage.setClientId(command.getClientId());
        if (replyMessage.getBody() instanceof List) {
            replyMessage.setBody(((List)replyMessage.getBody()).toArray());
        }
        if (Log.isDebug()) {
            Log.getLogger((String)this.getLogCategory(command)).debug("Executed command: " + (service == null ? "(default service)" : "service=" + service.getId()) + StringUtils.NEWLINE + "  commandMessage: " + command + StringUtils.NEWLINE + "  replyMessage: " + replyMessage + StringUtils.NEWLINE);
        }
        return replyMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void routeMessageToMessageClient(Message message, MessageClient messageClient) {
        this.checkMessageId(message);
        FlexClient requestFlexClient = FlexContext.getFlexClient();
        FlexSession requestFlexSession = FlexContext.getFlexSession();
        FlexClient pushFlexClient = messageClient.getFlexClient();
        FlexContext.setThreadLocalFlexClient(pushFlexClient);
        FlexContext.setThreadLocalSession(null);
        try {
            pushFlexClient.push(message, messageClient);
        }
        finally {
            FlexContext.setThreadLocalFlexClient(requestFlexClient);
            FlexContext.setThreadLocalSession(requestFlexSession);
        }
    }

    public void inspectOperation(Message message, Destination destination) {
        this.inspectChannel(message, destination);
        this.loginManager.checkConstraint(destination.getSecurityConstraint());
        Service service = destination.getService();
        if (!service.isStarted()) {
            MessageException me = new MessageException();
            me.setMessage(10038, new Object[]{SERVICE, service.getId(), message.getMessageId()});
            throw me;
        }
        if (!destination.isStarted()) {
            MessageException me = new MessageException();
            me.setMessage(10038, new Object[]{"Destination", destination.getId(), message.getMessageId()});
            throw me;
        }
    }

    public void inspectChannel(Message message, Destination destination) {
        if (!this.enforceEndpointValidation && message.getHeader("DSValidateEndpoint") == null) {
            return;
        }
        String messageChannel = (String)message.getHeader("DSEndpoint");
        for (String channelId : destination.getChannels()) {
            if (!channelId.equals(messageChannel)) continue;
            return;
        }
        MessageException lme = new MessageException();
        lme.setMessage(10005, new Object[]{destination.getId(), messageChannel});
        throw lme;
    }

    public String getLogCategory(Message message) {
        if (message instanceof AbstractMessage) {
            return ((AbstractMessage)message).logCategory();
        }
        return LOG_CATEGORY;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean isDestinationRegistered(String destId, String svcId, boolean throwException) {
        if (this.destinationToService.containsKey(destId)) {
            if (throwException) {
                ConfigurationException ex = new ConfigurationException();
                ex.setMessage(11119, new Object[]{destId, svcId, this.destinationToService.get(destId)});
                throw ex;
            }
            return true;
        }
        return false;
    }

    public void registerDestination(String destId, String svcId) {
        if (this.destinationToService.containsKey(destId)) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11119, new Object[]{destId, svcId, this.destinationToService.get(destId)});
            throw ex;
        }
        this.destinationToService.put(destId, svcId);
    }

    public void unregisterDestination(String destId) {
        this.destinationToService.remove(destId);
    }

    public Destination getRegisteredDestination(String destId) {
        String serviceId = destId != null ? this.destinationToService.get(destId) : null;
        return serviceId != null ? this.getService(serviceId).getDestination(destId) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementAttributeIdRefCount(String attributeId) {
        Map<String, Integer> map = this.attributeIdRefCounts;
        synchronized (map) {
            Integer currentCount = this.attributeIdRefCounts.get(attributeId);
            if (currentCount == null) {
                this.attributeIdRefCounts.put(attributeId, INTEGER_ONE);
            } else {
                this.attributeIdRefCounts.put(attributeId, currentCount + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decrementAttributeIdRefCount(String attributeId) {
        Map<String, Integer> map = this.attributeIdRefCounts;
        synchronized (map) {
            Integer currentCount = this.attributeIdRefCounts.get(attributeId);
            if (currentCount == null) {
                return 0;
            }
            int newValue = currentCount - 1;
            this.attributeIdRefCounts.put(attributeId, newValue);
            return newValue;
        }
    }

    protected void checkMessageId(Message message) {
        if (message.getMessageId() == null) {
            MessageException lme = new MessageException();
            lme.setMessage(10029);
            throw lme;
        }
    }

    protected void extractRemoteCredentials(Service service, Message message) {
        if (!message.headerExists("DSRemoteCredentials")) {
            return;
        }
        boolean setting = false;
        String username = null;
        String credentials = null;
        if (message.getHeader("DSRemoteCredentials") instanceof String) {
            String encoded = (String)message.getHeader("DSRemoteCredentials");
            if (encoded.length() > 0) {
                String decoded;
                setting = true;
                Base64.Decoder decoder = new Base64.Decoder();
                decoder.decode(encoded);
                byte[] decodedBytes = decoder.drain();
                String charset = (String)message.getHeader("DSRemoteCredentialsCharset");
                if (charset != null) {
                    try {
                        decoded = new String(decodedBytes, charset);
                    }
                    catch (UnsupportedEncodingException ex) {
                        MessageException lme = new MessageException();
                        lme.setMessage(10020);
                        throw lme;
                    }
                } else {
                    decoded = new String(decodedBytes);
                }
                int colon = decoded.indexOf(58);
                if (colon > 0 && colon < decoded.length() - 1) {
                    username = decoded.substring(0, colon);
                    credentials = decoded.substring(colon + 1);
                }
            }
        } else {
            MessageException lme = new MessageException();
            lme.setMessage(10020);
            throw lme;
        }
        if (setting) {
            FlexContext.getFlexSession().putRemoteCredentials(new FlexRemoteCredentials(service.getId(), message.getDestination(), username, credentials));
        } else {
            FlexContext.getFlexSession().clearRemoteCredentials(service.getId(), message.getDestination());
        }
    }

    @Override
    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected void setInitServletContext(ServletContext servletContext) {
        this.setServletContext(servletContext);
    }

    protected void recreateHttpFlexSessionAfterLogin() {
        FlexSession currentHttpFlexSession = FlexContext.getFlexSession();
        Principal principal = currentHttpFlexSession.getUserPrincipal();
        currentHttpFlexSession.invalidate();
        FlexSession newHttpFlexSession = FlexContext.getFlexSession();
        newHttpFlexSession.setUserPrincipal(principal);
    }

    protected void startEndpoints() {
        for (Endpoint endpoint : this.endpoints.values()) {
            if (endpoint instanceof AbstractEndpoint && ((AbstractEndpoint)endpoint).isRemote()) continue;
            endpoint.start();
        }
    }

    protected void stopEndpoints() {
        for (Endpoint endpoint : this.endpoints.values()) {
            if (endpoint instanceof AbstractEndpoint && ((AbstractEndpoint)endpoint).isRemote()) continue;
            endpoint.stop();
        }
    }

    private void checkEndpointUrl(String id, String endpointUrl) {
        if (endpointUrl == null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(10128, new Object[]{ENDPOINT, "MessageBroker"});
            throw ex;
        }
        String parsedEndpointURI = ChannelSettings.removeTokens((String)endpointUrl);
        if (this.registeredEndpoints.containsKey(parsedEndpointURI)) {
            ConfigurationException ce = new ConfigurationException();
            ce.setMessage(11109, new Object[]{id, parsedEndpointURI, this.registeredEndpoints.get(parsedEndpointURI)});
            throw ce;
        }
        this.registeredEndpoints.put(parsedEndpointURI, id);
        int nextSlash = parsedEndpointURI.indexOf(47, 1);
        if (nextSlash > 0) {
            String parsedEndpointURI2 = parsedEndpointURI.substring(nextSlash);
            if (this.registeredEndpoints.containsKey(parsedEndpointURI2)) {
                ConfigurationException ce = new ConfigurationException();
                ce.setMessage(11109, new Object[]{parsedEndpointURI2, id, this.registeredEndpoints.get(parsedEndpointURI2)});
                throw ce;
            }
            this.registeredEndpoints.put(parsedEndpointURI2, id);
        }
    }

    private boolean matchEndpoint(String path, String contextPath, Endpoint endpoint) {
        boolean match = false;
        String channelEndpoint = endpoint.getParsedUrl(contextPath);
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.equalsIgnoreCase(channelEndpoint)) {
            match = true;
        }
        return match;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerMessageBroker() {
        String mbid = this.getId();
        Map<String, MessageBroker> map = messageBrokers;
        synchronized (map) {
            if (messageBrokers.get(mbid) != null) {
                ConfigurationException ce = new ConfigurationException();
                ce.setMessage(10137, new Object[]{this.getId() == null ? "(no value supplied)" : mbid});
                throw ce;
            }
            messageBrokers.put(mbid, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unRegisterMessageBroker() {
        String mbid = this.getId();
        Map<String, MessageBroker> map = messageBrokers;
        synchronized (map) {
            messageBrokers.remove(mbid);
        }
    }

    private void startServers() {
        for (Server server : this.servers.values()) {
            boolean serverIsReferenced = false;
            for (Endpoint endpoint : this.endpoints.values()) {
                if (!(endpoint instanceof Endpoint2) || !server.equals(((Endpoint2)endpoint).getServer())) continue;
                serverIsReferenced = true;
                break;
            }
            if (!serverIsReferenced && Log.isWarn()) {
                Log.getLogger((String)"Configuration").warn("Server '" + server.getId() + "' is not referenced by any endpoints.");
            }
            server.start();
        }
    }

    private void stopServers() {
        for (Server server : this.servers.values()) {
            server.stop();
        }
    }

    private void startServices() {
        for (Service svc : this.services.values()) {
            long timeBeforeStartup = 0L;
            if (Log.isDebug()) {
                timeBeforeStartup = System.currentTimeMillis();
                Log.getLogger((String)LOG_CATEGORY_STARTUP_SERVICE).debug("Service with id '{0}' is starting.", new Object[]{svc.getId()});
            }
            svc.start();
            if (!Log.isDebug()) continue;
            long timeAfterStartup = System.currentTimeMillis();
            Long diffMillis = timeAfterStartup - timeBeforeStartup;
            Log.getLogger((String)LOG_CATEGORY_STARTUP_SERVICE).debug("Service with id '{0}' is ready (startup time: '{1}' ms)", new Object[]{svc.getId(), diffMillis});
        }
    }

    private void stopServices() {
        for (Service svc : this.services.values()) {
            svc.stop();
        }
    }

    public static interface InternalPathResolver
    extends PathResolver {
    }

    public static interface PathResolver {
        public InputStream resolve(String var1) throws IOException;
    }
}

