/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.endpoints;

import flex.management.runtime.messaging.endpoints.AMFEndpointControl;
import flex.messaging.MessageBroker;
import flex.messaging.endpoints.BasePollingHTTPEndpoint;
import flex.messaging.endpoints.amf.AMFFilter;
import flex.messaging.endpoints.amf.BatchProcessFilter;
import flex.messaging.endpoints.amf.LegacyFilter;
import flex.messaging.endpoints.amf.MessageBrokerFilter;
import flex.messaging.endpoints.amf.SerializationFilter;
import flex.messaging.endpoints.amf.SessionFilter;

public class AMFEndpoint
extends BasePollingHTTPEndpoint {
    public static final String LOG_CATEGORY = "Endpoint.AMF";

    public AMFEndpoint() {
        this(false);
    }

    public AMFEndpoint(boolean enableManagement) {
        super(enableManagement);
    }

    @Override
    protected AMFFilter createFilterChain() {
        SerializationFilter serializationFilter = new SerializationFilter(this.getLogCategory());
        BatchProcessFilter batchFilter = new BatchProcessFilter();
        SessionFilter sessionFilter = this.sessionRewritingEnabled ? new SessionFilter() : null;
        LegacyFilter envelopeFilter = new LegacyFilter(this);
        MessageBrokerFilter messageBrokerFilter = new MessageBrokerFilter(this);
        serializationFilter.setNext(batchFilter);
        if (sessionFilter != null) {
            batchFilter.setNext(sessionFilter);
            sessionFilter.setNext(envelopeFilter);
        } else {
            batchFilter.setNext(envelopeFilter);
        }
        envelopeFilter.setNext(messageBrokerFilter);
        return serializationFilter;
    }

    @Override
    protected String getResponseContentType() {
        return "application/x-amf";
    }

    @Override
    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    @Override
    protected String getDeserializerClassName() {
        return "flex.messaging.io.amf.AmfMessageDeserializer";
    }

    @Override
    protected String getSerializerClassName() {
        return "flex.messaging.io.amf.AmfMessageSerializer";
    }

    @Override
    protected void setupEndpointControl(MessageBroker broker) {
        this.controller = new AMFEndpointControl(this, broker.getControl());
        this.controller.register();
        this.setControl(this.controller);
    }
}

