/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf;

import flex.messaging.MessageException;
import flex.messaging.io.ArrayCollection;
import flex.messaging.io.BeanProxy;
import flex.messaging.io.PagedRowSet;
import flex.messaging.io.PropertyProxy;
import flex.messaging.io.PropertyProxyRegistry;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationDescriptor;
import flex.messaging.io.StatusInfoProxy;
import flex.messaging.io.amf.ASObject;
import flex.messaging.io.amf.AbstractAmfOutput;
import flex.messaging.io.amf.Amf3Types;
import flex.messaging.io.amf.AmfTrace;
import flex.messaging.io.amf.TraitsInfo;
import flex.messaging.util.Trace;
import java.io.Externalizable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;
import org.w3c.dom.Document;

public class Amf3Output
extends AbstractAmfOutput
implements Amf3Types {
    protected IdentityHashMap<Object, Integer> objectTable;
    protected HashMap<TraitsInfo, Integer> traitsTable;
    protected HashMap<String, Integer> stringTable;

    public Amf3Output(SerializationContext context) {
        super(context);
        context.supportDatesByReference = true;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.objectTable != null) {
            this.objectTable.clear();
        }
        if (this.traitsTable != null) {
            this.traitsTable.clear();
        }
        if (this.stringTable != null) {
            this.stringTable.clear();
        }
    }

    @Override
    public void writeObject(Object o) throws IOException {
        if (o == null) {
            this.writeAMFNull();
            return;
        }
        if (!this.context.legacyExternalizable && o instanceof Externalizable) {
            this.writeCustomObject(o);
        } else if (o instanceof String || o instanceof Character) {
            String s = o.toString();
            this.writeAMFString(s);
        } else if (o instanceof Number) {
            if (o instanceof Integer || o instanceof Short || o instanceof Byte) {
                int i = ((Number)o).intValue();
                this.writeAMFInt(i);
            } else if (!this.context.legacyBigNumbers && (o instanceof BigInteger || o instanceof BigDecimal)) {
                this.writeAMFString(((Number)o).toString());
            } else {
                double d = ((Number)o).doubleValue();
                this.writeAMFDouble(d);
            }
        } else if (o instanceof Boolean) {
            this.writeAMFBoolean((Boolean)o);
        } else if (o instanceof Date) {
            this.writeAMFDate((Date)o);
        } else if (o instanceof Calendar) {
            this.writeAMFDate(((Calendar)o).getTime());
        } else if (o instanceof Document) {
            if (this.context.legacyXMLDocument) {
                this.out.write(7);
            } else {
                this.out.write(11);
            }
            if (!this.byReference(o)) {
                String xml = this.documentToString(o);
                if (this.isDebug) {
                    this.trace.write(xml);
                }
                this.writeAMFUTF(xml);
            }
        } else if (o instanceof Enum && PropertyProxyRegistry.getRegistry().getProxy(o.getClass()) == null) {
            Enum enumValue = (Enum)o;
            this.writeAMFString(enumValue.name());
        } else {
            Class<?> cls = o.getClass();
            if (this.context.legacyMap && o instanceof Map && !(o instanceof ASObject)) {
                this.writeMapAsECMAArray((Map)o);
            } else if (!this.context.legacyDictionary && o instanceof Dictionary) {
                this.writeDictionary((Dictionary)o);
            } else if (o instanceof Collection) {
                if (o instanceof List && this.context.preferVectors) {
                    this.writeListAsTypedVector((List)o);
                } else if (this.context.legacyCollection) {
                    this.writeCollection((Collection)o, null);
                } else {
                    this.writeArrayCollection((Collection)o, null);
                }
            } else if (cls.isArray()) {
                Class<?> componentType = cls.getComponentType();
                if (!(!this.context.preferVectors || componentType.equals(Byte.class) || componentType.equals(Byte.TYPE) || componentType.equals(Character.class) || componentType.equals(Character.TYPE))) {
                    this.writeArrayAsTypedVector(o, componentType);
                } else {
                    this.writeAMFArray(o, componentType);
                }
            } else {
                if (o instanceof RowSet) {
                    o = new PagedRowSet((RowSet)o, Integer.MAX_VALUE, false);
                } else if (this.context.legacyThrowable && o instanceof Throwable) {
                    o = new StatusInfoProxy((Throwable)o);
                }
                this.writeCustomObject(o);
            }
        }
    }

    @Override
    public void writeObjectTraits(TraitsInfo ti) throws IOException {
        String className = ti.getClassName();
        if (this.isDebug) {
            if (ti.isExternalizable()) {
                this.trace.startExternalizableObject(className, this.getObjectTableSize());
            } else {
                this.trace.startAMFObject(className, this.getObjectTableSize());
            }
        }
        if (!this.byReference(ti)) {
            int count = 0;
            List<String> propertyNames = null;
            boolean externalizable = ti.isExternalizable();
            if (!externalizable && (propertyNames = ti.getProperties()) != null) {
                count = propertyNames.size();
            }
            boolean dynamic = ti.isDynamic();
            this.writeUInt29(3 | (externalizable ? 4 : 0) | (dynamic ? 8 : 0) | count << 4);
            this.writeStringWithoutType(className);
            if (!externalizable && propertyNames != null) {
                for (int i = 0; i < count; ++i) {
                    String propName = ti.getProperty(i);
                    this.writeStringWithoutType(propName);
                }
            }
        }
    }

    @Override
    public void writeObjectProperty(String name, Object value) throws IOException {
        if (this.isDebug) {
            this.trace.namedElement(name);
        }
        this.increaseNestObjectLevel();
        this.writeObject(value);
        this.decreaseNestObjectLevel();
    }

    @Override
    public void writeObjectEnd() throws IOException {
        if (this.isDebug) {
            this.trace.endAMFObject();
        }
    }

    protected void writeAMFBoolean(boolean b) throws IOException {
        if (this.isDebug) {
            this.trace.write(b);
        }
        if (b) {
            this.out.write(3);
        } else {
            this.out.write(2);
        }
    }

    protected void writeAMFDate(Date d) throws IOException {
        this.out.write(8);
        if (!this.byReference(d)) {
            if (this.isDebug) {
                this.trace.write(d);
            }
            this.writeUInt29(1);
            this.out.writeDouble(d.getTime());
        }
    }

    protected void writeAMFDouble(double d) throws IOException {
        if (this.isDebug) {
            this.trace.write(d);
        }
        this.out.write(5);
        this.out.writeDouble(d);
    }

    protected void writeAMFInt(int i) throws IOException {
        if (i >= -268435456 && i <= 0xFFFFFFF) {
            if (this.isDebug) {
                this.trace.write(i);
            }
            this.out.write(4);
            this.writeUInt29(i &= 0x1FFFFFFF);
        } else {
            this.writeAMFDouble(i);
        }
    }

    protected void writeDictionary(Dictionary dictionary) throws IOException {
        this.out.write(17);
        if (this.byReference(dictionary)) {
            return;
        }
        this.writeUInt29(dictionary.size() << 1 | 1);
        this.writeAMFBoolean(false);
        if (this.isDebug) {
            this.trace.startAMFDictionary(this.objectTable.size() - 1);
        }
        Enumeration keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            if (this.isDebug) {
                this.trace.startDictionaryElement();
            }
            Object key = keys.nextElement();
            this.increaseNestObjectLevel();
            this.writeObject(key);
            this.decreaseNestObjectLevel();
            if (this.isDebug) {
                this.trace.addDictionaryEquals();
            }
            Object value = dictionary.get(key);
            this.increaseNestObjectLevel();
            this.writeObject(value);
            this.decreaseNestObjectLevel();
        }
        if (this.isDebug) {
            this.trace.endAMFDictionary();
        }
    }

    protected void writeArrayAsTypedVector(Object array, Class<?> componentType) throws IOException {
        int vecType = 16;
        if (componentType.isPrimitive()) {
            if (Integer.TYPE.equals(componentType)) {
                vecType = 13;
            } else if (Double.TYPE.equals(componentType)) {
                vecType = 15;
            }
        } else if (Integer.class.equals(componentType)) {
            vecType = 13;
        } else if (Double.class.equals(componentType)) {
            vecType = 15;
        }
        this.out.write(vecType);
        if (this.byReference(array)) {
            return;
        }
        int length = Array.getLength(array);
        this.writeUInt29(length << 1 | 1);
        this.writeBoolean(true);
        switch (vecType) {
            case 13: {
                if (this.isDebug) {
                    this.trace.startAMFVector(this.objectTable.size() - 1, AmfTrace.VectorType.INT);
                }
                for (int i = 0; i < length; ++i) {
                    if (this.isDebug) {
                        this.trace.arrayElement(i);
                    }
                    Object element = Array.get(array, i);
                    int value = (Integer)element;
                    if (this.isDebug) {
                        this.trace.write(value);
                    }
                    this.writeInt(value);
                }
                break;
            }
            case 15: {
                if (this.isDebug) {
                    this.trace.startAMFVector(this.objectTable.size() - 1, AmfTrace.VectorType.DOUBLE);
                }
                for (int i = 0; i < length; ++i) {
                    if (this.isDebug) {
                        this.trace.arrayElement(i);
                    }
                    Object element = Array.get(array, i);
                    double value = (Double)element;
                    if (this.isDebug) {
                        this.trace.write(value);
                    }
                    this.writeDouble(value);
                }
                break;
            }
            case 16: {
                if (this.isDebug) {
                    this.trace.startAMFVector(this.objectTable.size() - 1, AmfTrace.VectorType.OBJECT);
                }
                String className = componentType.getName();
                this.writeStringWithoutType(className);
                for (int i = 0; i < length; ++i) {
                    if (this.isDebug) {
                        this.trace.arrayElement(i);
                    }
                    Object element = Array.get(array, i);
                    this.increaseNestObjectLevel();
                    this.writeObject(element);
                    this.decreaseNestObjectLevel();
                }
                break;
            }
        }
        if (this.isDebug) {
            this.trace.endAMFVector();
        }
    }

    protected void writeListAsTypedVector(List list) throws IOException {
        int vecType = -1;
        Class<?> initialElementClass = null;
        int peekSize = Math.min(list.size(), 3);
        for (int i = 0; i < peekSize; ++i) {
            Class<?> currentElementClass;
            Object element = list.get(i);
            if (i == 0) {
                initialElementClass = element != null ? element.getClass() : null;
                continue;
            }
            Class<?> clazz = currentElementClass = element != null ? element.getClass() : null;
            if (initialElementClass == currentElementClass) continue;
            vecType = 16;
            break;
        }
        if (vecType == -1) {
            vecType = initialElementClass == Integer.class ? 13 : (initialElementClass == Double.class ? 15 : 16);
        }
        this.out.write(vecType);
        if (this.byReference(list)) {
            return;
        }
        int length = list.size();
        this.writeUInt29(length << 1 | 1);
        this.writeBoolean(false);
        switch (vecType) {
            case 13: {
                Object element;
                if (this.isDebug) {
                    this.trace.startAMFVector(this.objectTable.size() - 1, AmfTrace.VectorType.INT);
                }
                for (int i = 0; i < length; ++i) {
                    if (this.isDebug) {
                        this.trace.arrayElement(i);
                    }
                    element = list.get(i);
                    int value = (Integer)element;
                    if (this.isDebug) {
                        this.trace.write(value);
                    }
                    this.writeInt(value);
                }
                break;
            }
            case 15: {
                Object element;
                if (this.isDebug) {
                    this.trace.startAMFVector(this.objectTable.size() - 1, AmfTrace.VectorType.DOUBLE);
                }
                for (int i = 0; i < length; ++i) {
                    if (this.isDebug) {
                        this.trace.arrayElement(i);
                    }
                    element = list.get(i);
                    double value = (Double)element;
                    if (this.isDebug) {
                        this.trace.write(value);
                    }
                    this.writeDouble(value);
                }
                break;
            }
            case 16: {
                if (this.isDebug) {
                    this.trace.startAMFVector(this.objectTable.size() - 1, AmfTrace.VectorType.OBJECT);
                }
                String className = initialElementClass != null ? initialElementClass.getName() : "";
                this.writeStringWithoutType(className);
                for (int i = 0; i < length; ++i) {
                    if (this.isDebug) {
                        this.trace.arrayElement(i);
                    }
                    Object element = list.get(i);
                    this.increaseNestObjectLevel();
                    this.writeObject(element);
                    this.decreaseNestObjectLevel();
                }
                break;
            }
        }
        if (this.isDebug) {
            this.trace.endAMFVector();
        }
    }

    protected void writeMapAsECMAArray(Map map) throws IOException {
        this.out.write(9);
        if (!this.byReference(map)) {
            if (this.isDebug) {
                this.trace.startECMAArray(this.getObjectTableSize());
            }
            this.writeUInt29(1);
            for (Object key : map.keySet()) {
                if (key == null) continue;
                String propName = key.toString();
                this.writeStringWithoutType(propName);
                if (this.isDebug) {
                    this.trace.namedElement(propName);
                }
                this.increaseNestObjectLevel();
                this.writeObject(map.get(key));
                this.decreaseNestObjectLevel();
            }
            this.writeStringWithoutType("");
            if (this.isDebug) {
                this.trace.endAMFArray();
            }
        }
    }

    protected void writeAMFNull() throws IOException {
        if (this.isDebug) {
            this.trace.writeNull();
        }
        this.out.write(1);
    }

    protected void writeAMFString(String s) throws IOException {
        this.out.write(6);
        this.writeStringWithoutType(s);
        if (this.isDebug) {
            this.trace.writeString(s);
        }
    }

    protected void writeStringWithoutType(String s) throws IOException {
        if (s.length() == 0) {
            this.writeUInt29(1);
            return;
        }
        if (!this.byReference(s)) {
            this.writeAMFUTF(s);
            return;
        }
    }

    protected void writeAMFArray(Object o, Class componentType) throws IOException {
        if (componentType.isPrimitive()) {
            this.writePrimitiveArray(o);
        } else if (componentType.equals(Byte.class)) {
            this.writeAMFByteArray((Byte[])o);
        } else if (componentType.equals(Character.class)) {
            this.writeCharArrayAsString((Character[])o);
        } else {
            this.writeObjectArray((Object[])o, null);
        }
    }

    protected void writeArrayCollection(Collection col, SerializationDescriptor desc) throws IOException {
        this.out.write(10);
        if (!this.byReference(col)) {
            ArrayCollection ac;
            if (col instanceof ArrayCollection) {
                ac = (ArrayCollection)col;
            } else {
                ac = new ArrayCollection(col);
                if (desc != null) {
                    ac.setDescriptor(desc);
                }
            }
            PropertyProxy proxy = PropertyProxyRegistry.getProxy(ac);
            this.writePropertyProxy(proxy, ac);
        }
    }

    protected void writeCustomObject(Object o) throws IOException {
        PropertyProxy proxy = null;
        if (o instanceof PropertyProxy) {
            proxy = (PropertyProxy)o;
            if ((o = proxy.getDefaultInstance()) == null) {
                this.writeAMFNull();
                return;
            }
            if (o instanceof Collection) {
                if (this.context.legacyCollection) {
                    this.writeCollection((Collection)o, proxy.getDescriptor());
                } else {
                    this.writeArrayCollection((Collection)o, proxy.getDescriptor());
                }
                return;
            }
            if (o.getClass().isArray()) {
                this.writeObjectArray((Object[])o, proxy.getDescriptor());
                return;
            }
            if (this.context.legacyMap && o instanceof Map && !(o instanceof ASObject)) {
                this.writeMapAsECMAArray((Map)o);
                return;
            }
        }
        this.out.write(10);
        if (!this.byReference(o)) {
            if (proxy == null) {
                proxy = PropertyProxyRegistry.getProxyAndRegister(o);
            }
            this.writePropertyProxy(proxy, o);
        }
    }

    protected void writePropertyProxy(PropertyProxy proxy, Object instance) throws IOException {
        Object newInst = proxy.getInstanceToSerialize(instance);
        if (newInst != instance) {
            if (newInst == null) {
                throw new MessageException("PropertyProxy.getInstanceToSerialize class: " + proxy.getClass() + " returned null for instance class: " + instance.getClass().getName());
            }
            proxy = PropertyProxyRegistry.getProxyAndRegister(newInst);
            instance = newInst;
        }
        List propertyNames = null;
        boolean externalizable = proxy.isExternalizable(instance);
        if (!externalizable) {
            propertyNames = proxy.getPropertyNames(instance);
            if (proxy instanceof BeanProxy) {
                BeanProxy bp = (BeanProxy)proxy;
                if (propertyNames != null && !propertyNames.isEmpty()) {
                    ArrayList<String> propertiesToRemove = null;
                    for (int i = 0; i < propertyNames.size(); ++i) {
                        String propName = (String)propertyNames.get(i);
                        if (!bp.isWriteOnly(instance, propName)) continue;
                        if (propertiesToRemove == null) {
                            propertiesToRemove = new ArrayList<String>();
                        }
                        propertiesToRemove.add(propName);
                    }
                    if (propertiesToRemove != null) {
                        propertyNames.removeAll(propertiesToRemove);
                    }
                }
            }
        }
        TraitsInfo ti = new TraitsInfo(proxy.getAlias(instance), proxy.isDynamic(), externalizable, propertyNames);
        this.writeObjectTraits(ti);
        if (externalizable) {
            ((Externalizable)instance).writeExternal(this);
        } else if (propertyNames != null && !propertyNames.isEmpty()) {
            for (int i = 0; i < propertyNames.size(); ++i) {
                String propName = (String)propertyNames.get(i);
                Object value = proxy.getValue(instance, propName);
                this.writeObjectProperty(propName, value);
            }
        }
        this.writeObjectEnd();
    }

    protected void writePrimitiveArray(Object obj) throws IOException {
        block17: {
            Class<?> aType;
            block18: {
                block16: {
                    aType = obj.getClass().getComponentType();
                    if (!aType.equals(Character.TYPE)) break block16;
                    char[] c = (char[])obj;
                    this.writeCharArrayAsString(c);
                    break block17;
                }
                if (!aType.equals(Byte.TYPE)) break block18;
                this.writeAMFByteArray((byte[])obj);
                break block17;
            }
            this.out.write(9);
            if (this.byReference(obj)) break block17;
            if (aType.equals(Boolean.TYPE)) {
                boolean[] b = (boolean[])obj;
                this.writeUInt29(b.length << 1 | 1);
                this.writeStringWithoutType("");
                if (this.isDebug) {
                    this.trace.startAMFArray(this.getObjectTableSize());
                    for (int i = 0; i < b.length; ++i) {
                        this.trace.arrayElement(i);
                        this.writeAMFBoolean(b[i]);
                    }
                    this.trace.endAMFArray();
                } else {
                    for (int i = 0; i < b.length; ++i) {
                        this.writeAMFBoolean(b[i]);
                    }
                }
            } else if (aType.equals(Integer.TYPE) || aType.equals(Short.TYPE)) {
                int length = Array.getLength(obj);
                this.writeUInt29(length << 1 | 1);
                this.writeStringWithoutType("");
                if (this.isDebug) {
                    this.trace.startAMFArray(this.getObjectTableSize());
                    for (int i = 0; i < length; ++i) {
                        this.trace.arrayElement(i);
                        int v = Array.getInt(obj, i);
                        this.writeAMFInt(v);
                    }
                    this.trace.endAMFArray();
                } else {
                    for (int i = 0; i < length; ++i) {
                        int v = Array.getInt(obj, i);
                        this.writeAMFInt(v);
                    }
                }
            } else {
                int length = Array.getLength(obj);
                this.writeUInt29(length << 1 | 1);
                this.writeStringWithoutType("");
                if (this.isDebug) {
                    this.trace.startAMFArray(this.getObjectTableSize());
                    for (int i = 0; i < length; ++i) {
                        this.trace.arrayElement(i);
                        double v = Array.getDouble(obj, i);
                        this.writeAMFDouble(v);
                    }
                    this.trace.endAMFArray();
                } else {
                    for (int i = 0; i < length; ++i) {
                        double v = Array.getDouble(obj, i);
                        this.writeAMFDouble(v);
                    }
                }
            }
        }
    }

    protected void writeAMFByteArray(byte[] ba) throws IOException {
        this.out.write(12);
        if (!this.byReference(ba)) {
            int length = ba.length;
            this.writeUInt29(length << 1 | 1);
            if (this.isDebug) {
                this.trace.startByteArray(this.getObjectTableSize(), length);
            }
            this.out.write(ba, 0, length);
        }
    }

    protected void writeAMFByteArray(Byte[] ba) throws IOException {
        this.out.write(12);
        if (!this.byReference(ba)) {
            int length = ba.length;
            this.writeUInt29(length << 1 | 1);
            if (this.isDebug) {
                this.trace.startByteArray(this.getObjectTableSize(), length);
            }
            for (int i = 0; i < ba.length; ++i) {
                Byte b = ba[i];
                if (b == null) {
                    this.out.write(0);
                    continue;
                }
                this.out.write(b.byteValue());
            }
        }
    }

    protected void writeCharArrayAsString(Character[] ca) throws IOException {
        int length = ca.length;
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            Character c = ca[i];
            chars[i] = c == null ? (char)'\u0000' : ca[i].charValue();
        }
        this.writeCharArrayAsString(chars);
    }

    protected void writeCharArrayAsString(char[] ca) throws IOException {
        String str = new String(ca);
        this.writeAMFString(str);
    }

    protected void writeObjectArray(Object[] values, SerializationDescriptor descriptor) throws IOException {
        this.out.write(9);
        if (!this.byReference(values)) {
            if (this.isDebug) {
                this.trace.startAMFArray(this.getObjectTableSize());
            }
            this.writeUInt29(values.length << 1 | 1);
            this.writeStringWithoutType("");
            for (int i = 0; i < values.length; ++i) {
                Object item;
                if (this.isDebug) {
                    this.trace.arrayElement(i);
                }
                if (!((item = values[i]) == null || descriptor == null || item instanceof String || item instanceof Number || item instanceof Boolean || item instanceof Character)) {
                    PropertyProxy proxy = PropertyProxyRegistry.getProxy(item);
                    proxy = (PropertyProxy)proxy.clone();
                    proxy.setDescriptor(descriptor);
                    proxy.setDefaultInstance(item);
                    item = proxy;
                }
                this.increaseNestObjectLevel();
                this.writeObject(item);
                this.decreaseNestObjectLevel();
            }
            if (this.isDebug) {
                this.trace.endAMFArray();
            }
        }
    }

    protected void writeCollection(Collection c, SerializationDescriptor descriptor) throws IOException {
        this.out.write(9);
        if (!this.byReference(c)) {
            if (this.isDebug) {
                this.trace.startAMFArray(this.getObjectTableSize());
            }
            this.writeUInt29(c.size() << 1 | 1);
            this.writeStringWithoutType("");
            Iterator it = c.iterator();
            int i = 0;
            while (it.hasNext()) {
                Object item;
                if (this.isDebug) {
                    this.trace.arrayElement(i);
                }
                if (!((item = it.next()) == null || descriptor == null || item instanceof String || item instanceof Number || item instanceof Boolean || item instanceof Character)) {
                    PropertyProxy proxy = PropertyProxyRegistry.getProxy(item);
                    proxy = (PropertyProxy)proxy.clone();
                    proxy.setDescriptor(descriptor);
                    proxy.setDefaultInstance(item);
                    item = proxy;
                }
                this.increaseNestObjectLevel();
                this.writeObject(item);
                this.decreaseNestObjectLevel();
                ++i;
            }
            if (this.isDebug) {
                this.trace.endAMFArray();
            }
        }
    }

    protected void writeUInt29(int ref) throws IOException {
        if (ref < 128) {
            this.out.writeByte(ref);
        } else if (ref < 16384) {
            this.out.writeByte(ref >> 7 & 0x7F | 0x80);
            this.out.writeByte(ref & 0x7F);
        } else if (ref < 0x200000) {
            this.out.writeByte(ref >> 14 & 0x7F | 0x80);
            this.out.writeByte(ref >> 7 & 0x7F | 0x80);
            this.out.writeByte(ref & 0x7F);
        } else if (ref < 0x40000000) {
            this.out.writeByte(ref >> 22 & 0x7F | 0x80);
            this.out.writeByte(ref >> 15 & 0x7F | 0x80);
            this.out.writeByte(ref >> 8 & 0x7F | 0x80);
            this.out.writeByte(ref & 0xFF);
        } else {
            throw new MessageException("Integer out of range: " + ref);
        }
    }

    public void writeAMFUTF(String s) throws IOException {
        char c;
        int strlen = s.length();
        int utflen = 0;
        int count = 0;
        char[] charr = this.getTempCharArray(strlen);
        s.getChars(0, strlen, charr, 0);
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        this.writeUInt29(utflen << 1 | 1);
        byte[] bytearr = this.getTempByteArray(utflen);
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c <= '\u007f') {
                bytearr[count++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        this.out.write(bytearr, 0, utflen);
    }

    protected boolean byReference(Object o) throws IOException {
        if (this.objectTable != null && this.objectTable.containsKey(o)) {
            try {
                int refNum = this.objectTable.get(o);
                if (this.isDebug) {
                    this.trace.writeRef(refNum);
                }
                this.writeUInt29(refNum << 1);
                return true;
            }
            catch (ClassCastException e) {
                throw new IOException("Object reference is not an Integer");
            }
        }
        if (this.objectTable == null) {
            this.objectTable = new IdentityHashMap(64);
        }
        this.objectTable.put(o, this.objectTable.size());
        return false;
    }

    public void addObjectReference(Object o) throws IOException {
        this.byReference(o);
    }

    protected boolean byReference(String s) throws IOException {
        if (this.stringTable != null && this.stringTable.containsKey(s)) {
            try {
                int refNum = this.stringTable.get(s);
                this.writeUInt29(refNum << 1);
                if (this.isDebug && Trace.amf) {
                    this.trace.writeStringRef(refNum);
                }
                return true;
            }
            catch (ClassCastException e) {
                throw new IOException("String reference is not an Integer");
            }
        }
        if (this.stringTable == null) {
            this.stringTable = new HashMap(64);
        }
        this.stringTable.put(s, this.stringTable.size());
        return false;
    }

    protected boolean byReference(TraitsInfo ti) throws IOException {
        if (this.traitsTable != null && this.traitsTable.containsKey(ti)) {
            try {
                int refNum = this.traitsTable.get(ti);
                this.writeUInt29(refNum << 2 | 1);
                if (this.isDebug && Trace.amf) {
                    this.trace.writeTraitsInfoRef(refNum);
                }
                return true;
            }
            catch (ClassCastException e) {
                throw new IOException("TraitsInfo reference is not an Integer");
            }
        }
        if (this.traitsTable == null) {
            this.traitsTable = new HashMap(10);
        }
        this.traitsTable.put(ti, this.traitsTable.size());
        return false;
    }

    protected int getObjectTableSize() {
        return this.objectTable != null ? this.objectTable.size() - 1 : 0;
    }
}

