/*
 * Decompiled with CFR 0.152.
 */
package flex.management;

import flex.management.BaseControl;
import flex.management.Manageable;
import flex.messaging.FlexComponent;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationException;
import flex.messaging.log.Log;
import java.util.Date;

public abstract class ManageableComponent
implements Manageable,
FlexComponent {
    protected static final int PROPERTY_CHANGE_AFTER_STARTUP = 11115;
    protected static final int NULL_COMPONENT_PROPERTY = 11116;
    protected BaseControl control;
    protected String id;
    protected volatile boolean managed;
    protected Manageable parent;
    protected volatile boolean started;
    protected boolean valid;

    public ManageableComponent(boolean enableManagement) {
        this.setManaged(enableManagement);
    }

    @Override
    public BaseControl getControl() {
        return this.control;
    }

    @Override
    public void setControl(BaseControl control) {
        this.control = control;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (this.isStarted()) {
            this.blockAssignmentWhileStarted("id");
        }
        if (id == null) {
            this.blockNullAssignment("id");
        }
        this.id = id;
    }

    @Override
    public boolean isManaged() {
        return this.managed;
    }

    @Override
    public void setManaged(boolean enableManagement) {
        if (this.isStarted() && this.control != null) {
            this.blockAssignmentWhileStarted("managed");
        }
        if (enableManagement && this.parent != null && !this.parent.isManaged()) {
            if (Log.isWarn()) {
                Log.getLogger((String)this.getLogCategory()).warn("Component: '" + this.id + "' cannot be managed" + " since its parent is unmanaged.");
            }
            return;
        }
        this.managed = enableManagement;
    }

    public Manageable getParent() {
        return this.parent;
    }

    public void setParent(Manageable parent) {
        if (this.isStarted()) {
            this.blockAssignmentWhileStarted("parent");
        }
        if (parent == null) {
            this.blockNullAssignment("parent");
        }
        if (!parent.isManaged() && this.isManaged()) {
            if (Log.isWarn()) {
                Log.getLogger((String)this.getLogCategory()).warn("Component: '" + this.id + "' cannot be managed" + " since its parent is unmanaged.");
            }
            this.setManaged(false);
        }
        this.parent = parent;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    protected void setStarted(boolean started) {
        if (this.started != started) {
            this.started = started;
            if (started && this.control != null) {
                this.control.setStartTimestamp(new Date());
            }
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    protected void setValid(boolean valid) {
        this.valid = valid;
    }

    protected abstract String getLogCategory();

    @Override
    public void initialize(String id, ConfigMap properties) {
        this.setId(id);
    }

    @Override
    public void start() {
        this.validate();
        this.setStarted(true);
    }

    @Override
    public void stop() {
        this.invalidate();
        this.setStarted(false);
    }

    protected void blockAssignmentWhileStarted(String propertyName) {
        ConfigurationException ce = new ConfigurationException();
        ce.setMessage(11115, new Object[]{propertyName});
        throw ce;
    }

    protected void blockNullAssignment(String propertyName) {
        ConfigurationException ce = new ConfigurationException();
        ce.setMessage(11116, new Object[]{propertyName});
        throw ce;
    }

    protected void invalidate() {
        this.setValid(false);
    }

    protected void validate() {
        if (this.getId() == null) {
            this.blockNullAssignment("id");
        }
        if (this.getParent() == null) {
            this.blockNullAssignment("parent");
        }
        this.setValid(true);
    }
}

