/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.endpoints;

import flex.management.runtime.messaging.endpoints.EndpointControl;
import flex.messaging.FlexContext;
import flex.messaging.FlexSession;
import flex.messaging.HttpFlexSession;
import flex.messaging.MessageClient;
import flex.messaging.client.FlexClient;
import flex.messaging.config.ConfigMap;
import flex.messaging.endpoints.AbstractEndpoint;
import flex.messaging.endpoints.DuplicateSessionException;
import flex.messaging.endpoints.amf.AMFFilter;
import flex.messaging.io.amf.ActionContext;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import flex.messaging.util.SettingsReplaceUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseHTTPEndpoint
extends AbstractEndpoint {
    public static final String HTTP_PROTOCOL_SCHEME = "http";
    public static final String HTTPS_PROTOCOL_SCHEME = "https";
    private static final String ADD_NO_CACHE_HEADERS = "add-no-cache-headers";
    private static final String REDIRECT_URL = "redirect-url";
    private static final String INVALIDATE_SESSION_ON_DISCONNECT = "invalidate-session-on-disconnect";
    private static final String HTTP_RESPONSE_HEADERS = "http-response-headers";
    private static final String HEADER_ATTR = "header";
    private static final String HEADER_NAME_ORIGIN = "Origin";
    private static final String ACCESS_CONTROL = "Access-Control-";
    private static final String SESSION_REWRITING_ENABLED = "session-rewriting-enabled";
    private static final int ERR_MSG_DUPLICATE_SESSIONS_DETECTED = 10035;
    private static final String REQUEST_ATTR_DUPLICATE_SESSION_FLAG = "flex.messaging.request.DuplicateSessionDetected";
    protected EndpointControl controller;
    protected AMFFilter filterChain;
    protected List<HttpHeader> httpResponseHeaders;
    protected boolean addNoCacheHeaders = true;
    protected boolean loginAfterDisconnect;
    protected boolean invalidateSessionOnDisconnect;
    protected String redirectURL;
    protected boolean sessionRewritingEnabled = true;

    public BaseHTTPEndpoint() {
        this(false);
    }

    public BaseHTTPEndpoint(boolean enableManagement) {
        super(enableManagement);
    }

    @Override
    public void initialize(String id, ConfigMap properties) {
        super.initialize(id, properties);
        if (properties == null || properties.size() == 0) {
            return;
        }
        this.addNoCacheHeaders = properties.getPropertyAsBoolean(ADD_NO_CACHE_HEADERS, true);
        this.redirectURL = properties.getPropertyAsString(REDIRECT_URL, null);
        this.invalidateSessionOnDisconnect = properties.getPropertyAsBoolean(INVALIDATE_SESSION_ON_DISCONNECT, false);
        this.loginAfterDisconnect = properties.getPropertyAsBoolean("login-after-disconnect", false);
        this.sessionRewritingEnabled = properties.getPropertyAsBoolean(SESSION_REWRITING_ENABLED, true);
        this.initializeHttpResponseHeaders(properties);
        this.validateEndpointProtocol();
    }

    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        super.start();
        this.filterChain = this.createFilterChain();
    }

    public boolean isAddNoCacheHeaders() {
        return this.addNoCacheHeaders;
    }

    public void setAddNoCacheHeaders(boolean addNoCacheHeaders) {
        this.addNoCacheHeaders = addNoCacheHeaders;
    }

    public boolean isInvalidateSessionOnDisconnect() {
        return this.invalidateSessionOnDisconnect;
    }

    public void setInvalidateSessionOnDisconnect(boolean value) {
        this.invalidateSessionOnDisconnect = value;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public boolean isSessionRewritingEnabled() {
        return this.sessionRewritingEnabled;
    }

    public void setSessionRewritingEnabled(boolean value) {
        this.sessionRewritingEnabled = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void service(HttpServletRequest req, HttpServletResponse res) {
        super.service(req, res);
        try {
            this.setThreadLocals();
            ActionContext context = new ActionContext();
            context.setRecordMessageSizes(this.isRecordMessageSizes());
            context.setRecordMessageTimes(this.isRecordMessageTimes());
            this.filterChain.invoke(context);
            if (this.isManaged()) {
                this.controller.addToBytesDeserialized(context.getDeserializedBytes());
                this.controller.addToBytesSerialized(context.getSerializedBytes());
            }
            if (context.getStatus() != 2) {
                if (this.addNoCacheHeaders) {
                    BaseHTTPEndpoint.addNoCacheHeaders(req, res);
                }
                this.addHeadersToResponse(req, res);
                ByteArrayOutputStream outBuffer = context.getResponseOutput();
                res.setContentType(this.getResponseContentType());
                res.setContentLength(outBuffer.size());
                outBuffer.writeTo((OutputStream)res.getOutputStream());
                res.flushBuffer();
            } else if (this.redirectURL != null) {
                try {
                    this.redirectURL = SettingsReplaceUtil.replaceContextPath(this.redirectURL, req.getContextPath());
                    res.sendRedirect(this.redirectURL);
                }
                catch (IllegalStateException alreadyFlushed) {
                    // empty catch block
                }
            }
        }
        catch (IOException ioe) {
            this.log.info(ioe.getMessage());
            req.setAttribute("org.apache.flex.blazeds.internal._exception_info", (Object)ioe.toString());
        }
        catch (Throwable t) {
            this.log.error(t.getMessage(), t);
            req.setAttribute("org.apache.flex.blazeds.internal._exception_info", (Object)t.toString());
        }
        finally {
            this.clearThreadLocals();
        }
    }

    @Override
    public ConfigMap describeEndpoint() {
        ConfigMap endpointConfig = super.describeEndpoint();
        if (this.loginAfterDisconnect) {
            ConfigMap loginAfterDisconnect = new ConfigMap();
            loginAfterDisconnect.addProperty("", "true");
            ConfigMap properties = endpointConfig.getPropertyAsMap("properties", null);
            if (properties == null) {
                properties = new ConfigMap();
                endpointConfig.addProperty("properties", properties);
            }
            properties.addProperty("login-after-disconnect", loginAfterDisconnect);
        }
        return endpointConfig;
    }

    @Override
    public FlexClient setupFlexClient(String id) {
        int n;
        FlexClient flexClient = super.setupFlexClient(id);
        boolean duplicateSessionDetected = FlexContext.getHttpRequest().getAttribute(REQUEST_ATTR_DUPLICATE_SESSION_FLAG) != null;
        List<FlexSession> sessions = null;
        if (!duplicateSessionDetected && (n = (sessions = flexClient.getFlexSessions()).size()) > 1) {
            ArrayList<HttpFlexSession> httpFlexSessions = new ArrayList<HttpFlexSession>();
            for (int i = 0; i < n; ++i) {
                FlexSession currentSession = sessions.get(i);
                if (currentSession instanceof HttpFlexSession) {
                    httpFlexSessions.add((HttpFlexSession)currentSession);
                }
                if (httpFlexSessions.size() <= 1) continue;
                FlexContext.getHttpRequest().setAttribute(REQUEST_ATTR_DUPLICATE_SESSION_FLAG, httpFlexSessions);
                duplicateSessionDetected = true;
                break;
            }
        }
        if (duplicateSessionDetected) {
            Object attributeValue = FlexContext.getHttpRequest().getAttribute(REQUEST_ATTR_DUPLICATE_SESSION_FLAG);
            String newSessionId = null;
            String oldSessionId = null;
            if (attributeValue != null) {
                List httpFlexSessions = (List)attributeValue;
                oldSessionId = ((HttpFlexSession)httpFlexSessions.get(0)).getId();
                newSessionId = ((HttpFlexSession)httpFlexSessions.get(1)).getId();
            }
            if (sessions != null) {
                for (FlexSession session : sessions) {
                    if (!(session instanceof HttpFlexSession)) continue;
                    session.invalidate();
                }
            }
            DuplicateSessionException e = new DuplicateSessionException();
            e.setMessage(10035, new Object[]{flexClient.getId(), newSessionId, oldSessionId});
            throw e;
        }
        return flexClient;
    }

    protected void addHeadersToResponse(HttpServletRequest request, HttpServletResponse response) {
        if (this.httpResponseHeaders == null || this.httpResponseHeaders.isEmpty()) {
            return;
        }
        String origin = request.getHeader(HEADER_NAME_ORIGIN);
        boolean originHeaderExists = origin != null && origin.length() != 0;
        for (HttpHeader header : this.httpResponseHeaders) {
            if (header.name.startsWith(ACCESS_CONTROL) && !originHeaderExists) continue;
            response.addHeader(header.name, header.value);
        }
    }

    protected abstract AMFFilter createFilterChain();

    protected abstract String getResponseContentType();

    @Override
    protected String getSecureProtocolScheme() {
        return HTTPS_PROTOCOL_SCHEME;
    }

    @Override
    protected String getInsecureProtocolScheme() {
        return HTTP_PROTOCOL_SCHEME;
    }

    @Override
    protected Message handleChannelDisconnect(CommandMessage disconnectCommand) {
        HttpFlexSession session = (HttpFlexSession)FlexContext.getFlexSession();
        FlexClient flexClient = FlexContext.getFlexClient();
        if (flexClient.isValid()) {
            String endpointId = this.getId();
            List<MessageClient> messageClients = flexClient.getMessageClients();
            for (MessageClient messageClient : messageClients) {
                if (!messageClient.getEndpointId().equals(endpointId)) continue;
                messageClient.setClientChannelDisconnected(true);
                messageClient.invalidate();
            }
        }
        if (session.isValid() && this.isInvalidateSessionOnDisconnect()) {
            session.invalidate(false);
        }
        return super.handleChannelDisconnect(disconnectCommand);
    }

    protected void initializeHttpResponseHeaders(ConfigMap properties) {
        if (!properties.containsKey((Object)HTTP_RESPONSE_HEADERS)) {
            return;
        }
        ConfigMap httpResponseHeaders = properties.getPropertyAsMap(HTTP_RESPONSE_HEADERS, null);
        if (httpResponseHeaders == null) {
            return;
        }
        List headers = httpResponseHeaders.getPropertyAsList(HEADER_ATTR, null);
        if (headers == null || headers.isEmpty()) {
            return;
        }
        if (this.httpResponseHeaders == null) {
            this.httpResponseHeaders = new ArrayList<HttpHeader>();
        }
        for (String header : headers) {
            int colonIndex = header.indexOf(":");
            String name = header.substring(0, colonIndex).trim();
            String value = header.substring(colonIndex + 1).trim();
            this.httpResponseHeaders.add(new HttpHeader(name, value));
        }
    }

    static class HttpHeader {
        public final String name;
        public final String value;

        public HttpHeader(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

