/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io;

import flex.messaging.io.ArrayList;
import flex.messaging.io.PageableRowSet;
import flex.messaging.util.UUIDUtils;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.RowSet;

public class PagedRowSet
implements PageableRowSet {
    private RowSet rowSet;
    private String[] colNames;
    private int pageSize = 50;
    private int colCount = 0;
    private int rowCount = 0;
    private String id = null;
    private String serviceName = "PageableRowSetCache";
    public static final String DEFAULT_PAGING_SERVICE_NAME = "PageableRowSetCache";

    public PagedRowSet(RowSet r, int p) {
        this.rowSet = r;
        this.pageSize = p;
        this.id = UUIDUtils.createUUID();
        this.init();
    }

    public PagedRowSet(RowSet r, int p, boolean createID) {
        this.rowSet = r;
        this.pageSize = p;
        if (createID) {
            this.id = UUIDUtils.createUUID();
        }
        this.init();
    }

    private void init() {
        if (this.rowSet != null) {
            this.initColumns();
            this.initRecords();
        } else {
            this.colNames = new String[0];
        }
    }

    private synchronized void initColumns() {
        try {
            ResultSetMetaData rsmd = this.rowSet.getMetaData();
            if (rsmd != null) {
                this.colCount = rsmd.getColumnCount();
            }
        }
        catch (SQLException ex) {
            this.colCount = 0;
        }
    }

    private synchronized void initRecords() {
        if (this.rowSet != null) {
            try {
                int currentIndex = this.rowSet.getRow();
                if (this.rowSet.last()) {
                    this.rowCount = this.rowSet.getRow();
                }
                if (currentIndex > 0) {
                    this.rowSet.absolute(currentIndex);
                } else {
                    this.rowSet.beforeFirst();
                }
            }
            catch (SQLException ex) {
                try {
                    this.rowSet.first();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public synchronized String[] getColumnNames() {
        if (this.colNames == null) {
            try {
                if (this.colCount == 0) {
                    this.initColumns();
                }
                this.colNames = new String[this.colCount];
                for (int i = 0; i < this.colCount; ++i) {
                    this.colNames[i] = this.rowSet.getMetaData().getColumnName(i + 1);
                }
            }
            catch (SQLException ex) {
                this.colNames = new String[0];
            }
        }
        String[] ret = new String[this.colNames.length];
        System.arraycopy(this.colNames, 0, ret, 0, this.colNames.length);
        return ret;
    }

    @Override
    public synchronized Map getRecords(int startIndex, int count) throws SQLException {
        ArrayList aRecords = new ArrayList();
        if (this.colCount == 0) {
            this.initColumns();
        }
        if (startIndex < 1) {
            startIndex = 1;
        }
        if (this.rowSet.absolute(startIndex)) {
            for (int i = 0; i < count; ++i) {
                ArrayList row;
                if (this.colCount > 0) {
                    row = new ArrayList(this.rowCount + 1);
                    for (int j = 1; j <= this.colCount; ++j) {
                        Object data = this.rowSet.getObject(j);
                        if (data instanceof Clob) {
                            Clob clob = (Clob)data;
                            row.add(clob.getSubString(0L, (int)clob.length()));
                            continue;
                        }
                        if (data instanceof Blob) {
                            Blob blob = (Blob)data;
                            byte[] bytes = blob.getBytes(1L, (int)blob.length());
                            row.add(bytes);
                            continue;
                        }
                        row.add(data);
                    }
                } else {
                    row = new ArrayList();
                    try {
                        Object o;
                        for (int j = 1; j <= 50 && (o = this.rowSet.getObject(j)) != null; ++j) {
                            row.add(o);
                        }
                    }
                    catch (SQLException ex) {
                        // empty catch block
                    }
                }
                aRecords.add(row.toArray());
                boolean hasNext = this.rowSet.next();
                if (!hasNext) break;
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("Page", aRecords.toArray());
        result.put("Cursor", startIndex);
        return result;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getInitialDownloadCount() {
        return this.pageSize;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public void setServicename(String serviceName) {
        this.serviceName = serviceName;
    }
}

