/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io;

import flex.messaging.LocalizedException;
import flex.messaging.MessageException;
import flex.messaging.io.AbstractProxy;
import flex.messaging.io.BeanProxy;
import flex.messaging.io.DictionaryProxy;
import flex.messaging.io.MapProxy;
import flex.messaging.io.PageableRowSet;
import flex.messaging.io.PageableRowSetProxy;
import flex.messaging.io.PropertyProxy;
import flex.messaging.io.ThrowableProxy;
import flex.messaging.io.amf.ASObject;
import java.util.AbstractMap;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.sql.RowSet;

public class PropertyProxyRegistry {
    private final Map<Class, PropertyProxy> classRegistry = new IdentityHashMap<Class, PropertyProxy>();
    private static final PropertyProxyRegistry registry = new PropertyProxyRegistry();

    public static PropertyProxyRegistry getRegistry() {
        return registry;
    }

    public static void release() {
        registry.clear();
        PropertyProxyRegistry.preRegister();
    }

    private static void preRegister() {
        ThrowableProxy proxy = new ThrowableProxy();
        registry.register(MessageException.class, proxy);
        registry.register(LocalizedException.class, proxy);
        registry.register(Throwable.class, proxy);
        MapProxy mapProxy = new MapProxy();
        registry.register(ASObject.class, mapProxy);
        registry.register(HashMap.class, mapProxy);
        registry.register(AbstractMap.class, mapProxy);
        registry.register(Map.class, mapProxy);
    }

    public static PropertyProxy getProxyAndRegister(Object instance) {
        if (instance instanceof PropertyProxy) {
            return (PropertyProxy)instance;
        }
        Class<?> c = instance.getClass();
        PropertyProxy proxy = PropertyProxyRegistry.getRegistry().getProxyAndRegister(c);
        if (proxy == null) {
            proxy = PropertyProxyRegistry.guessProxy(instance);
            PropertyProxyRegistry.getRegistry().register(c, proxy);
        }
        return proxy;
    }

    public static PropertyProxy getProxy(Object instance) {
        if (instance instanceof PropertyProxy) {
            return (PropertyProxy)instance;
        }
        Class<?> c = instance.getClass();
        PropertyProxy proxy = PropertyProxyRegistry.getRegistry().getProxy(c);
        if (proxy == null) {
            proxy = PropertyProxyRegistry.guessProxy(instance);
        }
        proxy = (PropertyProxy)proxy.clone();
        proxy.setDefaultInstance(instance);
        return proxy;
    }

    private static PropertyProxy guessProxy(Object instance) {
        AbstractProxy proxy = instance instanceof Map ? new MapProxy() : (instance instanceof Throwable ? new ThrowableProxy() : (instance instanceof PageableRowSet || instance instanceof RowSet ? new PageableRowSetProxy() : (instance instanceof Dictionary ? new DictionaryProxy() : new BeanProxy())));
        return proxy;
    }

    public PropertyProxy getProxy(Class c) {
        return this.getProxy(c, true, false);
    }

    public PropertyProxy getProxyAndRegister(Class c) {
        return this.getProxy(c, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyProxy getProxy(Class c, boolean searchHierarchy, boolean autoRegister) {
        Class<?> superclass;
        if (c == null) {
            return null;
        }
        if (c.isArray()) {
            c = c.getComponentType();
        }
        PropertyProxy proxy = null;
        Map<Class, PropertyProxy> map = this.classRegistry;
        synchronized (map) {
            proxy = this.classRegistry.get(c);
        }
        if (proxy == null && searchHierarchy) {
            Class<?>[] interfaces = c.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> interfaceClass = interfaces[i];
                Map<Class, PropertyProxy> map2 = this.classRegistry;
                synchronized (map2) {
                    proxy = this.classRegistry.get(interfaceClass);
                }
                if (proxy != null && autoRegister) {
                    this.register(c, proxy);
                    break;
                }
                proxy = this.getProxy(interfaceClass, searchHierarchy, autoRegister);
                if (proxy != null) break;
            }
        }
        if (proxy == null && searchHierarchy && (superclass = c.getSuperclass()) != null && (proxy = this.getProxy(superclass, searchHierarchy, autoRegister)) != null && autoRegister) {
            this.register(c, proxy);
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<Class, PropertyProxy> map = this.classRegistry;
        synchronized (map) {
            this.classRegistry.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Class c, PropertyProxy proxy) {
        Map<Class, PropertyProxy> map = this.classRegistry;
        synchronized (map) {
            this.classRegistry.put(c, proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Class c) {
        Map<Class, PropertyProxy> map = this.classRegistry;
        synchronized (map) {
            this.classRegistry.remove(c);
        }
    }

    static {
        PropertyProxyRegistry.preRegister();
    }
}

