/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import flex.messaging.util.ExceptionUtil;
import java.util.Date;

public class Trace {
    public static final boolean config = System.getProperty("trace.config") != null;
    public static final boolean amf = System.getProperty("trace.amf") != null;
    public static final boolean remote = amf || System.getProperty("trace.remote") != null;
    public static final boolean ssl = System.getProperty("trace.ssl") != null;
    public static final boolean rtmp = System.getProperty("trace.rtmp") != null;
    public static final boolean command = rtmp || System.getProperty("trace.command") != null;
    public static final boolean error = rtmp || System.getProperty("trace.error") != null;
    public static final boolean message = rtmp || System.getProperty("trace.message") != null;
    public static final boolean resolve = rtmp || System.getProperty("trace.resolve") != null;
    public static final boolean transport = rtmp || System.getProperty("trace.transport") != null;
    public static final boolean ack = rtmp || System.getProperty("trace.ack") != null;
    public static final boolean io = rtmp || System.getProperty("trace.io") != null;
    public static final boolean threadpool = rtmp || System.getProperty("trace.threadpool") != null;
    public static final boolean caller = System.getProperty("trace.caller") != null;
    public static final String stackPrefix = System.getProperty("trace.stackPrefix");
    public static int stackLines = 0;
    public static final boolean timeStamp;

    public static void trace(String str) {
        if (timeStamp) {
            System.err.print(new Date());
        }
        if (caller) {
            System.err.print(ExceptionUtil.getCallAt((Throwable)new Throwable(), (int)1) + " ");
        }
        System.err.println(str);
        if (stackLines > 0) {
            System.err.println(ExceptionUtil.getStackTraceLines((Throwable)new Throwable(), (int)stackLines));
        } else if (stackPrefix != null) {
            System.err.println(ExceptionUtil.getStackTraceUpTo((Throwable)new Throwable(), (String)stackPrefix));
        }
    }

    static {
        try {
            stackLines = Integer.parseInt(System.getProperty("trace.stackLines"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        timeStamp = System.getProperty("trace.timeStamp") != null;
    }
}

