/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.messaging;

import flex.messaging.config.ThrottleSettings;
import flex.messaging.services.messaging.ThrottleManager;

public class MessageFrequency {
    public final int messageHistorySize;
    private int messageCount;
    private long[] previousMessageTimes;

    public MessageFrequency(int messageHistorySize) {
        this.messageHistorySize = messageHistorySize;
        this.messageCount = 0;
        this.previousMessageTimes = new long[messageHistorySize];
    }

    public ThrottleManager.ThrottleResult checkLimit(int maxFrequency, ThrottleSettings.Policy policy) {
        long messageTimestamp = System.currentTimeMillis();
        if (maxFrequency > -1 && this.messageCount >= this.messageHistorySize) {
            double actualFrequency;
            int index = this.messageCount % this.messageHistorySize;
            long intervalMillis = messageTimestamp - this.previousMessageTimes[index];
            double intervalSeconds = (double)intervalMillis / 1000.0;
            if (intervalSeconds > 0.0) {
                actualFrequency = (double)this.messageHistorySize / intervalSeconds;
                actualFrequency = (double)Math.round(actualFrequency * 100.0) / 100.0;
            } else {
                actualFrequency = maxFrequency + 1;
            }
            if (maxFrequency > 0 && actualFrequency > (double)maxFrequency) {
                ThrottleManager.ThrottleResult.Result result = ThrottleManager.getResult(policy);
                String detail = "[actual-frequency=" + actualFrequency + ", max-frequency=" + maxFrequency + "]";
                return new ThrottleManager.ThrottleResult(result, detail);
            }
        }
        return new ThrottleManager.ThrottleResult();
    }

    public void updateMessageFrequency() {
        this.messageCount = this.messageCount == Integer.MAX_VALUE ? 0 : this.messageCount;
        this.previousMessageTimes[this.messageCount++ % this.messageHistorySize] = System.currentTimeMillis();
    }
}

