/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.util.SerializableObject;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.streaming.util.serialization.SerializationSchema;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public class SocketClientSink<IN>
extends RichSinkFunction<IN> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(SocketClientSink.class);
    private static final int CONNECTION_RETRY_DELAY = 500;
    private final SerializableObject lock = new SerializableObject();
    private final SerializationSchema<IN> schema;
    private final String hostName;
    private final int port;
    private final int maxNumRetries;
    private final boolean autoFlush;
    private transient Socket client;
    private transient OutputStream outputStream;
    private int retries;
    private volatile boolean isRunning = true;

    public SocketClientSink(String hostName, int port, SerializationSchema<IN> schema) {
        this(hostName, port, schema, 0);
    }

    public SocketClientSink(String hostName, int port, SerializationSchema<IN> schema, int maxNumRetries) {
        this(hostName, port, schema, maxNumRetries, false);
    }

    public SocketClientSink(String hostName, int port, SerializationSchema<IN> schema, int maxNumRetries, boolean autoflush) {
        Preconditions.checkArgument((port > 0 && port < 65536 ? 1 : 0) != 0, (Object)"port is out of range");
        Preconditions.checkArgument((maxNumRetries >= -1 ? 1 : 0) != 0, (Object)"maxNumRetries must be zero or larger (num retries), or -1 (infinite retries)");
        this.hostName = (String)Preconditions.checkNotNull((Object)hostName, (String)"hostname must not be null");
        this.port = port;
        this.schema = (SerializationSchema)Preconditions.checkNotNull(schema);
        this.maxNumRetries = maxNumRetries;
        this.autoFlush = autoflush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(Configuration parameters) throws Exception {
        try {
            SerializableObject serializableObject = this.lock;
            synchronized (serializableObject) {
                this.createConnection();
            }
        }
        catch (IOException e) {
            throw new IOException("Cannot connect to socket server at " + this.hostName + ":" + this.port, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(IN value) throws Exception {
        byte[] msg = this.schema.serialize(value);
        try {
            this.outputStream.write(msg);
            if (this.autoFlush) {
                this.outputStream.flush();
            }
        }
        catch (IOException e) {
            if (this.maxNumRetries == 0) {
                throw new IOException("Failed to send message '" + value + "' to socket server at " + this.hostName + ":" + this.port + ". Connection re-tries are not enabled.", e);
            }
            LOG.error("Failed to send message '" + value + "' to socket server at " + this.hostName + ":" + this.port + ". Trying to reconnect...", (Throwable)e);
            SerializableObject serializableObject = this.lock;
            synchronized (serializableObject) {
                IOException lastException = null;
                this.retries = 0;
                while (this.isRunning && (this.maxNumRetries < 0 || this.retries < this.maxNumRetries)) {
                    try {
                        if (this.outputStream != null) {
                            this.outputStream.close();
                        }
                    }
                    catch (IOException ee) {
                        LOG.error("Could not close output stream from failed write attempt", (Throwable)ee);
                    }
                    try {
                        if (this.client != null) {
                            this.client.close();
                        }
                    }
                    catch (IOException ee) {
                        LOG.error("Could not close socket from failed write attempt", (Throwable)ee);
                    }
                    ++this.retries;
                    try {
                        this.createConnection();
                        this.outputStream.write(msg);
                        return;
                    }
                    catch (IOException ee) {
                        lastException = ee;
                        LOG.error("Re-connect to socket server and send message failed. Retry time(s): " + this.retries, (Throwable)ee);
                        this.lock.wait(500L);
                    }
                }
                if (this.isRunning) {
                    throw new IOException("Failed to send message '" + value + "' to socket server at " + this.hostName + ":" + this.port + ". Failed after " + this.retries + " retries.", lastException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        this.isRunning = false;
        SerializableObject serializableObject = this.lock;
        synchronized (serializableObject) {
            this.lock.notifyAll();
            try {
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
            }
            finally {
                if (this.client != null) {
                    this.client.close();
                }
            }
        }
    }

    private void createConnection() throws IOException {
        this.client = new Socket(this.hostName, this.port);
        this.client.setKeepAlive(true);
        this.client.setTcpNoDelay(true);
        this.outputStream = this.client.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCurrentNumberOfRetries() {
        SerializableObject serializableObject = this.lock;
        synchronized (serializableObject) {
            return this.retries;
        }
    }
}

