/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.windows;

import java.io.IOException;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.streaming.api.windowing.windows.Window;

@PublicEvolving
public class GlobalWindow
extends Window {
    private static GlobalWindow INSTANCE = new GlobalWindow();

    private GlobalWindow() {
    }

    public static GlobalWindow get() {
        return INSTANCE;
    }

    @Override
    public long maxTimestamp() {
        return Long.MAX_VALUE;
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "GlobalWindow";
    }

    public static class Serializer
    extends TypeSerializer<GlobalWindow> {
        private static final long serialVersionUID = 1L;

        public boolean isImmutableType() {
            return true;
        }

        public TypeSerializer<GlobalWindow> duplicate() {
            return this;
        }

        public GlobalWindow createInstance() {
            return INSTANCE;
        }

        public GlobalWindow copy(GlobalWindow from) {
            return from;
        }

        public GlobalWindow copy(GlobalWindow from, GlobalWindow reuse) {
            return from;
        }

        public int getLength() {
            return 0;
        }

        public void serialize(GlobalWindow record, DataOutputView target) throws IOException {
            target.writeByte(0);
        }

        public GlobalWindow deserialize(DataInputView source) throws IOException {
            source.readByte();
            return INSTANCE;
        }

        public GlobalWindow deserialize(GlobalWindow reuse, DataInputView source) throws IOException {
            source.readByte();
            return INSTANCE;
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            source.readByte();
            target.writeByte(0);
        }

        public boolean equals(Object obj) {
            return obj instanceof Serializer;
        }

        public boolean canEqual(Object obj) {
            return obj instanceof Serializer;
        }

        public int hashCode() {
            return 0;
        }
    }
}

