/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.TimerService;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;

@Internal
public class ProcessOperator<IN, OUT>
extends AbstractUdfStreamOperator<OUT, ProcessFunction<IN, OUT>>
implements OneInputStreamOperator<IN, OUT> {
    private static final long serialVersionUID = 1L;
    private transient TimestampedCollector<OUT> collector;
    private transient ContextImpl context;
    private long currentWatermark = Long.MIN_VALUE;

    public ProcessOperator(ProcessFunction<IN, OUT> function) {
        super(function);
        this.chainingStrategy = ChainingStrategy.ALWAYS;
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.collector = new TimestampedCollector(this.output);
        this.context = new ContextImpl((ProcessFunction)this.userFunction, this.getProcessingTimeService());
    }

    @Override
    public void processElement(StreamRecord<IN> element) throws Exception {
        this.collector.setTimestamp(element);
        this.context.element = element;
        ((ProcessFunction)this.userFunction).processElement(element.getValue(), this.context, this.collector);
        this.context.element = null;
    }

    @Override
    public void processWatermark(Watermark mark) throws Exception {
        super.processWatermark(mark);
        this.currentWatermark = mark.getTimestamp();
    }

    private class ContextImpl
    extends ProcessFunction.Context
    implements TimerService {
        private StreamRecord<IN> element;
        private final ProcessingTimeService processingTimeService;

        ContextImpl(ProcessFunction<IN, OUT> function, ProcessingTimeService processingTimeService) {
            super(function);
            this.processingTimeService = processingTimeService;
        }

        @Override
        public Long timestamp() {
            Preconditions.checkState((this.element != null ? 1 : 0) != 0);
            if (this.element.hasTimestamp()) {
                return this.element.getTimestamp();
            }
            return null;
        }

        @Override
        public <X> void output(OutputTag<X> outputTag, X value) {
            if (outputTag == null) {
                throw new IllegalArgumentException("OutputTag must not be null.");
            }
            ProcessOperator.this.output.collect(outputTag, new StreamRecord<X>(value, this.element.getTimestamp()));
        }

        @Override
        public long currentProcessingTime() {
            return this.processingTimeService.getCurrentProcessingTime();
        }

        @Override
        public long currentWatermark() {
            return ProcessOperator.this.currentWatermark;
        }

        @Override
        public void registerProcessingTimeTimer(long time) {
            throw new UnsupportedOperationException("Setting timers is only supported on a KeyedStream.");
        }

        @Override
        public void registerEventTimeTimer(long time) {
            throw new UnsupportedOperationException("Setting timers is only supported on a KeyedStream.");
        }

        @Override
        public TimerService timerService() {
            return this;
        }
    }
}

