/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.async.queue;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.operators.async.queue.AsyncCollectionResult;
import org.apache.flink.streaming.api.operators.async.queue.AsyncResult;
import org.apache.flink.streaming.api.operators.async.queue.AsyncWatermarkResult;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class StreamElementQueueEntry<T>
implements AsyncResult {
    private final StreamElement streamElement;

    public StreamElementQueueEntry(StreamElement streamElement) {
        this.streamElement = (StreamElement)Preconditions.checkNotNull((Object)streamElement);
    }

    public StreamElement getStreamElement() {
        return this.streamElement;
    }

    public boolean isDone() {
        return this.getFuture().isDone();
    }

    public void onComplete(Consumer<StreamElementQueueEntry<T>> completeFunction, Executor executor) {
        StreamElementQueueEntry thisReference = this;
        this.getFuture().whenCompleteAsync((value, throwable) -> completeFunction.accept(thisReference), executor);
    }

    protected abstract CompletableFuture<T> getFuture();

    @Override
    public final boolean isWatermark() {
        return AsyncWatermarkResult.class.isAssignableFrom(this.getClass());
    }

    @Override
    public final boolean isResultCollection() {
        return AsyncCollectionResult.class.isAssignableFrom(this.getClass());
    }

    @Override
    public final AsyncWatermarkResult asWatermark() {
        return (AsyncWatermarkResult)((Object)this);
    }

    @Override
    public final <T> AsyncCollectionResult<T> asResultCollection() {
        return (AsyncCollectionResult)((Object)this);
    }
}

