/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBiVisitor;
import org.apache.calcite.rex.RexDigestIncludeType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexNormalize;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

public class RexCall
extends RexNode {
    public final SqlOperator op;
    public final ImmutableList<RexNode> operands;
    public final RelDataType type;
    public final int nodeCount;
    protected int hash = 0;
    private Pair<SqlOperator, List<RexNode>> normalized;

    protected RexCall(RelDataType type, SqlOperator op, List<? extends RexNode> operands) {
        this.type = Objects.requireNonNull(type, "type");
        this.op = Objects.requireNonNull(op, "operator");
        this.operands = ImmutableList.copyOf(operands);
        this.nodeCount = RexUtil.nodeCount(1, this.operands);
        assert (op.getKind() != null) : op;
        assert (op.validRexOperands(operands.size(), Litmus.THROW)) : this;
        assert (op.kind != SqlKind.IN || this instanceof RexSubQuery);
    }

    protected final void appendOperands(StringBuilder sb) {
        if (this.operands.isEmpty()) {
            return;
        }
        ArrayList<String> operandDigests = new ArrayList<String>(this.operands.size());
        for (int i = 0; i < this.operands.size(); ++i) {
            RexNode otherArg;
            RexNode operand = (RexNode)this.operands.get(i);
            if (!(operand instanceof RexLiteral)) {
                operandDigests.add(operand.toString());
                continue;
            }
            RexDigestIncludeType includeType = RexDigestIncludeType.OPTIONAL;
            if ((this.isA(SqlKind.AND) || this.isA(SqlKind.OR)) && operand.getType().getSqlTypeName() == SqlTypeName.BOOLEAN) {
                includeType = RexDigestIncludeType.NO_TYPE;
            }
            if (SqlKind.SIMPLE_BINARY_OPS.contains((Object)this.getKind()) && (!((otherArg = (RexNode)this.operands.get(1 - i)) instanceof RexLiteral) || ((RexLiteral)otherArg).digestIncludesType() == RexDigestIncludeType.NO_TYPE) && SqlTypeUtil.equalSansNullability(operand.getType(), otherArg.getType())) {
                includeType = RexDigestIncludeType.NO_TYPE;
            }
            operandDigests.add(((RexLiteral)operand).computeDigest(includeType));
        }
        int totalLength = (operandDigests.size() - 1) * 2;
        for (String s : operandDigests) {
            totalLength += s.length();
        }
        sb.ensureCapacity(sb.length() + totalLength);
        for (int i = 0; i < operandDigests.size(); ++i) {
            String op = (String)operandDigests.get(i);
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(op);
        }
    }

    @Nonnull
    protected String computeDigest(boolean withType) {
        StringBuilder sb = new StringBuilder(this.op.getName());
        if (this.operands.size() != 0 || this.op.getSyntax() != SqlSyntax.FUNCTION_ID) {
            sb.append("(");
            this.appendOperands(sb);
            sb.append(")");
        }
        if (withType) {
            sb.append(":");
            sb.append(this.type.getFullTypeString());
        }
        return sb.toString();
    }

    @Override
    @Nonnull
    public final String toString() {
        return this.computeDigest(this.digestWithType());
    }

    private boolean digestWithType() {
        return this.isA(SqlKind.CAST) || this.isA(SqlKind.NEW_SPECIFICATION);
    }

    @Override
    public <R> R accept(RexVisitor<R> visitor) {
        return visitor.visitCall(this);
    }

    @Override
    public <R, P> R accept(RexBiVisitor<R, P> visitor, P arg) {
        return visitor.visitCall(this, arg);
    }

    @Override
    public RelDataType getType() {
        return this.type;
    }

    @Override
    public boolean isAlwaysTrue() {
        switch (this.getKind()) {
            case IS_NOT_NULL: {
                return !((RexNode)this.operands.get(0)).getType().isNullable();
            }
            case IS_NOT_TRUE: 
            case IS_FALSE: 
            case NOT: {
                return ((RexNode)this.operands.get(0)).isAlwaysFalse();
            }
            case IS_NOT_FALSE: 
            case IS_TRUE: 
            case CAST: {
                return ((RexNode)this.operands.get(0)).isAlwaysTrue();
            }
        }
        return false;
    }

    @Override
    public boolean isAlwaysFalse() {
        switch (this.getKind()) {
            case IS_NULL: {
                return !((RexNode)this.operands.get(0)).getType().isNullable();
            }
            case IS_NOT_TRUE: 
            case IS_FALSE: 
            case NOT: {
                return ((RexNode)this.operands.get(0)).isAlwaysTrue();
            }
            case IS_NOT_FALSE: 
            case IS_TRUE: 
            case CAST: {
                return ((RexNode)this.operands.get(0)).isAlwaysFalse();
            }
        }
        return false;
    }

    @Override
    public SqlKind getKind() {
        return this.op.kind;
    }

    public List<RexNode> getOperands() {
        return this.operands;
    }

    public SqlOperator getOperator() {
        return this.op;
    }

    @Override
    public int nodeCount() {
        return this.nodeCount;
    }

    public RexCall clone(RelDataType type, List<RexNode> operands) {
        return new RexCall(type, this.op, operands);
    }

    private Pair<SqlOperator, List<RexNode>> getNormalized() {
        if (this.normalized == null) {
            this.normalized = RexNormalize.normalize(this.op, this.operands);
        }
        return this.normalized;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair<SqlOperator, List<RexNode>> x = this.getNormalized();
        RexCall rexCall = (RexCall)o;
        Pair<SqlOperator, List<RexNode>> y = rexCall.getNormalized();
        return ((SqlOperator)x.left).equals(y.left) && ((List)x.right).equals(y.right) && this.type.equals(rexCall.type);
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            this.hash = RexNormalize.hashCode(this.op, this.operands);
        }
        return this.hash;
    }
}

