/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.calcite.sql.SqlDrop;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;

public class SqlDropFunction
extends SqlDrop {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("DROP FUNCTION", SqlKind.DROP_FUNCTION);
    private final SqlIdentifier functionIdentifier;
    private final boolean isTemporary;
    private final boolean isSystemFunction;

    public SqlDropFunction(SqlParserPos pos, SqlIdentifier functionIdentifier, boolean ifExists, boolean isTemporary, boolean isSystemFunction) {
        super(OPERATOR, pos, ifExists);
        this.functionIdentifier = Objects.requireNonNull(functionIdentifier);
        this.isSystemFunction = isSystemFunction;
        this.isTemporary = isTemporary;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.functionIdentifier);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DROP");
        if (this.isTemporary) {
            writer.keyword("TEMPORARY");
        }
        if (this.isSystemFunction) {
            writer.keyword("SYSTEM");
        }
        writer.keyword("FUNCTION");
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.functionIdentifier.unparse(writer, leftPrec, rightPrec);
    }

    public String[] getFunctionIdentifier() {
        return this.functionIdentifier.names.toArray(new String[0]);
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public boolean isSystemFunction() {
        return this.isSystemFunction;
    }

    public boolean getIfExists() {
        return this.ifExists;
    }
}

